/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dashboard.webui.component;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.exoplatform.dashboard.webui.component.UIWebOSTabPaneDashboard;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webos.webui.page.UIDesktopPage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/dashboard/UIWebOSTabPaneDashboard.gtmpl", events={@EventConfig(confirm="UIWebOSTabPaneDashboard.msg.deleteTab", name="DeleteTab", listeners={DeleteTabActionListener.class}), @EventConfig(name="AddDashboard", listeners={AddDashboardActionListener.class}), @EventConfig(name="RenameTabLabel", listeners={RenameTabLabelActionListener.class})})
public class UIWebOSTabPaneDashboard
extends UIContainer {
    private static Log logger = ExoLogger.getExoLogger(UIWebOSTabPaneDashboard.class);
    private UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
    private DataStorage dataService = (DataStorage)this.getApplicationComponent(DataStorage.class);
    private UIPortal uiPortal = Util.getUIPortal();
    private UserNode cachedParent;
    public static final String PAGE_TEMPLATE = "dashboard";
    private final UserNodeFilterConfig filterConfig;
    private static final Scope TAB_PANE_DASHBOARD_SCOPE = Scope.CHILDREN;

    public UIWebOSTabPaneDashboard() throws Exception {
        UserNodeFilterConfig.Builder scopeBuilder = UserNodeFilterConfig.builder();
        scopeBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
        scopeBuilder.withTemporalCheck();
        this.filterConfig = scopeBuilder.build();
    }

    private int getCurrentNumberOfTabs() throws Exception {
        return this.getSameSiblingsNode().size();
    }

    public UserNode getParentTab() throws Exception {
        UserPortal userPortal = this.getUserPortal();
        UserNode selectedNode = this.uiPortal.getSelectedUserNode();
        UserNode currParent = selectedNode.getParent();
        UserNode parent = this.cachedParent;
        if (parent == null || currParent != null && !currParent.getId().equals(parent.getId())) {
            this.cachedParent = "".equals(currParent.getURI()) ? userPortal.getNode(currParent.getNavigation(), TAB_PANE_DASHBOARD_SCOPE, this.filterConfig, null) : userPortal.resolvePath(currParent.getNavigation(), this.filterConfig, currParent.getURI());
            parent = this.cachedParent;
        }
        if (parent != null) {
            try {
                userPortal.updateNode(parent, TAB_PANE_DASHBOARD_SCOPE, null);
            }
            catch (NavigationServiceException e) {
                parent = null;
            }
        }
        this.cachedParent = parent;
        return parent;
    }

    public Collection<UserNode> getSameSiblingsNode() throws Exception {
        UserNode parentTab = this.getParentTab();
        if (parentTab == null) {
            return Collections.emptyList();
        }
        return this.filterWebOSNode(parentTab.getChildren());
    }

    public String getFirstAvailableURI() throws Exception {
        UserNode parentTab = this.getParentTab();
        if (parentTab != null) {
            UserNode currNode = Util.getUIPortal().getSelectedUserNode();
            if (parentTab.getChildren().size() == 0 && parentTab.getURI() != null) {
                return parentTab.getURI();
            }
            if (parentTab.getChild(currNode.getName()) != null) {
                return currNode.getURI();
            }
            return parentTab.getChild(0).getURI();
        }
        return this.getUserPortal().getDefaultPath(null).getURI();
    }

    private Collection<UserNode> filterWebOSNode(Collection<UserNode> pageNodes) throws Exception {
        if (pageNodes == null || pageNodes.size() == 0) {
            return pageNodes;
        }
        ArrayList<UserNode> tempNodes = new ArrayList<UserNode>(pageNodes);
        for (int i = 0; i < tempNodes.size(); ++i) {
            UserNode node = (UserNode)tempNodes.get(i);
            if (!this.isWebOSNode(node)) continue;
            tempNodes.remove(node);
        }
        return tempNodes;
    }

    private boolean isWebOSNode(UserNode pageNode) throws Exception {
        if (pageNode == null) {
            return false;
        }
        String pageRef = pageNode.getPageRef();
        if (pageRef == null) {
            return false;
        }
        DataStorage ds = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Page page = ds.getPage(pageRef);
        return page == null || UIDesktopPage.DESKTOP_FACTORY_ID.equals(page.getFactoryId());
    }

    private UserNavigation getCurrentUserNavigation() throws Exception {
        UserPortal userPortal = this.getUserPortal();
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return userPortal.getNavigation(SiteKey.user((String)rcontext.getRemoteUser()));
    }

    private UserPortal getUserPortal() {
        UIPortalApplication uiApp = Util.getUIPortalApplication();
        return uiApp.getUserPortalConfig().getUserPortal();
    }

    private UserNode removePageNode(String nodeName) {
        try {
            UserNode parentNode = this.getParentTab();
            if (parentNode == null || parentNode.getChild(nodeName) == null) {
                return null;
            }
            UserNode tobeRemoved = parentNode.getChild(nodeName);
            UserNode prevNode = null;
            if (parentNode.getChildrenCount() >= 2) {
                String pageRef;
                for (UserNode child : parentNode.getChildren()) {
                    if (child.getName().equals(nodeName)) {
                        parentNode.removeChild(nodeName);
                        break;
                    }
                    prevNode = child;
                }
                if ((pageRef = tobeRemoved.getPageRef()) != null && pageRef.length() > 0) {
                    Page page = this.configService.getPage(pageRef);
                    if (page != null) {
                        this.dataService.remove(page);
                    }
                    UIPortal uiPortal = Util.getUIPortal();
                    uiPortal.setUIPage(pageRef, null);
                }
            } else {
                ((UIApplication)this.getAncestorOfType(UIApplication.class)).addMessage(new ApplicationMessage("UIWebOSTabPaneDashboard.msg.cannotDeleteLastTab", null));
                return null;
            }
            this.getUserPortal().saveNode(parentNode, null);
            UserNode selectedNode = this.uiPortal.getSelectedUserNode();
            if (nodeName.equals(selectedNode.getName())) {
                selectedNode = prevNode != null ? prevNode : (UserNode)parentNode.getChildren().iterator().next();
            }
            return selectedNode;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String createNewPageNode(String nodeLabel) {
        try {
            if (nodeLabel == null || nodeLabel.length() == 0) {
                nodeLabel = "Tab_" + this.getCurrentNumberOfTabs();
            }
            UserNavigation userNav = this.getCurrentUserNavigation();
            UserNode parentNode = this.getParentTab();
            if (userNav == null || parentNode == null) {
                return null;
            }
            String uniqueNodeName = nodeLabel.toLowerCase().replace(' ', '_');
            SiteKey siteKey = userNav.getKey();
            Page page = this.configService.createPageTemplate(PAGE_TEMPLATE, siteKey.getTypeName(), siteKey.getName());
            page.setTitle(nodeLabel);
            page.setName(uniqueNodeName + page.hashCode());
            this.dataService.create(page);
            if (parentNode.getChild(uniqueNodeName) != null) {
                uniqueNodeName = uniqueNodeName + "_" + System.currentTimeMillis();
            }
            UserNode tabNode = parentNode.addChild(uniqueNodeName);
            tabNode.setLabel(nodeLabel);
            tabNode.setPageRef(page.getPageId());
            this.getUserPortal().saveNode(parentNode, null);
            return tabNode.getURI();
        }
        catch (Exception ex) {
            logger.info((Object)"Could not create page template", (Throwable)ex);
            return null;
        }
    }

    private boolean validateName(String label) {
        if (label == null || label.length() < 1) {
            return false;
        }
        if ((label = label.trim()).length() < 1 || Character.isDigit(label.charAt(0)) || label.charAt(0) == '-') {
            return false;
        }
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    private String renamePageNode(String nodeName, String newNodeLabel) {
        try {
            UserNode parentNode = this.getParentTab();
            if (parentNode == null || parentNode.getChild(nodeName) == null) {
                return null;
            }
            UserNode renamedNode = parentNode.getChild(nodeName);
            renamedNode.setLabel(newNodeLabel);
            String newNodeName = newNodeLabel.toLowerCase().replace(' ', '_');
            if (parentNode.getChild(newNodeName) != null) {
                newNodeName = newNodeName + "_" + System.currentTimeMillis();
            }
            renamedNode.setName(newNodeName);
            Page page = this.configService.getPage(renamedNode.getPageRef());
            if (page != null) {
                page.setTitle(newNodeLabel);
                this.dataService.save(page);
            }
            this.getUserPortal().saveNode(parentNode, null);
            return renamedNode.getURI();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String encodeURI(String uri) throws UnsupportedEncodingException {
        if (uri == null || uri.isEmpty()) {
            return "";
        }
        String[] path = uri.split("/");
        StringBuilder uriBuilder = new StringBuilder();
        for (String name : path) {
            uriBuilder.append("/").append(URLEncoder.encode(name, "UTF-8"));
        }
        if (uriBuilder.indexOf("/") == 0) {
            uriBuilder.deleteCharAt(0);
        }
        return uriBuilder.toString();
    }

    static /* synthetic */ UserNode access$000(UIWebOSTabPaneDashboard x0, String x1) {
        return x0.removePageNode(x1);
    }

    static /* synthetic */ String access$100(UIWebOSTabPaneDashboard x0, String x1) throws UnsupportedEncodingException {
        return x0.encodeURI(x1);
    }

    static /* synthetic */ boolean access$200(UIWebOSTabPaneDashboard x0, String x1) {
        return x0.validateName(x1);
    }

    static /* synthetic */ String access$300(UIWebOSTabPaneDashboard x0, String x1) {
        return x0.createNewPageNode(x1);
    }

    static /* synthetic */ String access$400(UIWebOSTabPaneDashboard x0, String x1, String x2) {
        return x0.renamePageNode(x1, x2);
    }
}

