/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webos.webui.page;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webos.services.desktop.DesktopBackground;
import org.exoplatform.webos.services.desktop.DesktopBackgroundService;
import org.exoplatform.webos.webui.page.UIBackgroundUploadForm;
import org.exoplatform.webos.webui.page.UIDesktopPage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIRepeater;
import org.exoplatform.webui.core.UIVirtualList;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(id="backgroundSelector", template="system:/groovy/portal/webui/page/UIBackgroundSelector.gtmpl", events={@EventConfig(listeners={UploadActionListener.class}), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIBackgroundSelector.confirm.deleteImage"), @EventConfig(listeners={PreviewActionListener.class}), @EventConfig(name="Choose", listeners={SelectItemActionListener.class})})
public class UIBackgroundSelector
extends UIContainer {
    public static final String IMAGE_LABEL = "imageLabel";
    public static final String[] BACKGROUND_BEAN_FIELD = new String[]{"imageLabel"};
    public static final String[] ACTIONS = new String[]{"Choose", "Preview", "Delete"};
    public static final int PAGE_SIZE = 5;
    private UIBackgroundUploadForm uploadForm;
    private UIVirtualList imageList;
    private String previewImage;
    private static Log log = ExoLogger.getLogger((String)"portal:UIBackgroundSelector");

    public UIBackgroundSelector() throws Exception {
        UIRepeater uiRepeater = (UIRepeater)this.createUIComponent(UIRepeater.class, null, null);
        uiRepeater.configure(IMAGE_LABEL, BACKGROUND_BEAN_FIELD, ACTIONS);
        this.imageList = (UIVirtualList)this.addChild(UIVirtualList.class, null, "UIBackgroundImageList");
        this.imageList.setPageSize(5);
        this.imageList.setUIComponent((UIComponent)uiRepeater);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIDesktopPage uiDesktopPage = (UIDesktopPage)Util.getUIPortalApplication().findFirstComponentOfType(UIDesktopPage.class);
        if (uiDesktopPage == null) {
            UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)this.getAncestorOfType(UIMaskWorkspace.class);
            maskWorkspace.createEvent("Close", Event.Phase.DECODE, context).broadcast();
            PortalRequestContext prcontext = Util.getPortalRequestContext();
            prcontext.sendRedirect(prcontext.getRequestURI());
            return;
        }
        ListAccessImpl imgAccess = new ListAccessImpl(DesktopBackground.class, this.getDesktopBackgrounds(context));
        this.imageList.dataBind((PageList)new LazyPageList((ListAccess)imgAccess, 5));
        DesktopBackgroundService service = (DesktopBackgroundService)this.getApplicationComponent(DesktopBackgroundService.class);
        UIPortal uiPortal = Util.getUIPortal();
        DesktopBackground previewBackground = service.getDesktopBackground(new PortalKey(uiPortal.getSiteType().getName(), uiPortal.getSiteKey().getName()), this.getPreviewImage());
        if (previewBackground == null) {
            this.setPreviewImage(null);
            previewBackground = service.getCurrentDesktopBackground(uiDesktopPage.getPageId());
        }
        this.refreshDesktopBackground(previewBackground, false);
        super.processRender(context);
    }

    public UIBackgroundUploadForm getUploadForm() {
        return this.uploadForm;
    }

    public void setUploadForm(UIBackgroundUploadForm uploadForm) {
        uploadForm.setReferrer((UIComponent)this);
        this.uploadForm = uploadForm;
    }

    public void setPreviewImage(String previewImage) {
        this.previewImage = previewImage;
    }

    public String getPreviewImage() {
        return this.previewImage;
    }

    private void refreshDesktopBackground(DesktopBackground desktopBackground, boolean save) {
        UIDesktopPage uiDesktopPage = (UIDesktopPage)Util.getUIPortalApplication().findFirstComponentOfType(UIDesktopPage.class);
        if (uiDesktopPage != null) {
            if (save) {
                uiDesktopPage.setDesktopBackground(desktopBackground);
            } else {
                uiDesktopPage.showDesktopBackground(desktopBackground);
            }
        }
    }

    private List<DesktopBackground> getDesktopBackgrounds(WebuiRequestContext context) throws Exception {
        DesktopBackgroundService backgroundService = (DesktopBackgroundService)this.getApplicationComponent(DesktopBackgroundService.class);
        UIPortal uiPortal = Util.getUIPortal();
        List backgrounds = backgroundService.findDesktopBackgrounds(new PortalKey(uiPortal.getSiteType().getName(), uiPortal.getSiteKey().getName()));
        Collections.sort(backgrounds, new Comparator<DesktopBackground>(){

            @Override
            public int compare(DesktopBackground o1, DesktopBackground o2) {
                if (o1.getImageLabel() == null) {
                    return 1;
                }
                if (o2.getImageLabel() == null) {
                    return -1;
                }
                return o1.getImageLabel().compareTo(o2.getImageLabel());
            }
        });
        return backgrounds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIBackgroundSelector> {
        public void execute(Event<UIBackgroundSelector> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIBackgroundSelector selector = (UIBackgroundSelector)((Object)event.getSource());
            String selectedItem = context.getRequestParameter("objectId");
            DesktopBackgroundService backgroundService = (DesktopBackgroundService)selector.getApplicationComponent(DesktopBackgroundService.class);
            UIPortal uiPortal = Util.getUIPortal();
            try {
                backgroundService.removeBackgroundImage(new PortalKey(uiPortal.getSiteType().getName(), uiPortal.getSiteKey().getName()), selectedItem);
            }
            catch (IllegalStateException e) {
                log.warn((Object)e.getMessage());
            }
            UIDesktopPage uiDesktopPage = (UIDesktopPage)Util.getUIPortalApplication().findFirstComponentOfType(UIDesktopPage.class);
            if (selectedItem != null && selectedItem.equals(uiDesktopPage.getCurrBackgroundLabel())) {
                backgroundService.setSelectedBackgroundImage(uiDesktopPage.getPageId(), null);
                uiDesktopPage.setDesktopBackground(null);
            }
            context.addUIComponentToUpdateByAjax((UIComponent)selector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviewActionListener
    extends EventListener<UIBackgroundSelector> {
        public void execute(Event<UIBackgroundSelector> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIBackgroundSelector selector = (UIBackgroundSelector)((Object)event.getSource());
            selector.setPreviewImage(context.getRequestParameter("objectId"));
            DesktopBackgroundService backgroundService = (DesktopBackgroundService)selector.getApplicationComponent(DesktopBackgroundService.class);
            UIPortal uiPortal = Util.getUIPortal();
            DesktopBackground previewBackground = backgroundService.getDesktopBackground(new PortalKey(uiPortal.getSiteType().getName(), uiPortal.getSiteKey().getName()), selector.getPreviewImage());
            if (previewBackground == null) {
                log.warn((Object)("Can't found image :" + selector.getPreviewImage()));
                Util.getUIPortalApplication().addMessage(new ApplicationMessage("UIBackgroundSelector.msg.notExists.image", null, 1));
                selector.setPreviewImage(null);
                context.addUIComponentToUpdateByAjax((UIComponent)selector);
                return;
            }
            selector.refreshDesktopBackground(previewBackground, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectItemActionListener
    extends EventListener<UIBackgroundSelector> {
        public void execute(Event<UIBackgroundSelector> event) throws Exception {
            UIDesktopPage uiDesktopPage;
            WebuiRequestContext context = event.getRequestContext();
            UIBackgroundSelector selector = (UIBackgroundSelector)((Object)event.getSource());
            selector.setPreviewImage(null);
            String selectedItem = context.getRequestParameter("objectId");
            DesktopBackgroundService backgroundService = (DesktopBackgroundService)selector.getApplicationComponent(DesktopBackgroundService.class);
            try {
                uiDesktopPage = (UIDesktopPage)Util.getUIPortalApplication().findFirstComponentOfType(UIDesktopPage.class);
                backgroundService.setSelectedBackgroundImage(uiDesktopPage.getPageId(), selectedItem);
                if (selectedItem != null) {
                    UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)selector.getAncestorOfType(UIMaskWorkspace.class);
                    maskWorkspace.createEvent("Close", Event.Phase.DECODE, context).broadcast();
                }
            }
            catch (IllegalStateException e) {
                log.warn((Object)e.getMessage());
                Util.getUIPortalApplication().addMessage(new ApplicationMessage("UIBackgroundSelector.msg.notExists.image", null, 1));
                context.addUIComponentToUpdateByAjax((UIComponent)selector);
            }
            uiDesktopPage = (UIDesktopPage)Util.getUIPortalApplication().findFirstComponentOfType(UIDesktopPage.class);
            selector.refreshDesktopBackground(backgroundService.getCurrentDesktopBackground(uiDesktopPage.getPageId()), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIBackgroundSelector> {
        public void execute(Event<UIBackgroundSelector> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIBackgroundSelector selector = (UIBackgroundSelector)((Object)event.getSource());
            selector.setPreviewImage(null);
            UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)selector.getAncestorOfType(UIMaskWorkspace.class);
            maskWorkspace.createEvent("Close", Event.Phase.DECODE, context).broadcast();
            DesktopBackgroundService backgroundService = (DesktopBackgroundService)selector.getApplicationComponent(DesktopBackgroundService.class);
            UIDesktopPage uiDesktopPage = (UIDesktopPage)Util.getUIPortalApplication().findFirstComponentOfType(UIDesktopPage.class);
            selector.refreshDesktopBackground(backgroundService.getCurrentDesktopBackground(uiDesktopPage.getPageId()), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UploadActionListener
    extends EventListener<UIBackgroundSelector> {
        public void execute(Event<UIBackgroundSelector> event) throws Exception {
            UIBackgroundSelector selector = (UIBackgroundSelector)((Object)event.getSource());
            UIBackgroundUploadForm uploadForm = (UIBackgroundUploadForm)selector.createUIComponent(UIBackgroundUploadForm.class, null, null);
            selector.setUploadForm(uploadForm);
            UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)selector.getAncestorOfType(UIMaskWorkspace.class);
            maskWorkspace.setUIComponent((UIComponent)selector.getUploadForm());
            Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)maskWorkspace);
        }
    }
}

