/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.cluster.StartableClusterAware;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.JPADataStorage;
import org.exoplatform.wiki.jpa.migration.MigrationService$AjcClosure1;
import org.exoplatform.wiki.jpa.migration.WikiMigrationContext;
import org.exoplatform.wiki.jpa.migration.WikiMigrationSettingService;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.mow.api.Template;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.impl.JCRDataStorage;
import org.jgroups.util.DefaultThreadFactory;

public class MigrationService
implements StartableClusterAware {
    private static final Log LOG;
    private JCRDataStorage jcrDataStorage;
    private JPADataStorage jpaDataStorage;
    private OrganizationService organizationService;
    private MOWService mowService;
    private IndexingService indexingService;
    private ExecutorService executorService;
    private WikiMigrationSettingService settingService;
    private Set<String> wikiErrorsList = new HashSet<String>();
    private Set<String> pageErrorsList = new HashSet<String>();
    private final CountDownLatch latch;
    private ExoContainer currentContainer;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public MigrationService(JCRDataStorage jcrDataStorage, JPADataStorage jpaDataStorage, OrganizationService organizationService, MOWService mowService, IndexingService indexingService, WikiMigrationSettingService wikiMigrationSettingService) {
        this.jcrDataStorage = jcrDataStorage;
        this.jpaDataStorage = jpaDataStorage;
        this.organizationService = organizationService;
        this.mowService = mowService;
        this.indexingService = indexingService;
        this.settingService = wikiMigrationSettingService;
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("WIKI-MIGRATION-RDBMS", false, false));
        this.latch = new CountDownLatch(1);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.hasDataToMigrate()) {
            LOG.info((Object)"No Wiki data to migrate from JCR to RDBMS");
            return;
        }
        this.currentContainer = ExoContainerContext.getCurrentContainer();
        try {
            RequestLifeCycle.begin((ExoContainer)this.currentContainer);
            Identity userIdentity = new Identity(IdentityConstants.SYSTEM);
            ConversationState.setCurrent((ConversationState)new ConversationState(userIdentity));
            this.settingService.initMigrationSetting();
            if (WikiMigrationContext.isMigrationDone() && !this.settingService.isForceRunMigration() && !this.settingService.isForceJCRDeletion()) {
                LOG.warn((Object)("Still Wiki data in JCR due to error during migration. To finish properly the migration you can:\n 1. Delete JCR data definitively: Set exo.wiki.migration.forceJCRDeletion to true\n 2. Rerun the migration: Set exo.wiki.migration.forceRunMigration to true\n\n" + this.getErrorReport()));
            } else {
                LOG.info((Object)"=== Start Wiki data migration from JCR to RDBMS");
                long startTime = System.currentTimeMillis();
                if (this.settingService.isForceRunMigration()) {
                    this.settingService.removeSettingValue("WIKI_RDBMS_MIGRATION_ERROR_WIKI_LIST");
                    this.settingService.removeSettingValue("WIKI_RDBMS_MIGRATION_ERROR_PAGE_LIST");
                }
                if (!WikiMigrationContext.isPortalWikiMigrationDone()) {
                    this.migrateWikisOfType(PortalConfig.PORTAL_TYPE);
                }
                if (!WikiMigrationContext.isSpaceWikiMigrationDone()) {
                    this.migrateWikisOfType(PortalConfig.GROUP_TYPE);
                }
                if (!WikiMigrationContext.isUserWikiMigrationDone()) {
                    this.migrateUsersWikis();
                }
                if (!WikiMigrationContext.isDraftPageMigrationDone()) {
                    this.migrateDraftPages();
                }
                if (!WikiMigrationContext.isRelatedPageMigrationDone()) {
                    this.migrateRelatedPages();
                }
                long endTime = System.currentTimeMillis();
                this.settingService.updateOperationStatus("WIKI_RDBMS_MIGRATION_DONE", true);
                LOG.info((Object)("=== Wiki data migration from JCR to RDBMS done in " + (endTime - startTime) + " ms"));
                Integer wikiErrorNumber = this.settingService.getWikiMigrationErrorsNumber() + this.settingService.getWikiDeletionErrorsNumber();
                if (wikiErrorNumber == 0) {
                    LOG.info((Object)"No error during migration");
                } else {
                    LOG.info((Object)("Numbers of wiki in error during migration = " + wikiErrorNumber));
                }
            }
            if (WikiMigrationContext.isDeletionDone() && !this.settingService.isForceJCRDeletion()) {
                LOG.info((Object)"No Wiki data to delete from JCR");
            } else {
                LOG.info((Object)"=== Start Wiki JCR data cleaning due to RDBMS migration");
                if (!this.settingService.isForceJCRDeletion()) {
                    LOG.info((Object)"For information, Wiki(s) with errors during migration will not be deleted from JCR");
                } else {
                    LOG.info((Object)"For information, all wiki(s) will be deleted from JCR (even Wiki(s) with errors during migration)");
                }
                this.getExecutorService().submit(new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        try {
                            long startTime = System.currentTimeMillis();
                            ExoContainerContext.setCurrentContainer((ExoContainer)MigrationService.this.currentContainer);
                            RequestLifeCycle.begin((ExoContainer)MigrationService.this.currentContainer);
                            Identity userIdentity = new Identity(IdentityConstants.SYSTEM);
                            ConversationState.setCurrent((ConversationState)new ConversationState(userIdentity));
                            if (!WikiMigrationContext.isReindexDone()) {
                                LOG.info((Object)"Start reindexation of all wiki pages");
                                MigrationService.this.indexingService.reindexAll("wiki-page");
                                LOG.info((Object)"Start reindexation of all wiki pages attachments");
                                MigrationService.this.indexingService.reindexAll("wiki-attachment");
                                MigrationService.this.settingService.updateOperationStatus("WIKI_RDBMS_MIGRATION_REINDEX_DONE", true);
                            }
                            MigrationService.this.initWikiErrorsList();
                            if (MigrationService.this.settingService.isForceJCRDeletion()) {
                                MigrationService.this.settingService.removeSettingValue("WIKI_RDBMS_DELETION_ERROR_WIKI_LIST");
                            }
                            if (!WikiMigrationContext.isPortalWikiCleanupDone() || MigrationService.this.settingService.isForceJCRDeletion()) {
                                MigrationService.this.deleteWikiNodesOfType(PortalConfig.PORTAL_TYPE);
                            }
                            if (!WikiMigrationContext.isSpaceWikiCleanupDone() || MigrationService.this.settingService.isForceJCRDeletion()) {
                                MigrationService.this.deleteWikiNodesOfType(PortalConfig.GROUP_TYPE);
                            }
                            if (!WikiMigrationContext.isUserWikiCleanupDone() || MigrationService.this.settingService.isForceJCRDeletion()) {
                                MigrationService.this.deleteWikiNodesOfType(PortalConfig.USER_TYPE);
                            }
                            if (!WikiMigrationContext.isEmoticonCleanupDone() || MigrationService.this.settingService.isForceJCRDeletion()) {
                                MigrationService.this.deleteEmotionIcons();
                            }
                            Integer migrationErrorsNumber = MigrationService.this.settingService.getWikiMigrationErrorsNumber();
                            Integer deletionErrorsNumber = MigrationService.this.settingService.getWikiDeletionErrorsNumber();
                            if (deletionErrorsNumber > 0 || migrationErrorsNumber > 0 && !MigrationService.this.settingService.isForceJCRDeletion()) {
                                LOG.warn((Object)MigrationService.this.getErrorReport());
                            } else {
                                try {
                                    MigrationService.this.deleteWikiRootNode();
                                    MigrationService.this.settingService.removeAllSettingValues();
                                }
                                catch (Exception e) {
                                    LOG.error((Object)("Cannot delete root wiki data node - Cause : " + e.getMessage()), (Throwable)e);
                                }
                            }
                            long endTime = System.currentTimeMillis();
                            MigrationService.this.settingService.updateOperationStatus("WIKI_RDBMS_DELETION_DONE", true);
                            LOG.info((Object)("=== Wiki JCR data cleaning due to RDBMS migration done in " + (endTime - startTime) + " ms"));
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error while cleaning Wiki JCR data to RDBMS - Cause : " + e.getMessage()), (Throwable)e);
                        }
                        finally {
                            ConversationState.setCurrent(null);
                            RequestLifeCycle.end();
                        }
                        MigrationService.this.latch.countDown();
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while migrating Wiki JCR data to RDBMS - Cause : " + e.getMessage()), (Throwable)e);
        }
        finally {
            ConversationState.setCurrent(null);
            RequestLifeCycle.end();
        }
    }

    public boolean isDone() {
        this.settingService.initMigrationSetting();
        return !this.hasDataToMigrate() && WikiMigrationContext.isMigrationDone() && WikiMigrationContext.isDeletionDone();
    }

    public void stop() {
        this.executorService.shutdown();
    }

    private String getErrorReport() {
        String[] wikiAttribute;
        Set<String> wikiErrors = this.getWikiErrorsSet();
        Set<String> pageErrors = this.getPageErrorsSet();
        Set<String> wikiDeletionErrors = this.getWikiDeletionErrorsSet();
        StringBuilder errorReport = new StringBuilder();
        errorReport.append("\n ============== Wiki Migration Error report ==============\n");
        errorReport.append("\n ### Summary \n");
        errorReport.append("\n Number of migration wiki error: " + wikiErrors.size());
        errorReport.append("\n Number of migration page error: " + pageErrors.size());
        errorReport.append("\n Number of deletion wiki error: " + wikiDeletionErrors.size());
        errorReport.append("\n\n ### Wiki migration errors list:\n");
        for (String wikiError : wikiErrors) {
            wikiAttribute = wikiError.split(":", 2);
            errorReport.append("\n Wiki Type  : " + wikiAttribute[0]);
            errorReport.append("\n Wiki Owner : " + wikiAttribute[1]);
            errorReport.append("\n ---------------------------------------------------------");
        }
        errorReport.append("\n\n ### Page migration errors list:\n");
        for (String pageError : pageErrors) {
            Page page = this.settingService.stringToPage(pageError);
            errorReport.append("\n Wiki Type  : " + page.getWikiType());
            errorReport.append("\n Wiki Owner  : " + page.getWikiOwner());
            errorReport.append("\n Page Id  : " + page.getId());
            errorReport.append("\n Page Name  : " + page.getName());
            errorReport.append("\n ---------------------------------------------------------");
        }
        errorReport.append("\n\n ### Wiki deletion errors list:\n");
        for (String wikiDeletionError : wikiDeletionErrors) {
            wikiAttribute = wikiDeletionError.split(":", 2);
            errorReport.append("\n Wiki Type  : " + wikiAttribute[0]);
            errorReport.append("\n Wiki Owner : " + wikiAttribute[1]);
            errorReport.append("\n ---------------------------------------------------------");
        }
        errorReport.append("\n\n =======================================================\n");
        return errorReport.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDataToMigrate() {
        boolean hasDataToMigrate = true;
        boolean created = this.mowService.startSynchronization();
        try {
            Session session = this.mowService.getSession().getJCRSession();
            hasDataToMigrate = session.getRootNode().hasNode("exo:applications/eXoWiki");
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Cannot get root wiki data node - Cause : " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
        return hasDataToMigrate;
    }

    private void migrateWikisOfType(String wikiType) {
        try {
            LOG.info((Object)("  Start migration of " + wikiType + " wikis"));
            List wikis = this.jcrDataStorage.getWikisByType(wikiType);
            if (wikis != null && !wikis.isEmpty()) {
                LOG.info((Object)("  Number of " + wikiType + " wikis to migrate = " + wikis.size()));
                for (Wiki jcrWiki : wikis) {
                    this.migrateWiki(jcrWiki);
                }
            } else {
                LOG.info((Object)("  No " + wikiType + " wikis to migrate"));
            }
            this.settingService.setWikiMigrationOfTypeDone(wikiType);
            LOG.info((Object)("    Migration of " + wikiType + " wikis done"));
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot finish the migration of " + wikiType + " wikis - Cause " + e.getMessage()), (Throwable)e);
        }
    }

    private void migrateUsersWikis() {
        int pageSize = 20;
        int current = 0;
        try {
            User[] users;
            LOG.info((Object)"  Start migration of user wikis");
            ListAccess allUsersListAccess = this.organizationService.getUserHandler().findAllUsers();
            int totalUsers = allUsersListAccess.getSize();
            LOG.info((Object)("    Number of users = " + totalUsers));
            do {
                LOG.info((Object)("    Progression of users wikis migration : " + current + "/" + totalUsers));
                if (current + pageSize > totalUsers) {
                    pageSize = totalUsers - current;
                }
                for (User user : users = (User[])allUsersListAccess.load(current, pageSize)) {
                    try {
                        RequestLifeCycle.end();
                        RequestLifeCycle.begin((ExoContainer)this.currentContainer);
                        Wiki jcrWiki = this.jcrDataStorage.getWikiByTypeAndOwner(PortalConfig.USER_TYPE, user.getUserName());
                        if (jcrWiki != null) {
                            Page jcrWikiHome;
                            List jcrWikiHomeVersions;
                            boolean wikiUpdated;
                            LOG.info((Object)("    Migration of the wiki of the user " + user.getUserName()));
                            if (jcrWiki.getOwner() == null) {
                                jcrWiki.setOwner(user.getUserName());
                            }
                            boolean bl = wikiUpdated = (jcrWikiHomeVersions = this.jcrDataStorage.getVersionsOfPage(jcrWikiHome = jcrWiki.getWikiHome())) != null && jcrWikiHomeVersions.size() > 1;
                            if (!wikiUpdated) {
                                List jcrWikiHomeChildren = this.jcrDataStorage.getChildrenPageOf(jcrWikiHome);
                                boolean bl2 = wikiUpdated = jcrWikiHomeChildren != null && jcrWikiHomeChildren.size() > 0;
                            }
                            if (wikiUpdated) {
                                LOG.info((Object)("    Migration of the wiki of the user " + user.getUserName()));
                                this.migrateWiki(jcrWiki);
                                continue;
                            }
                            LOG.info((Object)("    No need to migrate wiki of the user " + user.getUserName() + " since it has not been modified"));
                            continue;
                        }
                        LOG.info((Object)("    No wiki for user " + user.getUserName()));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Cannot migrate wiki of user " + user.getUserName() + " - Cause " + e.getMessage()), (Throwable)e);
                        this.settingService.addWikiErrorToSetting(new Wiki(PortalConfig.USER_TYPE, user.getUserName()));
                    }
                }
                current += users.length;
            } while (users != null && users.length > 0);
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)this.currentContainer);
            this.settingService.updateOperationStatus("WIKI_RDBMS_MIGRATION_USER_WIKI_DONE", true);
            LOG.info((Object)"    Migration of users wikis done");
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot migrate users wikis - Cause : " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateWiki(Wiki jcrWiki) {
        Boolean isWikiMigrationSuccess = false;
        Boolean isWikiMigrationStarted = false;
        try {
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)this.currentContainer);
            LOG.info((Object)("  Start migration of wiki " + jcrWiki.getType() + ":" + jcrWiki.getOwner()));
            Page jcrWikiHome = jcrWiki.getWikiHome();
            Wiki jpaWiki = this.jpaDataStorage.getWikiByTypeAndOwner(jcrWiki.getType(), jcrWiki.getOwner());
            if (jpaWiki != null) {
                isWikiMigrationStarted = true;
                LOG.info((Object)("  Wiki " + jcrWiki.getType() + ":" + jcrWiki.getOwner() + " has already been migrated."));
            } else {
                jcrWiki.setWikiHome(null);
                jpaWiki = this.jpaDataStorage.createWiki(jcrWiki);
            }
            LOG.info((Object)"    Start migration of wiki pages ...");
            jcrWiki.setWikiHome(jcrWikiHome);
            isWikiMigrationSuccess = this.createChildrenPagesOf(jpaWiki, jcrWiki, null, 1, isWikiMigrationStarted);
            LOG.info((Object)"    Pages migrated");
            LOG.info((Object)"    Start migration of templates ...");
            this.createTemplates(jcrWiki, isWikiMigrationStarted);
            LOG.info((Object)"    Templates migrated");
            LOG.info((Object)("  Wiki " + jcrWiki.getType() + ":" + jcrWiki.getOwner() + " migrated successfully"));
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot migrate wiki " + jcrWiki.getType() + ":" + jcrWiki.getOwner() + " - Cause : " + e.getMessage()), (Throwable)e);
            this.settingService.addWikiErrorToSetting(jcrWiki);
        }
        finally {
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)this.currentContainer);
        }
        if (!isWikiMigrationSuccess.booleanValue()) {
            this.settingService.addWikiErrorToSetting(jcrWiki);
        }
    }

    private void migrateDraftPages() {
        int pageSize = 20;
        int current = 0;
        try {
            User[] users;
            LOG.info((Object)"  Start migration of draft pages");
            ListAccess allUsersListAccess = this.organizationService.getUserHandler().findAllUsers();
            int totalUsers = allUsersListAccess.getSize();
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)this.currentContainer);
            do {
                if (current + pageSize > totalUsers) {
                    pageSize = totalUsers - current;
                }
                for (User user : users = (User[])allUsersListAccess.load(current, pageSize)) {
                    try {
                        List draftPages = this.jcrDataStorage.getDraftPagesOfUser(user.getUserName());
                        LOG.info((Object)("    Migration of draft pages of user " + user.getUserName()));
                        if (draftPages != null && draftPages.size() > 0) {
                            for (DraftPage jcrDraftPage : draftPages) {
                                if (this.jpaDataStorage.getDraft(jcrDraftPage.getName(), user.getUserName()) == null) {
                                    LOG.info((Object)("      Migration of draft page " + jcrDraftPage.getName() + " of user " + user.getUserName()));
                                    String targetPageId = jcrDraftPage.getTargetPageId();
                                    if (targetPageId != null) {
                                        try {
                                            Page jcrPageOfDraft = this.jcrDataStorage.getPageById(jcrDraftPage.getTargetPageId());
                                            if (jcrPageOfDraft != null) {
                                                Page jpaPageOfDraft = this.jpaDataStorage.getPageOfWikiByName(jcrPageOfDraft.getWikiType(), jcrPageOfDraft.getWikiOwner(), jcrPageOfDraft.getName());
                                                if (jpaPageOfDraft != null) {
                                                    jcrDraftPage.setTargetPageId(jpaPageOfDraft.getId());
                                                    this.jpaDataStorage.createDraftPageForUser(jcrDraftPage, user.getUserName());
                                                    continue;
                                                }
                                                LOG.warn((Object)("Target page " + jcrPageOfDraft.getName() + " of draft page " + jcrDraftPage.getName() + " does not exist in JPA database. Consequently the draft page is not migrated."));
                                                continue;
                                            }
                                            LOG.error((Object)("Cannot migrate draft page " + jcrDraftPage.getName() + " of user " + user.getUserName() + " - Cause : target page " + jcrDraftPage.getTargetPageId() + " does not exist"));
                                        }
                                        catch (Exception e) {
                                            LOG.error((Object)("Cannot migrate draft page " + jcrDraftPage.getName() + " of user " + user.getUserName() + " - Cause : " + e.getMessage()), (Throwable)e);
                                        }
                                        continue;
                                    }
                                    LOG.error((Object)("Cannot migrate draft page " + jcrDraftPage.getName() + " of user " + user.getUserName() + " - Cause : target page id is null"));
                                    continue;
                                }
                                LOG.info((Object)("      Draft page " + jcrDraftPage.getName() + " of user " + user.getUserName() + " already migrated"));
                            }
                            continue;
                        }
                        LOG.info((Object)("      No draft pages for user " + user.getUserName()));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Cannot migrate draft pages of user " + user.getUserName() + " - Cause : " + e.getMessage()), (Throwable)e);
                    }
                }
                current += users.length;
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)this.currentContainer);
            } while (users != null && users.length > 0);
            this.settingService.updateOperationStatus("WIKI_RDBMS_MIGRATION_DRAFT_PAGE_DONE", true);
            LOG.info((Object)"  Migration of draft pages done");
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot migrate draft pages - Cause : " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateRelatedPages() {
        try {
            this.initPageErrorsList();
            LOG.info((Object)"  Start migration of related pages ...");
            Set<String> pagesWithRelatedPagesSet = this.getPageWithRelatedPageSet();
            Iterator<String> itPagesWithRelatedPagesSet = pagesWithRelatedPagesSet.iterator();
            while (itPagesWithRelatedPagesSet.hasNext()) {
                String pageWithRelatedPagesString = itPagesWithRelatedPagesSet.next();
                Page pageWithRelatedPages = this.settingService.stringToPage(pageWithRelatedPagesString);
                if ((pageWithRelatedPages = this.jcrDataStorage.getPageOfWikiByName(pageWithRelatedPages.getWikiType(), pageWithRelatedPages.getWikiOwner(), pageWithRelatedPages.getName())) != null) {
                    try {
                        RequestLifeCycle.end();
                        RequestLifeCycle.begin((ExoContainer)this.currentContainer);
                        LOG.info((Object)("    Related pages of page " + pageWithRelatedPages.getName()));
                        List relatedPages = this.jcrDataStorage.getRelatedPagesOfPage(pageWithRelatedPages);
                        for (Page relatedPage : relatedPages) {
                            try {
                                if (this.pageErrorsList.contains(relatedPage.getId())) {
                                    LOG.info((Object)("      Cannot link related page " + relatedPage.getName() + " to " + pageWithRelatedPages.getName() + " - Cause: " + relatedPage.getName() + " encounter issues during migration and has not been migrated"));
                                    continue;
                                }
                                LOG.info((Object)("      Add related page. Name|id|wikiType|wikiOwner: " + relatedPage.getName() + "|" + relatedPage.getId() + "|" + relatedPage.getWikiType() + "|" + relatedPage.getWikiOwner()));
                                this.jpaDataStorage.addRelatedPage(pageWithRelatedPages, relatedPage);
                                this.jcrDataStorage.removeRelatedPage(pageWithRelatedPages, relatedPage);
                                itPagesWithRelatedPagesSet.remove();
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Cannot migrate related page " + relatedPage.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Cannot migrate related pages of page " + pageWithRelatedPages.getWikiType() + ":" + pageWithRelatedPages.getWikiOwner() + ":" + pageWithRelatedPages.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
                    }
                    finally {
                        RequestLifeCycle.end();
                        RequestLifeCycle.begin((ExoContainer)this.currentContainer);
                    }
                } else {
                    LOG.error((Object)("Cannot migrate related pages of page  " + pageWithRelatedPages.getWikiType() + ":" + pageWithRelatedPages.getWikiOwner() + ":" + pageWithRelatedPages.getName() + " because the page does not exist"));
                    itPagesWithRelatedPagesSet.remove();
                }
                if (pagesWithRelatedPagesSet != null && pagesWithRelatedPagesSet.size() > 0) {
                    String pagesWithRelatedPagesString = "";
                    for (String pagesNotMigrated : pagesWithRelatedPagesSet) {
                        pagesWithRelatedPagesString = pagesWithRelatedPagesString + pagesNotMigrated + ";";
                    }
                    this.settingService.setRelatedPagesToSetting(pagesWithRelatedPagesString.substring(0, pagesWithRelatedPagesString.length() - 1));
                    continue;
                }
                this.settingService.setRelatedPagesToSetting(null);
            }
            this.settingService.updateOperationStatus("WIKI_RDBMS_MIGRATION_RELATED_PAGE_DONE", true);
            LOG.info((Object)"  Related pages migrated");
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot migrate related pages - Cause : " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEmotionIcons() {
        LOG.info((Object)"  Start deletion of emotion icons ...");
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)this.currentContainer);
        try {
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            wStore.setMOWService(this.mowService);
            PageImpl emotionIconsPage = wStore.getEmotionIconsContainer();
            if (emotionIconsPage != null) {
                Node emotionIconJcrPageNode = emotionIconsPage.getJCRPageNode();
                if (!emotionIconJcrPageNode.isCheckedOut()) {
                    emotionIconsPage.checkout();
                }
                emotionIconJcrPageNode.remove();
            }
            this.settingService.updateOperationStatus("WIKI_RDBMS_CLEANUP_DRAFT_PAGE_DONE", true);
            LOG.info((Object)"  Deletion of emotion icons done");
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot delete emotion icons - Cause : " + e.getMessage()), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)this.currentContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteWikiNodesOfType(String wikiType) throws RepositoryException {
        block19: {
            LOG.info((Object)("  Start deletion of " + wikiType + " wikis"));
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)this.currentContainer);
            try {
                String referencedNodePath = "exo:applications/eXoWiki/wikimetadata/";
                referencedNodePath = PortalConfig.USER_TYPE.equals(wikiType) ? referencedNodePath + "userwikis" : (PortalConfig.GROUP_TYPE.equals(wikiType) ? referencedNodePath + "groupwikis" : referencedNodePath + "portalwikis");
                Session session = this.mowService.getSession().getJCRSession();
                Node wikiRootNode = session.getRootNode().getNode(referencedNodePath);
                if (wikiRootNode != null) {
                    PropertyIterator wikiRootNodeReferences = wikiRootNode.getReferences();
                    while (wikiRootNodeReferences.hasNext()) {
                        Node wikiNode = null;
                        Wiki wiki = null;
                        try {
                            Property property = wikiRootNodeReferences.nextProperty();
                            LOG.info((Object)("    Referenced node found : " + property.getPath()));
                            wikiNode = property.getParent();
                            String wikiOwner = null;
                            if (wikiNode.hasProperty("owner")) {
                                wikiOwner = wikiNode.getProperty("owner").getString();
                            } else {
                                LOG.info((Object)("      Node referencing wiki root node but with no owner : " + wikiNode.getPath()));
                            }
                            wiki = new Wiki(wikiType, wikiOwner);
                            if (this.settingService.isForceJCRDeletion() || !this.wikiErrorsList.contains(this.settingService.wikiToString(wiki))) {
                                LOG.info((Object)("      Delete wiki node " + wikiNode.getPath()));
                                Node wikiNodeParent = null;
                                try {
                                    wikiNodeParent = wikiNode.getParent();
                                }
                                catch (Exception e) {
                                    LOG.info((Object)"        Node does not exist anymore");
                                    continue;
                                }
                                boolean refFound = false;
                                PropertyIterator propertyIterator = wikiNode.getProperties();
                                while (propertyIterator.hasNext()) {
                                    try {
                                        Property nodeProperty = propertyIterator.nextProperty();
                                        if (!nodeProperty.getName().equals("ref")) continue;
                                        if (refFound) {
                                            LOG.info((Object)"        Second ref found on wiki node, delete it");
                                            nodeProperty.remove();
                                            wikiNode.save();
                                            continue;
                                        }
                                        refFound = true;
                                    }
                                    catch (Exception e2) {
                                        LOG.error((Object)("Error while reading node property - Cause : " + e2.getMessage()));
                                    }
                                }
                                wikiNode.remove();
                                wikiNodeParent.save();
                                continue;
                            }
                            LOG.info((Object)("    Wiki node " + wikiNode.getPath() + " not deleted"));
                        }
                        catch (Exception e) {
                            if (wikiNode != null) {
                                LOG.error((Object)("Cannot delete referenced wiki node " + wikiNode.getPath() + " - Cause : " + e.getMessage()), (Throwable)e);
                                if (wiki == null) continue;
                                this.settingService.addWikiDeletionErrorToSetting(wiki);
                                if (session == null) continue;
                                try {
                                    session.refresh(false);
                                }
                                catch (RepositoryException re) {
                                    LOG.error((Object)("Cannot refresh JCR session - Cause : " + re.getMessage()), (Throwable)re);
                                }
                                continue;
                            }
                            LOG.error((Object)("Cannot delete referenced wiki node - Cause : " + e.getMessage()), (Throwable)e);
                        }
                    }
                    this.settingService.setWikiCleanupOfTypeDone(wikiType);
                    LOG.info((Object)("  Deletion of " + wikiType + " wikis done"));
                    break block19;
                }
                LOG.error((Object)("Cannot get referenced node for wikis of type " + wikiType + " (path : " + referencedNodePath + ")"));
            }
            finally {
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)this.currentContainer);
            }
        }
    }

    private void deleteWikiRootNode() throws RepositoryException {
        LOG.info((Object)"  Start deletion of root wiki data node ...");
        Session session = null;
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)this.currentContainer);
        try {
            session = this.mowService.getSession().getJCRSession();
            Node wikiRootNode = session.getRootNode().getNode("exo:applications/eXoWiki");
            if (wikiRootNode != null) {
                wikiRootNode.remove();
                session.save();
            }
            LOG.info((Object)"  Deletion of root wiki data node done");
        }
        finally {
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)this.currentContainer);
        }
    }

    private Boolean createChildrenPagesOf(Wiki jpaWiki, Wiki jcrWiki, Page jcrPage, int level, Boolean isParentAlreadyMigrated) throws WikiException {
        Boolean isMigrationSuccess = true;
        List<Page> childrenPages = new ArrayList();
        if (jcrPage == null) {
            Page jcrWikiHome = jcrWiki.getWikiHome();
            jcrWikiHome.setId(null);
            childrenPages.add(jcrWikiHome);
        } else {
            childrenPages = this.jcrDataStorage.getChildrenPageOf(jcrPage);
        }
        if (childrenPages != null) {
            for (Page childrenPage : childrenPages) {
                boolean pageCreated;
                boolean pageAlreadyMigrated = false;
                try {
                    LOG.info((Object)String.format("    %1$" + level * 2 + "s Page %2$s", " ", childrenPage.getName()));
                    RequestLifeCycle.end();
                    RequestLifeCycle.begin((ExoContainer)this.currentContainer);
                    childrenPage.setWikiType(jpaWiki.getType());
                    childrenPage.setWikiOwner(jpaWiki.getOwner());
                    pageAlreadyMigrated = this.createPage(jpaWiki, jcrPage, childrenPage, isParentAlreadyMigrated);
                    pageCreated = true;
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot create page " + jpaWiki.getType() + ":" + jpaWiki.getOwner() + ":" + childrenPage.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
                    pageCreated = false;
                    isMigrationSuccess = false;
                    this.settingService.addPageErrorToSetting(childrenPage);
                }
                if (!pageCreated) continue;
                try {
                    List relatedPages = this.jcrDataStorage.getRelatedPagesOfPage(childrenPage);
                    if (relatedPages != null && !relatedPages.isEmpty()) {
                        this.settingService.addRelatedPagesToSetting(childrenPage);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot get related pages of page " + jpaWiki.getType() + ":" + jpaWiki.getOwner() + ":" + childrenPage.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
                    isMigrationSuccess = false;
                    this.settingService.addPageErrorToSetting(childrenPage);
                }
                Boolean isChildrenSuccess = this.createChildrenPagesOf(jpaWiki, jcrWiki, childrenPage, level + 1, pageAlreadyMigrated);
                if (!isMigrationSuccess.booleanValue()) continue;
                isMigrationSuccess = isChildrenSuccess;
            }
        }
        return isMigrationSuccess;
    }

    @ExoTransactional
    private Boolean createPage(Wiki wiki, Page jcrParentPage, Page jcrPage, Boolean checkPageMigrated) throws WikiException {
        Wiki wiki2 = wiki;
        Page page = jcrParentPage;
        Page page2 = jcrPage;
        Boolean bl = checkPageMigrated;
        Object[] objectArray = new Object[]{wiki2, page, page2, bl};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, wiki2, page, page2, bl, joinPoint};
        return (Boolean)ExoTransactionalAspect.aspectOf().around(new MigrationService$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private void createTemplates(Wiki jcrWiki, Boolean isWikiMigrationStarted) throws WikiException {
        Map jcrWikiTemplates = this.jcrDataStorage.getTemplates(new WikiPageParams(jcrWiki.getType(), jcrWiki.getOwner(), jcrWiki.getId()));
        if (jcrWikiTemplates != null) {
            for (Template jcrTemplate : jcrWikiTemplates.values()) {
                Template jpaTemplate;
                if (isWikiMigrationStarted.booleanValue() && (jpaTemplate = this.jpaDataStorage.getTemplatePage(new WikiPageParams(jcrWiki.getType(), jcrWiki.getOwner(), null), jcrTemplate.getName())) != null) {
                    LOG.info((Object)("      Template " + jcrTemplate.getName() + " already migrated."));
                    return;
                }
                LOG.info((Object)("      Template " + jcrTemplate.getName() + " migrated."));
                this.jpaDataStorage.createTemplatePage(jcrWiki, jcrTemplate);
            }
        }
    }

    private void initWikiErrorsList() {
        this.wikiErrorsList = this.getWikiErrorsSet();
    }

    private Set<String> getWikiErrorsSet() {
        String wikiErrors = this.settingService.getWikiErrorsSetting();
        HashSet<String> wikiErrorsSet = new HashSet<String>();
        if (wikiErrors != null) {
            wikiErrorsSet = new HashSet<String>(Arrays.asList(wikiErrors.split(";")));
        }
        return wikiErrorsSet;
    }

    private Set<String> getWikiDeletionErrorsSet() {
        String wikiDeletionErrors = this.settingService.getWikiDeletionErrorsSetting();
        HashSet<String> wikiErrorsSet = new HashSet<String>();
        if (wikiDeletionErrors != null) {
            wikiErrorsSet = new HashSet<String>(Arrays.asList(wikiDeletionErrors.split(";")));
        }
        return wikiErrorsSet;
    }

    private void initPageErrorsList() {
        this.pageErrorsList = this.getPageErrorsSet();
    }

    private Set<String> getPageErrorsSet() {
        String pageErrors = this.settingService.getPageErrorsSetting();
        HashSet<String> pageErrorsSet = new HashSet<String>();
        if (pageErrors != null) {
            pageErrorsSet = new HashSet<String>(Arrays.asList(pageErrors.split(";")));
        }
        return pageErrorsSet;
    }

    private Set<String> getPageWithRelatedPageSet() {
        String pagesWithRelatedPage = this.settingService.getRelatedPagesSetting();
        HashSet<String> pagesWithRelatedPageSet = new HashSet<String>();
        if (pagesWithRelatedPage != null) {
            pagesWithRelatedPageSet = new HashSet<String>(Arrays.asList(pagesWithRelatedPage.split(";")));
        }
        return pagesWithRelatedPageSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WikiImpl fetchWikiImpl(String wikiType, String wikiOwner) throws WikiException {
        WikiImpl userWikiContainer1;
        boolean created = this.mowService.startSynchronization();
        try {
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            WikiImpl wiki = null;
            if (PortalConfig.PORTAL_TYPE.equals(wikiType)) {
                WikiContainer userWikiContainer = wStore.getWikiContainer(WikiType.PORTAL);
                wiki = userWikiContainer.getWiki(wikiOwner);
            } else if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
                WikiContainer userWikiContainer = wStore.getWikiContainer(WikiType.GROUP);
                wiki = userWikiContainer.getWiki(wikiOwner);
            } else if (PortalConfig.USER_TYPE.equals(wikiType)) {
                WikiContainer userWikiContainer = wStore.getWikiContainer(WikiType.USER);
                wiki = userWikiContainer.getWiki(wikiOwner);
            }
            userWikiContainer1 = wiki;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
        return userWikiContainer1;
    }

    static {
        MigrationService.ajc$preClinit();
        LOG = ExoLogger.getLogger(MigrationService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Boolean createPage_aroundBody0(MigrationService ajc$this, Wiki wiki, Page jcrParentPage, Page jcrPage, Boolean checkPageMigrated, JoinPoint joinPoint) {
        Page page;
        if (checkPageMigrated.booleanValue() && (page = ajc$this.jpaDataStorage.getPageOfWikiByName(jcrPage.getWikiType(), jcrPage.getOwner(), jcrPage.getName())) != null) {
            LOG.info((Object)("  Page " + jcrPage.getName() + " has already been migrated."));
            return true;
        }
        try {
            ArrayList<PageVersion> pageVersions = ajc$this.jcrDataStorage.getVersionsOfPage(jcrPage);
            if (pageVersions == null || pageVersions.isEmpty()) {
                LOG.warn((Object)("Page " + jcrPage.getName() + " is not versioned, migrating the page as the only version"));
                PageVersion pageOnlyVersion = new PageVersion();
                pageOnlyVersion.setAuthor(jcrPage.getAuthor());
                pageOnlyVersion.setContent(jcrPage.getContent());
                pageOnlyVersion.setCreatedDate(jcrPage.getCreatedDate());
                pageOnlyVersion.setUpdatedDate(jcrPage.getUpdatedDate());
                pageOnlyVersion.setComment(jcrPage.getComment());
                if (pageVersions == null) {
                    pageVersions = new ArrayList<PageVersion>();
                }
                pageVersions.add(pageOnlyVersion);
            }
            PageVersion firstVersion = (PageVersion)pageVersions.get(pageVersions.size() - 1);
            Page jpaPage = new Page();
            jpaPage.setWikiType(wiki.getType());
            jpaPage.setWikiOwner(wiki.getOwner());
            jpaPage.setName(jcrPage.getName());
            jpaPage.setTitle(jcrPage.getTitle());
            jpaPage.setAuthor(firstVersion.getAuthor());
            jpaPage.setSyntax(jcrPage.getSyntax());
            jpaPage.setContent(firstVersion.getContent());
            jpaPage.setPermissions(jcrPage.getPermissions());
            jpaPage.setCreatedDate(firstVersion.getCreatedDate());
            jpaPage.setUpdatedDate(firstVersion.getUpdatedDate());
            jpaPage.setOwner(jcrPage.getOwner());
            jpaPage.setComment(firstVersion.getComment());
            jpaPage.setMinorEdit(jcrPage.isMinorEdit());
            jpaPage.setActivityId(jcrPage.getActivityId());
            if (jcrParentPage == null) {
                String wikiHomeId = wiki.getWikiHome().getId();
                jpaPage.setId(wikiHomeId);
                ajc$this.jpaDataStorage.updatePage(jpaPage);
            } else {
                jpaPage = ajc$this.jpaDataStorage.createPage(wiki, jcrParentPage, jpaPage);
            }
            ajc$this.jpaDataStorage.addPageVersion(jpaPage);
            for (int i = pageVersions.size() - 2; i >= 0; --i) {
                PageVersion version = (PageVersion)pageVersions.get(i);
                jpaPage.setAuthor(version.getAuthor());
                jpaPage.setContent(version.getContent());
                jpaPage.setUpdatedDate(version.getUpdatedDate());
                jpaPage.setComment(version.getComment());
                ajc$this.jpaDataStorage.updatePage(jpaPage);
                ajc$this.jpaDataStorage.addPageVersion(jpaPage);
            }
            String jcrPageId = jcrPage.getId();
            jcrPage.setId(jpaPage.getId());
            ajc$this.jpaDataStorage.updatePage(jcrPage);
            jcrPage.setId(jcrPageId);
            try {
                List watchers = ajc$this.jcrDataStorage.getWatchersOfPage(jcrPage);
                for (String watcher : watchers) {
                    ajc$this.jpaDataStorage.addWatcherToPage(watcher, jcrPage);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot get watchers of page " + jcrPage.getName() + ", keep trying to migrate it anyway - Cause : " + e.getMessage()), (Throwable)e);
            }
            List attachments = ajc$this.jcrDataStorage.getAttachmentsOfPage(jcrPage);
            for (Attachment attachment : attachments) {
                ajc$this.jpaDataStorage.addAttachmentToPage(attachment, jcrPage);
            }
        }
        finally {
            RequestLifeCycle.end();
            RequestLifeCycle.begin((ExoContainer)ajc$this.currentContainer);
        }
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MigrationService.java", MigrationService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createPage", "org.exoplatform.wiki.jpa.migration.MigrationService", "org.exoplatform.wiki.mow.api.Wiki:org.exoplatform.wiki.mow.api.Page:org.exoplatform.wiki.mow.api.Page:java.lang.Boolean", "wiki:jcrParentPage:jcrPage:checkPageMigrated", "org.exoplatform.wiki.WikiException", "java.lang.Boolean"), 910);
    }
}

