/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import java.util.List;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.wiki.jpa.dao.WikiBaseDAO;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.mow.api.WikiType;

public class PageDAO
extends WikiBaseDAO<PageEntity, Long> {
    public List<PageEntity> getAllPagesOfWiki(String wikiType, String wikiOwner) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getAllPagesOfWiki", PageEntity.class).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner);
        return query.getResultList();
    }

    public List<PageEntity> getPagesOfWiki(String wikiType, String wikiOwner, boolean deleted) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getPagesOfWiki", PageEntity.class).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner).setParameter("deleted", (Object)deleted);
        return query.getResultList();
    }

    public PageEntity getPageOfWikiByName(String wikiType, String wikiOwner, String pageName) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        PageEntity pageEntity = null;
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getPageOfWikiByName", PageEntity.class).setParameter("name", (Object)pageName).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner);
        List results = query.getResultList();
        if (results != null) {
            for (PageEntity pageEntityResult : results) {
                if (!pageEntityResult.getName().equals(pageName)) continue;
                if (pageEntity == null) {
                    pageEntity = pageEntityResult;
                    continue;
                }
                throw new NonUniqueResultException("More than 1 page with the name " + pageName + " in the wiki " + wikiType + ":" + wikiOwner + " has been returned");
            }
        }
        return pageEntity;
    }

    public List<PageEntity> getChildrenPages(PageEntity page) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getChildrenPages", PageEntity.class).setParameter("id", (Object)page.getId());
        return query.getResultList();
    }

    public List<Long> findAllIds(int offset, int limit) {
        return this.getEntityManager().createNamedQuery("wikiPage.getAllIds").setFirstResult(offset).setMaxResults(limit).getResultList();
    }
}

