/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.bean;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.wiki.webui.bean.DraftBean;

public class WikiDraftListAccess
implements ListAccess<DraftBean> {
    private final List<DraftBean> list;

    public WikiDraftListAccess(List<DraftBean> list) {
        this.list = list;
    }

    public DraftBean[] load(int index, int length) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        if (index + length > this.list.size()) {
            throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
        }
        DraftBean[] result = new DraftBean[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.list.get(i + index);
        }
        return result;
    }

    public int getSize() throws Exception {
        return this.list.size();
    }
}

