/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.ext.impl;

import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.ext.impl.WikiUIActivity;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.utils.Utils;

public class WikiSpaceActivityPublisher
extends PageWikiListener {
    public static final String WIKI_APP_ID = "ks-wiki:spaces";
    public static final String ACTIVITY_TYPE_KEY = "act_key";
    public static final String PAGE_ID_KEY = "page_id";
    public static final String PAGE_TYPE_KEY = "page_type";
    public static final String PAGE_OWNER_KEY = "page_owner";
    public static final String PAGE_TITLE_KEY = "page_name";
    public static final String URL_KEY = "page_url";
    public static final String PAGE_EXCERPT = "page_exceprt";
    public static final String VIEW_CHANGE_URL_KEY = "view_change_url";
    public static final String VIEW_CHANGE_ANCHOR = "#CompareRevision/changes";
    public static final String WIKI_PAGE_NAME = "wiki";
    public static final String WIKI_PAGE_VERSION = "version";
    private static final int EXCERPT_LENGTH = 140;
    private static final Log LOG = ExoLogger.getExoLogger(WikiSpaceActivityPublisher.class);
    private WikiService wikiService;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private SpaceService spaceService;

    public WikiSpaceActivityPublisher(WikiService wikiService, IdentityManager identityManager, ActivityManager activityManager, SpaceService spaceService) {
        this.wikiService = wikiService;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
        this.spaceService = spaceService;
    }

    private ExoSocialActivityImpl createNewActivity(String ownerId) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(ownerId);
        activity.setBody("body");
        activity.setType(WIKI_APP_ID);
        return activity;
    }

    private ExoSocialActivity generateActivity(Identity ownerStream, Identity ownerIdentity, String wikiType, String wikiOwner, String pageId, Page page, String spaceUrl, String spaceName, PageUpdateType activityType) throws WikiException {
        ExoSocialActivity activity = null;
        boolean isNewActivity = true;
        if (page.getActivityId() != null) {
            activity = this.activityManager.getActivity(page.getActivityId());
            boolean bl = isNewActivity = activity == null;
        }
        if (isNewActivity) {
            if (page.isMinorEdit()) {
                return null;
            }
            activity = this.createNewActivity(ownerIdentity.getId());
        }
        activity.setTitle(page.getTitle());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(PAGE_ID_KEY, pageId);
        templateParams.put(ACTIVITY_TYPE_KEY, activityType.toString());
        templateParams.put(PAGE_OWNER_KEY, wikiOwner);
        templateParams.put(PAGE_TYPE_KEY, wikiType);
        templateParams.put(PAGE_TITLE_KEY, page.getTitle());
        String pageURL = page.getUrl() == null ? (spaceUrl != null ? spaceUrl + "/" + WIKI_PAGE_NAME : "") : page.getUrl();
        templateParams.put(URL_KEY, pageURL);
        int versionsTotal = 0;
        List versions = this.wikiService.getVersionsOfPage(page);
        if (versions != null && !versions.isEmpty()) {
            versionsTotal = versions.size();
        }
        templateParams.put(WIKI_PAGE_VERSION, String.valueOf(versionsTotal));
        StringBuilder excerpt = new StringBuilder();
        try {
            excerpt.append(this.wikiService.getPageRenderedContent(page));
        }
        catch (Exception e) {
            throw new WikiException("Cannot render page " + page.getWikiType() + ":" + page.getWikiOwner() + page.getName(), (Throwable)e);
        }
        if (excerpt.length() > 140) {
            excerpt.replace(140, excerpt.length(), "...");
        }
        templateParams.put(PAGE_EXCERPT, this.validateExcerpt(excerpt.toString()));
        templateParams.put("registeredKeysForProcessor", PAGE_EXCERPT);
        if (!PageUpdateType.ADD_PAGE.equals((Object)activityType)) {
            String verName = null;
            if (versions != null && !versions.isEmpty()) {
                verName = String.valueOf(versions.size() + 1);
            }
            templateParams.put(VIEW_CHANGE_URL_KEY, Utils.getURL((String)page.getUrl(), verName));
        }
        activity.setTemplateParams(templateParams);
        if (isNewActivity) {
            this.activityManager.saveActivityNoReturn(ownerStream, activity);
        } else {
            if (PageUpdateType.MOVE_PAGE.equals((Object)activityType)) {
                activity.setStreamOwner(ownerStream.getRemoteId());
            }
            this.activityManager.updateActivity(activity);
        }
        if (!PageUpdateType.ADD_PAGE.equals((Object)activityType)) {
            String comment;
            if (PageUpdateType.EDIT_PAGE_TITLE.equals((Object)activityType) && !page.isMinorEdit()) {
                this.createAndSaveSystemComment(activity, ownerIdentity.getId(), "WikiUIActivity.msg.update-page-title", page.getTitle());
            } else if (PageUpdateType.EDIT_PAGE_CONTENT.equals((Object)activityType) && !page.isMinorEdit()) {
                comment = page.getComment();
                if (StringUtils.isEmpty((String)comment)) {
                    this.createAndSaveSystemComment(activity, ownerIdentity.getId(), "WikiUIActivity.msg.update-page-content", new String[0]);
                } else {
                    this.createAndSaveUserComment(activity, ownerIdentity.getId(), comment);
                }
            } else if (PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE.equals((Object)activityType) && !page.isMinorEdit()) {
                comment = page.getComment();
                if (StringUtils.isEmpty((String)comment)) {
                    this.createAndSaveComment(activity, WikiUIActivity.CommentType.SYSTEM_GROUP, ownerIdentity.getId(), null, "WikiUIActivity.msg.update-page-title", new String[]{page.getTitle()}, "WikiUIActivity.msg.update-page-content", null);
                } else {
                    this.createAndSaveComment(activity, WikiUIActivity.CommentType.SYSTEM_GROUP, ownerIdentity.getId(), null, "WikiUIActivity.msg.update-page-title", new String[]{page.getTitle()}, comment, null);
                }
            } else if (PageUpdateType.MOVE_PAGE.equals((Object)activityType)) {
                List breadcrumbDatas = this.wikiService.getBreadcumb(wikiType, wikiOwner, pageId);
                StringBuilder breadcrumText = new StringBuilder();
                breadcrumText.append(StringUtils.isEmpty((String)spaceName) ? wikiOwner : spaceName).append(" > ");
                for (int i = 0; i < breadcrumbDatas.size(); ++i) {
                    breadcrumText.append(((BreadcrumbData)breadcrumbDatas.get(i)).getTitle());
                    if (i >= breadcrumbDatas.size() - 1) continue;
                    breadcrumText.append(" > ");
                }
                this.createAndSaveSystemComment(activity, ownerIdentity.getId(), "WikiUIActivity.msg.move-page", breadcrumText.toString());
            }
        }
        return activity;
    }

    private String validateExcerpt(String excerpt) {
        List lines = Stream.of(excerpt.split("\n")).filter(line -> !line.trim().isEmpty()).collect(Collectors.toList());
        Stream sLines = lines.stream();
        StringBuilder result = new StringBuilder();
        sLines.map(new Function<String, String>(){

            @Override
            public String apply(String line) {
                if (line.length() > 140) {
                    line = line.substring(0, 140) + "...";
                }
                return line;
            }
        }).limit(4L).forEach(line -> {
            result.append("<p>");
            result.append((String)line);
            result.append("</p>");
        });
        if (lines.size() > 4) {
            result.append("...");
        }
        return result.toString();
    }

    private void createAndSaveSystemComment(ExoSocialActivity activity, String userId, String commentMsgKey, String ... args) {
        this.createAndSaveComment(activity, WikiUIActivity.CommentType.SYSTEM, userId, null, commentMsgKey, args, null, null);
    }

    private void createAndSaveUserComment(ExoSocialActivity activity, String userId, String comment) {
        this.createAndSaveComment(activity, WikiUIActivity.CommentType.USER, userId, comment, null, null, null, null);
    }

    private void createAndSaveComment(ExoSocialActivity activity, WikiUIActivity.CommentType commentType, String userId, String userComment, String commentMsgKey1, String[] args1, String commentMsgKey2, String[] args2) {
        ExoSocialActivityImpl newComment = new ExoSocialActivityImpl();
        StringBuilder builder = new StringBuilder();
        if (userComment == null) {
            userComment = this.getValueFromResourceBundle(commentMsgKey1, args1);
        }
        builder.append(userComment);
        newComment.setUserId(userId);
        HashMap<String, String> activityParams = new HashMap<String, String>();
        activityParams.put("commentType", commentType.name());
        switch (commentType) {
            case USER: {
                break;
            }
            case SYSTEM: {
                activityParams.put("commentMessageKey", commentMsgKey1);
                activityParams.put("messageArgs", StringUtils.join((Object[])args1, (String)"\n"));
                break;
            }
            case SYSTEM_GROUP: {
                activityParams.put("commentMessageKey1", commentMsgKey1);
                activityParams.put("messageArgs1", StringUtils.join((Object[])args1, (String)"\n"));
                activityParams.put("commentMessageKey2", commentMsgKey2);
                activityParams.put("messageArgs2", StringUtils.join((Object[])args2, (String)"\n"));
                if (args2 != null) {
                    builder.append("<br/>").append(this.getValueFromResourceBundle(commentMsgKey2, args2));
                    break;
                }
                builder.append("<br/>").append(commentMsgKey2);
            }
        }
        newComment.setTemplateParams(activityParams);
        newComment.setTitle(builder.toString());
        this.activityManager.saveComment(activity, (ExoSocialActivity)newComment);
    }

    private String getValueFromResourceBundle(String key, String[] params) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        if (res.getString(key) == null) {
            return key;
        }
        String value = res.getString(key);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                value = value.replace("{" + i + "}", params[i]);
            }
        }
        return value;
    }

    private boolean isPublic(Page page) throws WikiException {
        List permissions = page.getPermissions();
        boolean isPublic = false;
        if (permissions != null) {
            block0: for (PermissionEntry permissionEntry : permissions) {
                if (!permissionEntry.getId().equals(IdentityConstants.ANY)) continue;
                for (Permission permission : permissionEntry.getPermissions()) {
                    if (!PermissionType.VIEWPAGE.equals((Object)permission.getPermissionType())) continue;
                    isPublic = true;
                    continue block0;
                }
            }
        }
        return isPublic;
    }

    private boolean isPublicInSpace(Page page, Space space) throws WikiException {
        List pagePermissions = page.getPermissions();
        String groupMemberShip = "*:" + space.getGroupId();
        boolean isPublic = false;
        if (pagePermissions != null) {
            for (PermissionEntry permissionEntry : pagePermissions) {
                IDType permissionIDType = permissionEntry.getIdType();
                String permissionId = permissionEntry.getId();
                if ((!permissionIDType.equals((Object)IDType.MEMBERSHIP) || !permissionId.equals(groupMemberShip)) && (!permissionIDType.equals((Object)IDType.GROUP) || !permissionId.equals(space.getGroupId()))) continue;
                isPublic = true;
                break;
            }
        }
        return isPublic;
    }

    protected void saveActivity(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType activityType) throws WikiException {
        String spaceName;
        String spaceUrl;
        ExoSocialActivity activity;
        Identity authorActivity;
        Identity ownerStream;
        Identity userIdentity;
        block13: {
            try {
                Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"eXo Social components not found!", (Throwable)e);
                }
                return;
            }
            if (PortalConfig.USER_TYPE.equals(wikiType)) {
                return;
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            userIdentity = this.identityManager.getOrCreateIdentity("organization", username, false);
            ownerStream = null;
            authorActivity = userIdentity;
            activity = null;
            spaceUrl = null;
            spaceName = null;
            if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
                try {
                    Space space = this.spaceService.getSpaceByGroupId(wikiOwner);
                    if (space != null) {
                        if (!this.isPublicInSpace(page, space)) {
                            return;
                        }
                        ownerStream = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
                        spaceUrl = space.getUrl();
                        spaceName = space.getDisplayName();
                    }
                }
                catch (SpaceStorageException e) {
                    if (!LOG.isDebugEnabled()) break block13;
                    LOG.debug((Object)String.format("Space %s not existed", wikiOwner), (Throwable)e);
                }
            }
        }
        if (ownerStream == null) {
            ownerStream = userIdentity;
        }
        if (ownerStream != null) {
            activity = this.generateActivity(ownerStream, authorActivity, wikiType, wikiOwner, pageId, page, spaceUrl, spaceName, activityType);
            if (activity == null) {
                return;
            }
            String activityId = activity.getId();
            if (!StringUtils.isEmpty((String)activityId)) {
                page.setActivityId(activityId);
                this.wikiService.updatePage(page, null);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        if ("WikiHome".equals(pageId)) {
            return;
        }
        this.saveActivity(wikiType, wikiOwner, pageId, page, PageUpdateType.ADD_PAGE);
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        if (page.getActivityId() != null && StringUtils.isNotEmpty((String)page.getActivityId())) {
            this.activityManager.deleteActivity(page.getActivityId());
        }
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        if (page != null && wikiUpdateType != null && (wikiUpdateType.equals((Object)PageUpdateType.ADD_PAGE) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_TITLE) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE) || wikiUpdateType.equals((Object)PageUpdateType.MOVE_PAGE))) {
            this.saveActivity(wikiType, wikiOwner, pageId, page, wikiUpdateType);
        }
    }
}

