/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.span;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.wiki.rendering.macro.MacroUtils;
import org.exoplatform.wiki.rendering.macro.span.SpanParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.ParserUtils;

@Component(value="span")
public class SpanMacro
extends AbstractMacro<SpanParameters> {
    private static final String CLASS_ATT = "class";
    private static final String STYLE_ATT = "style";
    private static final String DESCRIPTION = "Decorate text line";
    @Inject
    private ComponentManager componentManager;

    public SpanMacro() {
        super("Span", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(), SpanParameters.class);
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(SpanParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (content != null) {
            String cssClass = parameters.getCssClass();
            String cssContent = parameters.getStyle();
            HashMap<String, String> params = new HashMap<String, String>();
            if (!StringUtils.isEmpty((String)cssClass) && !StringUtils.isEmpty((String)cssClass)) {
                params.put(CLASS_ATT, cssClass);
            }
            if (!StringUtils.isEmpty((String)cssContent)) {
                params.put(STYLE_ATT, cssContent);
            }
            List<Block> contentBlocks = MacroUtils.parseSourceSyntax(this.getComponentManager(), content, context);
            new ParserUtils().removeTopLevelParagraph(contentBlocks);
            FormatBlock spanBlock = new FormatBlock(contentBlocks, Format.NONE, params);
            return Collections.singletonList(spanBlock);
        }
        return Collections.emptyList();
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }
}

