/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.converter;

import java.util.ArrayList;
import org.exoplatform.wiki.rendering.converter.ConfluenceToXWiki2Transformer;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

public class ConfluenceToXWiki2DeepTransformation {
    private static ConfluenceToXWiki2DeepTransformation instance;
    private ComponentManager componentManager;

    public static synchronized ConfluenceToXWiki2DeepTransformation getInstance() {
        if (instance == null) {
            instance = new ConfluenceToXWiki2DeepTransformation();
        }
        return instance;
    }

    private ConfluenceToXWiki2DeepTransformation() {
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public void transform(Block block, TransformationContext transformationContext) throws TransformationException {
        ArrayList<Block> children = new ArrayList<Block>();
        for (Block child : block.getChildren()) {
            if (child instanceof MacroBlock) {
                String macro;
                MacroBlock macroBlock = (MacroBlock)child;
                String content = macroBlock.getContent();
                if (content.endsWith(macro = "{" + macroBlock.getId() + "}")) {
                    content = content.substring(0, content.length() - macro.length());
                }
                String formattedContent = this.formatContent(macroBlock.getId(), content);
                child = new MacroBlock(macroBlock.getId(), macroBlock.getParameters(), formattedContent, macroBlock.isInline());
                child.setChildren(macroBlock.getChildren());
            }
            children.add(child);
            this.transform(child, transformationContext);
        }
        block.setChildren(children);
    }

    public String formatContent(String macro, String content) {
        if (macro.equals("noformat") || macro.equals("code") || macro.equals("csv") || macro.equals("style")) {
            return content;
        }
        return ConfluenceToXWiki2Transformer.transformContent(content, this.componentManager);
    }
}

