/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.pagetree;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.rendering.context.MarkupContextManager;
import org.exoplatform.wiki.rendering.macro.pagetree.PageTreeMacroParameters;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.wiki.WikiModel;

@Component(value="pagetree")
public class PageTreeMacro
extends AbstractMacro<PageTreeMacroParameters> {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private static final String DESCRIPTION = "Display a hierachy descendants tree of a specific page";
    private static final Syntax XHTML_SYNTAX = new Syntax(SyntaxType.XHTML, "1.0");
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private MarkupContextManager markupContextManager;
    private boolean excerpt;

    public PageTreeMacro() {
        super("Page Tree", DESCRIPTION, PageTreeMacroParameters.class);
        this.setDefaultCategory("Navigation");
    }

    public List<Block> execute(PageTreeMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        WikiContext wikiContext;
        String documentName = parameters.getRoot();
        String startDepth = parameters.getStartDepth();
        this.excerpt = parameters.isExcerpt();
        if (StringUtils.isEmpty((String)startDepth)) {
            startDepth = "1";
        }
        WikiContext params = this.markupContextManager.getMarkupContext(documentName, ResourceType.DOCUMENT);
        if ("".equals(documentName) && (wikiContext = this.getWikiContext()) != null) {
            params = wikiContext;
        }
        try {
            Block root = this.generateTree(params, startDepth);
            PageRenderingCacheService renderingCacheService = (PageRenderingCacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PageRenderingCacheService.class);
            WikiContext wikiContext2 = this.getWikiContext();
            renderingCacheService.addPageLink(new WikiPageParams(wikiContext2.getType(), wikiContext2.getOwner(), wikiContext2.getPageId()), new WikiPageParams(params.getType(), params.getOwner(), params.getPageId()));
            return Collections.singletonList(root);
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to execute page tree macro", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    protected WikiModel getWikiModel(MacroTransformationContext context) throws MacroExecutionException {
        try {
            return (WikiModel)this.getComponentManager().getInstance(WikiModel.class);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find wiki model", (Throwable)e);
        }
    }

    private Block generateTree(WikiPageParams params, String startDepth) throws Exception {
        StringBuilder treeSb = new StringBuilder();
        StringBuilder initSb = new StringBuilder();
        TreeNode node = TreeUtils.getTreeNode(params);
        WikiContext wikiContext = this.getWikiContext();
        String treeRestURI = wikiContext.getTreeRestURI();
        String redirectURI = wikiContext.getRedirectURI();
        String baseURL = wikiContext.getBaseUrl();
        initSb.append("?").append("path").append("=").append(node.getPath()).append("&").append("excerpt").append("=").append(this.excerpt).append("&").append("depth").append("=").append(startDepth);
        treeSb.append("<div class=\"UITreeExplorer PageTreeMacro\">").append("  <div>").append("    <input class=\"ChildrenURL\" title=\"hidden\" type=\"hidden\" value=\"").append(treeRestURI).append("\" />").append("    <input class=\"InitParams\" title=\"hidden\" type=\"hidden\" value=\"").append(initSb.toString()).append("\" />").append("    <input class=\"BaseURL\" title=\"hidden\" type=\"hidden\" value=\"").append(baseURL).append("\" />").append("    <a class=\"SelectNode\" style=\"display:none\" href=\"").append(redirectURI).append("\" ></a>").append("  </div>").append("</div>");
        RawBlock testRaw = new RawBlock(treeSb.toString(), XHTML_SYNTAX);
        return testRaw;
    }

    private WikiContext getWikiContext() {
        ExecutionContext ec = this.execution.getContext();
        if (ec != null) {
            WikiContext wikiContext = (WikiContext)ec.getProperty("wikicontext");
            return wikiContext;
        }
        return null;
    }
}

