/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search;

import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.utils.Utils;

public class TitleSearchResult {
    private static final Log log = ExoLogger.getLogger(TitleSearchResult.class);
    private String fullTitle;
    private String type;
    private String path;
    private String uri;
    private String fileType;

    public TitleSearchResult() {
    }

    public TitleSearchResult(String fullTitle, String path, String type, String fileType) {
        this.fullTitle = fullTitle;
        this.type = type;
        this.path = path;
        this.fileType = fileType;
        this.setUri();
    }

    public String getFullTitle() {
        return this.fullTitle;
    }

    public void setFullTitle(String fullTitle) {
        this.fullTitle = fullTitle;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    private Wiki getWiki() throws Exception {
        Wiki searchWiki = null;
        if ("wiki:page".equals(this.getType())) {
            PageImpl pageImpl = (PageImpl)Utils.getObject(this.getPath(), this.getType());
            searchWiki = pageImpl.getWiki();
        }
        if ("wiki:attachment".equals(this.getType())) {
            AttachmentImpl searchContent = (AttachmentImpl)Utils.getObject(this.getPath(), this.getType());
            searchWiki = searchContent.getParentPage().getWiki();
        }
        return searchWiki;
    }

    private String getWikiType() throws Exception {
        return this.getWiki().getType();
    }

    public String getUri() {
        return this.uri;
    }

    private void setUri() {
        StringBuilder sb;
        block6: {
            sb = new StringBuilder();
            try {
                if ("wiki:page".equals(this.getType())) {
                    String wikiType = this.getWikiType();
                    if (!PortalConfig.PORTAL_TYPE.equalsIgnoreCase(wikiType)) {
                        sb.append("/");
                        sb.append(wikiType);
                        sb.append("/");
                        sb.append(Utils.validateWikiOwner(wikiType, this.getWiki().getOwner()));
                    }
                    sb.append(this.path.substring(this.path.lastIndexOf("/")));
                } else if ("wiki:attachment".equals(this.getType())) {
                    AttachmentImpl searchAtt = (AttachmentImpl)Utils.getObject(this.getPath(), this.getType());
                    sb.append(searchAtt.getDownloadURL());
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)("failed to make uri for resource " + this.path), (Throwable)e);
            }
        }
        this.uri = sb.toString();
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }
}

