/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.wiki.service.search.SearchData;

public class WikiSearchData
extends SearchData {
    public static String WIKIHOME_PATH = "WikiHome";
    public static String ALL_PAGESPATH = "%/" + WIKIHOME_PATH;
    public static String PORTAL_PAGESPATH = PORTAL_PATH + WIKIHOME_PATH;
    public static String GROUP_PAGESPATH = GROUP_PATH + WIKIHOME_PATH;
    public static String ASC_ORDER = "ASC";
    public static String DESC_ORDER = "DESC";
    private String pagePath = "";
    private String nodeType = null;

    public WikiSearchData(String text, String title, String content, String wikiType, String wikiOwner, String pageId) {
        super(text, title, content, wikiType, wikiOwner, pageId);
        this.createJcrQueryPath();
    }

    public WikiSearchData(String wikiType, String wikiOwner, String pageId) {
        this(null, null, null, wikiType, wikiOwner, pageId);
    }

    public WikiSearchData(String text, String title, String content, String wikiType, String wikiOwner) {
        this(text, title, content, wikiType, wikiOwner, null);
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void createJcrQueryPath() {
        if (this.wikiType == null && this.wikiOwner == null) {
            this.pagePath = ALL_PAGESPATH;
        }
        if (this.wikiType != null) {
            if (this.wikiType.equals(PortalConfig.USER_TYPE)) {
                this.pagePath = this.USER_PATH + WIKIHOME_PATH;
            } else {
                if (this.wikiType.equals(PortalConfig.PORTAL_TYPE)) {
                    this.pagePath = PORTAL_PAGESPATH;
                } else if (this.wikiType.equals(PortalConfig.GROUP_TYPE)) {
                    this.pagePath = GROUP_PAGESPATH;
                }
                if (this.wikiOwner != null && this.wikiOwner.length() > 0) {
                    this.pagePath = this.pagePath.replaceFirst("%", this.wikiOwner);
                }
            }
        }
        this.jcrQueryPath = "jcr:path LIKE '" + this.pagePath + "/%'";
    }

    public String getStatementForTitle(boolean onlyHomePages) {
        StringBuilder statement = new StringBuilder();
        String queryPath = this.jcrQueryPath;
        if (onlyHomePages) {
            queryPath = queryPath.substring(0, queryPath.length() - 3) + "'";
        }
        statement.append("SELECT jcr:primaryType, jcr:path, jcr:score, title, fileType ").append("FROM nt:base ").append("WHERE ").append(queryPath).append(" AND ").append("LOWER(title) LIKE '%").append(this.title).append("%' ").append("ORDER BY jcr:score DESC");
        return statement.toString();
    }

    @Override
    public String getStatementForSearchingTitle() {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT title, jcr:primaryType, path, excerpt(.) ");
        if (this.nodeType == null) {
            statement.append("FROM nt:base ");
        } else {
            statement.append("FROM " + this.nodeType + " ");
        }
        statement.append("WHERE ");
        statement.append(this.searchTitleCondition());
        statement.append(this.createOrderClause());
        return statement.toString();
    }

    public String getStatementForSearchingContent() {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT jcr:content, jcr:primaryType, path, excerpt(.) ");
        statement.append("FROM wiki:attachment ");
        statement.append("WHERE ");
        statement.append(this.searchContentCondition());
        statement.append(this.createOrderClause());
        return statement.toString();
    }

    public String getStatementForRenamedPage() {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT * ").append("FROM wiki:renamed ").append("WHERE ");
        statement.append(this.jcrQueryPath);
        if (this.getPageId() != null && this.getPageId().length() > 0) {
            statement.append(" AND ");
            statement.append(" oldPageIds = '").append(this.getPageId()).append("'");
        }
        return statement.toString();
    }

    private String createOrderClause() {
        StringBuffer clause = new StringBuffer();
        if (this.isOrderValid(this.order) && StringUtils.isNotEmpty((String)this.sort)) {
            clause.append(" ORDER BY ");
            clause.append(this.sort);
            clause.append(" ");
            clause.append(this.order);
        }
        return clause.toString();
    }

    private boolean isOrderValid(String order) {
        return ASC_ORDER.equals(order) || DESC_ORDER.equals(order) || "".equals(order);
    }

    public String getPageConstraint() {
        StringBuilder constraint = new StringBuilder();
        String absPagePath = this.pagePath + "/" + this.pageId;
        String pageLikePath = this.pagePath + "/%/" + this.pageId;
        boolean isWikiHome = false;
        if ("WikiHome".equals(this.pageId)) {
            absPagePath = this.pagePath;
            isWikiHome = true;
        }
        if (this.wikiType == null || this.wikiOwner == null) {
            absPagePath = "/" + this.pageId;
            pageLikePath = "/%/" + this.pageId;
        }
        constraint.append('(').append('(').append("jcr:path LIKE '").append(pageLikePath).append('\'');
        if (!isWikiHome) {
            constraint.append(" or (jcr:path = '").append(absPagePath).append('\'').append(')');
        }
        constraint.append(")").append(" AND ").append("(jcr:mixinTypes IS NULL OR NOT (jcr:mixinTypes = 'wiki:removed'))").append(')');
        return constraint.toString();
    }

    private List<String> parseSearchText(String searchText) {
        LinkedList<String> terms = new LinkedList<String>();
        Matcher matcher = Pattern.compile("\"([^\"]+)\"").matcher(searchText);
        while (matcher.find()) {
            String founds = matcher.group(1);
            terms.add(founds);
        }
        String remain = matcher.replaceAll("").replaceAll("\"", "").trim();
        if (!remain.isEmpty()) {
            terms.addAll(Arrays.asList(remain.split("\\s+")));
        }
        return terms;
    }

    private String searchContentCondition() {
        StringBuilder clause = new StringBuilder();
        String queryPath = this.jcrQueryPath;
        clause.append(queryPath);
        if (this.text != null && this.text.length() > 0) {
            clause.append(" AND (");
            List<String> inputs = this.parseSearchText(this.text);
            int inputCount = 0;
            for (String keyword : inputs) {
                if (inputCount > 0) {
                    clause.append(" OR ");
                }
                clause.append(" CONTAINS(*, '").append(keyword).append("')");
                ++inputCount;
            }
            clause.append(")");
        } else if (this.content != null && this.content.length() > 0) {
            clause.append(" AND ");
            clause.append(" CONTAINS(*, '").append(this.content).append("') ");
        }
        return clause.toString();
    }

    private String searchTitleCondition() {
        StringBuilder clause = new StringBuilder();
        String queryPath = this.jcrQueryPath;
        clause.append(queryPath);
        if (this.text != null && this.text.length() > 0) {
            clause.append(" AND (");
            List<String> inputs = this.parseSearchText(this.text);
            int inputCount = 0;
            for (String keyword : inputs) {
                if (inputCount > 0) {
                    clause.append(" OR ");
                }
                clause.append(" CONTAINS(*, '").append(keyword).append("')");
                ++inputCount;
            }
            clause.append(")");
        } else if (this.title != null && this.title.length() > 0) {
            clause.append(" AND ");
            clause.append(" CONTAINS(title, '").append(this.title).append("') ");
        }
        return clause.toString();
    }
}

