/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PortalWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.utils.Utils;

@PrimaryType(name="wiki:portalwikis")
public abstract class PortalWikiContainer
extends WikiContainer<PortalWiki> {
    @OneToOne
    @MappedBy(value="portalwikis")
    public abstract WikiStoreImpl getMultiWiki();

    @Override
    public PortalWiki addWiki(String wikiOwner) {
        if ((wikiOwner = this.validateWikiOwner(wikiOwner)) == null) {
            return null;
        }
        ChromatticSession session = this.getMultiWiki().getSession();
        Node wikiNode = null;
        try {
            Node wikisNode = (Node)session.getJCRSession().getItem(Utils.getPortalWikisPath());
            try {
                wikiNode = wikisNode.getNode(wikiOwner);
            }
            catch (PathNotFoundException e) {
                wikiNode = wikisNode.addNode(wikiOwner, "wiki:portalwiki");
                wikisNode.save();
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
        PortalWiki pwiki = (PortalWiki)session.findByNode(PortalWiki.class, wikiNode);
        pwiki.setWikiService(this.getwService());
        pwiki.setOwner(wikiOwner);
        pwiki.setPortalWikis(this);
        pwiki.getPreferences();
        session.save();
        return pwiki;
    }
}

