/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.UndeclaredRepositoryException;
import org.exoplatform.wiki.mow.api.Model;
import org.exoplatform.wiki.mow.api.WikiStore;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;

public class ModelImpl
implements Model {
    private final ChromatticSession session;
    private WikiStoreImpl store;

    public ModelImpl(ChromatticSession chromeSession) {
        this.session = chromeSession;
    }

    @Override
    public WikiStore getWikiStore() {
        if (this.store == null) {
            this.store = (WikiStoreImpl)this.session.findByPath(WikiStoreImpl.class, "exo:applications/eXoWiki/wikimetadata");
            if (this.store == null) {
                try {
                    Node rootNode = this.session.getJCRSession().getRootNode();
                    Node publicApplicationNode = rootNode.getNode("exo:applications");
                    Node eXoWiki = null;
                    try {
                        eXoWiki = publicApplicationNode.getNode("eXoWiki");
                    }
                    catch (PathNotFoundException e) {
                        eXoWiki = publicApplicationNode.addNode("eXoWiki");
                        publicApplicationNode.save();
                    }
                    Node wikiMetadata = eXoWiki.addNode("wikimetadata", "wiki:store");
                    Node wikis = eXoWiki.addNode("wikis");
                    this.save();
                    this.store = (WikiStoreImpl)this.session.findByNode(WikiStoreImpl.class, wikiMetadata);
                }
                catch (RepositoryException e) {
                    throw new UndeclaredRepositoryException(e);
                }
            }
        }
        this.store.setSession(this.session);
        return this.store;
    }

    @Override
    public void save() {
        this.session.save();
    }

    @Override
    public void close() {
        this.session.close();
    }
}

