/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.NoSuchNodeException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.UserWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.utils.Utils;

@PrimaryType(name="wiki:userwikis")
public abstract class UserWikiContainer
extends WikiContainer<UserWiki> {
    @OneToOne
    @MappedBy(value="userwikis")
    public abstract WikiStoreImpl getMultiWiki();

    @Override
    public UserWiki addWiki(String wikiOwner) {
        return this.getWikiObject(wikiOwner, true);
    }

    @Override
    protected UserWiki getWikiObject(String wikiOwner, boolean createIfNonExist) {
        Node wikiNode;
        ChromatticSession session;
        block10: {
            NodeHierarchyCreator nodeHierachyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            if ((wikiOwner = this.validateWikiOwner(wikiOwner)) == null) {
                return null;
            }
            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            try {
                if (organizationService.getUserHandler().findUserByName(wikiOwner) == null) {
                    return null;
                }
            }
            catch (Exception ex) {
                return null;
            }
            session = this.getMultiWiki().getSession();
            wikiNode = null;
            try {
                Node tempNode = nodeHierachyCreator.getUserApplicationNode(Utils.createSystemProvider(), wikiOwner);
                Node userDataNode = (Node)session.getJCRSession().getItem(tempNode.getPath());
                try {
                    wikiNode = userDataNode.getNode("eXoWiki");
                }
                catch (PathNotFoundException e) {
                    if (createIfNonExist) {
                        wikiNode = userDataNode.addNode("eXoWiki", "wiki:userwiki");
                        userDataNode.save();
                        break block10;
                    }
                    return null;
                }
            }
            catch (Exception e) {
                if (e instanceof PathNotFoundException) {
                    throw new NoSuchNodeException((Throwable)e);
                }
                throw new UndeclaredRepositoryException(e.getMessage());
            }
        }
        UserWiki uwiki = (UserWiki)session.findByNode(UserWiki.class, wikiNode);
        uwiki.setWikiService(this.getwService());
        uwiki.setOwner(wikiOwner);
        uwiki.setUserWikis(this);
        uwiki.getPreferences();
        this.initDefaultPermisisonForWiki(uwiki);
        session.save();
        return uwiki;
    }
}

