/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.util.Collection;
import java.util.List;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToMany;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;
import org.exoplatform.wiki.service.WikiService;

public abstract class WikiContainer<T extends Wiki> {
    private static final Log log = ExoLogger.getLogger(WikiContainer.class);
    private WikiService wService;

    @OneToMany(type=RelationshipType.REFERENCE)
    @MappedBy(value="ref")
    public abstract Collection<T> getWikis();

    public abstract T addWiki(String var1);

    @Create
    public abstract T createWiki();

    protected String validateWikiOwner(String wikiOwner) {
        return wikiOwner;
    }

    public WikiService getwService() {
        return this.wService;
    }

    public void setwService(WikiService wService) {
        this.wService = wService;
    }

    public T getWiki(String wikiOwner, boolean hasAdminPermission) {
        T wiki = this.contains(wikiOwner);
        if (wiki != null) {
            return wiki;
        }
        if (hasAdminPermission && (wiki = this.addWiki(wikiOwner)) != null) {
            ((WikiImpl)wiki).initTemplate();
        }
        return wiki;
    }

    public Collection<T> getAllWikis() {
        return this.getWikis();
    }

    public T contains(String wikiOwner) {
        if ((wikiOwner = this.validateWikiOwner(wikiOwner)) == null) {
            return null;
        }
        return this.getWikiObject(wikiOwner, false);
    }

    protected abstract T getWikiObject(String var1, boolean var2);

    public void initDefaultPermisisonForWiki(Wiki wiki) {
        WikiService wikiService = this.getwService();
        try {
            List<String> permissions = wikiService.getWikiDefaultPermissions(wiki.getType(), wiki.getOwner());
            wiki.setWikiPermissions(permissions);
            wiki.setDefaultPermissionsInited(true);
        }
        catch (Exception e) {
            log.warn((Object)String.format("Can not initialize the permission for wiki [type: %s, owner: %s]", wiki.getType(), wiki.getOwner()), (Throwable)e);
        }
    }
}

