/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.cache.impl;

import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.chain.Context;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.wiki.chromattic.ext.ntdef.UncachedMixin;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.utils.Utils;

public class UpdatePageRenderingCacheAction
implements Action {
    public boolean execute(Context context) throws Exception {
        Object item = context.get((Object)"currentItem");
        Object eventObj = context.get((Object)InvocationContext.EVENT);
        int eventCode = Integer.parseInt(eventObj.toString());
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PageRenderingCacheService pRenderingCacheService = (PageRenderingCacheService)container.getComponentInstanceOfType(PageRenderingCacheService.class);
        switch (eventCode) {
            case 1: {
                PageImpl parentPage;
                Wiki wiki;
                if (!(item instanceof Node)) break;
                Node node = (Node)item;
                Node parent = ((Node)item).getParent();
                if (!parent.isNodeType("wiki:page") || !node.isNodeType("wiki:page") || (wiki = (parentPage = (PageImpl)Utils.getObject(parent.getPath(), "wiki:page")).getWiki()) == null) break;
                pRenderingCacheService.invalidateCache(new WikiPageParams(wiki.getType(), wiki.getOwner(), parentPage.getName()));
                pRenderingCacheService.invalidateCache(new WikiPageParams(wiki.getType(), wiki.getOwner(), node.getName()));
                break;
            }
            case 256: {
                PageImpl page;
                Wiki wiki;
                Node node;
                if (item instanceof Node && (node = (Node)item).isNodeType("wiki:page") && (wiki = (page = (PageImpl)Utils.getObject(node.getPath(), "wiki:page")).getWiki()) != null) {
                    pRenderingCacheService.invalidateCache(new WikiPageParams(wiki.getType(), wiki.getOwner(), page.getName()));
                    pRenderingCacheService.getPageLinksMap().remove(new WikiPageParams(wiki.getType(), wiki.getOwner(), page.getName()));
                }
            }
            case 16: {
                PageImpl page;
                Wiki wiki;
                Object previousItem = context.get((Object)"previousItem");
                if (!(item instanceof Property) || !(previousItem instanceof Property)) break;
                Property currentProperty = (Property)item;
                Node node = ((Property)item).getParent();
                if ("oldPageIds".equals(currentProperty.getName())) {
                    PageImpl page2;
                    Wiki wiki2;
                    if (!node.isNodeType("wiki:page") || (wiki2 = (page2 = (PageImpl)Utils.getObject(node.getPath(), "wiki:page")).getWiki()) == null) break;
                    pRenderingCacheService.invalidateCache(new WikiPageParams(wiki2.getType(), wiki2.getOwner(), page2.getName()));
                    pRenderingCacheService.invalidateUUIDCache(new WikiPageParams(wiki2.getType(), wiki2.getOwner(), page2.getName()));
                    break;
                }
                if (!"targetPage".equals(currentProperty.getName()) || !node.isNodeType("wiki:page") || (wiki = (page = (PageImpl)Utils.getObject(node.getPath(), "wiki:page")).getWiki()) == null) break;
                pRenderingCacheService.invalidateCache(new WikiPageParams(wiki.getType(), wiki.getOwner(), page.getName()));
                PageImpl desPage = page.getMovedMixin().getTargetPage();
                pRenderingCacheService.invalidateUUIDCache(new WikiPageParams(wiki.getType(), wiki.getOwner(), desPage.getName()));
                pRenderingCacheService.getPageLinksMap().remove(new WikiPageParams(wiki.getType(), wiki.getOwner(), page.getName()));
                break;
            }
            case 8192: {
                PageImpl page;
                Wiki wiki;
                Node node = (Node)item;
                if (!node.isNodeType("wiki:attachment") || (wiki = (page = (PageImpl)Utils.getObject((node = node.getParent()).getPath(), "wiki:page")).getWiki()) == null) break;
                pRenderingCacheService.invalidateCache(new WikiPageParams(wiki.getType(), wiki.getOwner(), page.getName()));
                break;
            }
            case 16384: {
                PageImpl page;
                Wiki wiki;
                Node node = (Node)item;
                if (!node.isNodeType("wiki:attachment") || (wiki = (page = (PageImpl)Utils.getObject(node.getParent().getPath(), "wiki:page")).getWiki()) == null) break;
                this.checkUncachedMacroesInPage(page);
                break;
            }
        }
        return false;
    }

    private void checkUncachedMacroesInPage(PageImpl page) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PageRenderingCacheService pRenderingCacheService = (PageRenderingCacheService)container.getComponentInstanceOfType(PageRenderingCacheService.class);
        String content = page.getContent().getText();
        boolean found = false;
        for (String macro : pRenderingCacheService.getUncachedMacroes()) {
            String m1 = "{{" + macro + "}}";
            String m2 = "{{" + macro + "/}}";
            String m3 = "{{" + macro + " ";
            if (!content.contains(m1) && !content.contains(m2) && !content.contains(m3)) continue;
            found = true;
            break;
        }
        ChromatticSession session = page.getMOWService().getSession();
        if (found) {
            if (page.getUncachedMixin() == null) {
                UncachedMixin uncachedMix = (UncachedMixin)session.create(UncachedMixin.class);
                session.setEmbedded((Object)page, UncachedMixin.class, (Object)uncachedMix);
            }
        } else if (page.getUncachedMixin() != null) {
            session.setEmbedded((Object)page, UncachedMixin.class, null);
        }
    }
}

