/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.mow.core.api.wiki.LinkRegistry;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PermissionImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PreferencesImpl;
import org.exoplatform.wiki.mow.core.api.wiki.Trash;
import org.exoplatform.wiki.mow.core.api.wiki.WikiHome;
import org.xwiki.rendering.syntax.Syntax;

public abstract class WikiImpl {
    private static final Log LOG = ExoLogger.getLogger(WikiImpl.class);
    private PermissionImpl permission = new PermissionImpl();

    @Create
    public abstract PageImpl createWikiPage();

    public abstract WikiType getWikiType();

    public WikiHome getWikiHome() {
        WikiHome home = this.getHome();
        if (home == null) {
            home = this.createWikiHome();
            this.setHome(home);
            home.makeVersionable();
            home.setOwner(this.getOwner());
            home.setTitle("Wiki Home");
            Date now = GregorianCalendar.getInstance().getTime();
            home.setCreatedDate(now);
            home.setUpdatedDate(now);
            home.setSyntax(Syntax.XWIKI_2_0.toIdString());
            try {
                this.initPermisionForWikiHome(home);
                home.checkin();
                home.checkout();
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
                return home;
            }
        }
        return home;
    }

    private void initPermisionForWikiHome(WikiHome home) throws Exception {
        List<String> wikiPermission = this.getWikiPermissions();
        if (wikiPermission == null) {
            home.setNonePermission();
            return;
        }
        HashMap<String, String[]> permMap = new HashMap<String, String[]>();
        for (String perm : wikiPermission) {
            String[] actions = perm.substring(0, perm.indexOf(":")).split(",");
            perm = perm.substring(perm.indexOf(":") + 1);
            String id = perm.substring(perm.indexOf(":") + 1);
            ArrayList<String> jcrActions = new ArrayList<String>();
            for (String action : actions) {
                if (PermissionType.VIEWPAGE.toString().equals(action)) {
                    jcrActions.add("read");
                    continue;
                }
                if (!PermissionType.EDITPAGE.toString().equals(action)) continue;
                jcrActions.add("add_node");
                jcrActions.add("remove");
                jcrActions.add("set_property");
            }
            permMap.put(id, jcrActions.toArray(new String[jcrActions.size()]));
        }
        home.setPermission(permMap);
    }

    public LinkRegistry getLinkRegistry() {
        LinkRegistry linkRegistry = this.getLinkRegistryByChromattic();
        if (linkRegistry == null) {
            linkRegistry = this.createLinkRegistry();
            this.setLinkRegistryByChromattic(linkRegistry);
        }
        return linkRegistry;
    }

    public Trash getTrash() {
        Trash trash = this.getTrashByChromattic();
        if (trash == null) {
            trash = this.createTrash();
            this.setTrashByChromattic(trash);
        }
        return trash;
    }

    public PreferencesImpl getPreferences() {
        PreferencesImpl preferences = this.getPreferencesByChromattic();
        if (preferences == null) {
            preferences = this.createPreferences();
            this.setPreferencesByChromattic(preferences);
        }
        return preferences;
    }

    @Name
    public abstract String getName();

    @Property(name="owner")
    public abstract String getOwner();

    public abstract void setOwner(String var1);

    @Path
    public abstract String getPath();

    @Property(name="wikiPermissions")
    public abstract List<String> getWikiPermissions();

    public abstract void setWikiPermissions(List<String> var1);

    @Property(name="isDefaultPermissionsInited")
    public abstract boolean getDefaultPermissionsInited();

    public abstract void setDefaultPermissionsInited(boolean var1);

    public PageImpl getPageByID(String id) {
        throw new UnsupportedOperationException();
    }

    public PageImpl getPageByURI(String uri) {
        throw new UnsupportedOperationException();
    }

    public abstract String getType();

    @OneToOne
    @Owner
    @MappedBy(value="WikiHome")
    protected abstract WikiHome getHome();

    protected abstract void setHome(WikiHome var1);

    @Create
    protected abstract WikiHome createWikiHome();

    @OneToOne
    @Owner
    @MappedBy(value="LinkRegistry")
    protected abstract LinkRegistry getLinkRegistryByChromattic();

    protected abstract void setLinkRegistryByChromattic(LinkRegistry var1);

    @Create
    protected abstract LinkRegistry createLinkRegistry();

    @OneToOne
    @Owner
    @MappedBy(value="Trash")
    protected abstract Trash getTrashByChromattic();

    protected abstract void setTrashByChromattic(Trash var1);

    @Create
    protected abstract Trash createTrash();

    @OneToOne
    @Owner
    @MappedBy(value="Preferences")
    protected abstract PreferencesImpl getPreferencesByChromattic();

    protected abstract void setPreferencesByChromattic(PreferencesImpl var1);

    @Create
    protected abstract PreferencesImpl createPreferences();
}

