/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.wysiwyg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.rendering.filter.MacroFilter;
import org.exoplatform.wiki.service.wysiwyg.MacroDescriptorTranslator;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroService;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterType;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroCategoryManager;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;

public class WikiMacroService
implements MacroService {
    private static Log log = ExoLogger.getLogger((String)"wiki:WikiMacroService");
    @Inject
    private SyntaxFactory syntaxFactory;
    @Inject
    private MacroManager macroManager;
    @Inject
    private MacroCategoryManager categoryManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private MacroDescriptorTranslator macroDescriptorTranslator;

    public org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor getMacroDescriptor(String macroId, String syntaxId) {
        return this.macroDescriptorTranslator.translate(this.getUntranslatedMacroDescriptor(macroId, syntaxId));
    }

    private org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor getUntranslatedMacroDescriptor(String macroId, String syntaxId) {
        try {
            MacroId macroIdObject = new MacroId(macroId, this.syntaxFactory.createSyntaxFromIdString(syntaxId));
            Macro macro = this.macroManager.getMacro(macroIdObject);
            MacroDescriptor descriptor = macro.getDescriptor();
            org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor contentDescriptor = null;
            if (descriptor.getContentDescriptor() != null) {
                contentDescriptor = new org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor();
                contentDescriptor.setId("content");
                contentDescriptor.setName("Content");
                contentDescriptor.setDescription(descriptor.getContentDescriptor().getDescription());
                contentDescriptor.setType(this.createMacroParameterType(StringBuffer.class));
                contentDescriptor.setMandatory(descriptor.getContentDescriptor().isMandatory());
            }
            LinkedHashMap parameterDescriptorMap = new LinkedHashMap();
            for (Map.Entry entry : descriptor.getParameterDescriptorMap().entrySet()) {
                parameterDescriptorMap.put(entry.getKey(), this.createMacroParameterDescriptor((ParameterDescriptor)entry.getValue()));
            }
            org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor result = new org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor();
            result.setId(macroIdObject.getId());
            result.setName(descriptor.getName());
            result.setDescription(descriptor.getDescription());
            result.setSupportingInlineMode(macro.supportsInlineMode());
            result.setContentDescriptor(contentDescriptor);
            result.setParameterDescriptorMap(parameterDescriptorMap);
            return result;
        }
        catch (Exception e) {
            log.error((Object)"Exception while retrieving macro descriptor.", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor createMacroParameterDescriptor(ParameterDescriptor descriptor) {
        org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor result = new org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterDescriptor();
        result.setId(descriptor.getId());
        result.setName(descriptor.getName());
        result.setDescription(descriptor.getDescription());
        result.setType(this.createMacroParameterType(descriptor.getType()));
        Object defaultValue = descriptor.getDefaultValue();
        if (defaultValue != null) {
            result.setDefaultValue(String.valueOf(defaultValue));
        }
        result.setMandatory(descriptor.isMandatory());
        return result;
    }

    private ParameterType createMacroParameterType(Class<?> parameterClass) {
        ParameterType parameterType = new ParameterType();
        parameterType.setName(parameterClass.getName());
        if (parameterClass.isEnum()) {
            ?[] parameterClassConstants = parameterClass.getEnumConstants();
            LinkedHashMap<String, String> parameterTypeConstants = new LinkedHashMap<String, String>();
            for (int i = 0; i < parameterClassConstants.length; ++i) {
                String constant = String.valueOf(parameterClassConstants[i]);
                parameterTypeConstants.put(constant, constant);
            }
            parameterType.setEnumConstants(parameterTypeConstants);
        }
        return parameterType;
    }

    public List<org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor> getMacroDescriptors(String syntaxId) {
        try {
            Syntax syntax = this.syntaxFactory.createSyntaxFromIdString(syntaxId);
            ArrayList<org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor> descriptors = new ArrayList<org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor>();
            for (String category : this.categoryManager.getMacroCategories(syntax)) {
                for (MacroId macroId : this.categoryManager.getMacroIds(category, syntax)) {
                    boolean isSupported;
                    block6: {
                        if ("table".equals(macroId.getId()) || "thead".equals(macroId.getId()) || "th".equals(macroId.getId()) || "table-row".equals(macroId.getId()) || "table-cell".equals(macroId.getId()) || "column".equals(macroId.getId())) continue;
                        isSupported = true;
                        try {
                            MacroFilter macroFilter = (MacroFilter)this.componentManager.getInstance(MacroFilter.class, syntaxId);
                            isSupported = macroFilter.isSupport(macroId.getId());
                        }
                        catch (ComponentLookupException e) {
                            if (!log.isDebugEnabled()) break block6;
                            log.debug((Object)String.format("Syntax %s doesn't have any macro filter", syntaxId));
                        }
                    }
                    if (!isSupported) continue;
                    org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor descriptor = this.getUntranslatedMacroDescriptor(macroId.getId(), syntaxId);
                    descriptor.setCategory(category);
                    descriptors.add(this.macroDescriptorTranslator.translate(descriptor));
                }
            }
            Collections.sort(descriptors, new Comparator<org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor>(){

                @Override
                public int compare(org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor alice, org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDescriptor bob) {
                    return alice.getName().compareTo(bob.getName());
                }
            });
            return descriptors;
        }
        catch (Exception e) {
            log.error((Object)String.format("Exception while retrieving the list of macro descriptors for syntax %s.", syntaxId), (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

