/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.chromattic.api.ChromatticSession;
import org.chromattic.common.IO;
import org.chromattic.core.api.ChromatticSessionImpl;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersion;
import org.exoplatform.wiki.chromattic.ext.ntdef.VersionableMixin;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.EmotionIcon;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Template;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiPreferences;
import org.exoplatform.wiki.mow.api.WikiPreferencesSyntax;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.DraftPageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.HelpPage;
import org.exoplatform.wiki.mow.core.api.wiki.JCRSearchResult;
import org.exoplatform.wiki.mow.core.api.wiki.LinkEntry;
import org.exoplatform.wiki.mow.core.api.wiki.LinkRegistry;
import org.exoplatform.wiki.mow.core.api.wiki.MovedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PreferencesImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PreferencesSyntax;
import org.exoplatform.wiki.mow.core.api.wiki.RemovedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.RenamedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.TemplateContainer;
import org.exoplatform.wiki.mow.core.api.wiki.TemplateImpl;
import org.exoplatform.wiki.mow.core.api.wiki.Trash;
import org.exoplatform.wiki.mow.core.api.wiki.UserWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WatchedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.WikiHome;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;
import org.exoplatform.wiki.mow.core.api.wiki.WikiStore;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.service.search.jcr.JCRTemplateSearchQueryBuilder;
import org.exoplatform.wiki.service.search.jcr.JCRWikiSearchQueryBuilder;
import org.exoplatform.wiki.utils.JCRUtils;
import org.exoplatform.wiki.utils.Utils;
import org.exoplatform.wiki.utils.VersionNameComparatorDesc;

public class JCRDataStorage
implements DataStorage {
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);
    private static final int MAX_EXCERPT_LENGTH = 430;
    private static final int CIRCULAR_RENAME_FLAG = 1000;
    private MOWService mowService;

    public JCRDataStorage(MOWService mowService, NodeHierarchyCreator nodeHierarchyCreator) {
        this.mowService = mowService;
    }

    @Override
    public Wiki getWikiByTypeAndOwner(String wikiType, String wikiOwner) throws WikiException {
        WikiImpl wikiImpl = this.fetchWikiImpl(wikiType, wikiOwner);
        return this.convertWikiImplToWiki(wikiImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Wiki> getWikisByType(String wikiType) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        ArrayList<Wiki> wikis = new ArrayList<Wiki>();
        try {
            Collection allWikis;
            WikiContainer wikiContainer;
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            if (wStore != null && (wikiContainer = wStore.getWikiContainer(WikiType.valueOf(wikiType.toUpperCase()))) != null && (allWikis = wikiContainer.getAllWikis()) != null) {
                for (WikiImpl wikiImpl : allWikis) {
                    wikis.add(this.convertWikiImplToWiki(wikiImpl));
                }
            }
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
        return wikis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wiki createWiki(Wiki wiki) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            Wiki createdWiki;
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            WikiContainer wikiContainer = wStore.getWikiContainer(WikiType.valueOf(wiki.getType().toUpperCase()));
            Object wikiImpl = wikiContainer.addWiki(wiki);
            ((WikiImpl)wikiImpl).getWikiHome();
            this.mowService.persist();
            Wiki wiki2 = createdWiki = this.convertWikiImplToWiki((WikiImpl)wikiImpl);
            return wiki2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page createPage(Wiki wiki, Page parentPage, Page page) throws WikiException {
        if (parentPage == null) {
            throw new IllegalArgumentException("Parent page cannot be null when creating the new page " + wiki.getType() + ":" + wiki.getOwner() + ":" + page.getName());
        }
        boolean created = this.mowService.startSynchronization();
        try {
            Page createdPage;
            WikiImpl wikiImpl = this.fetchWikiImpl(wiki.getType(), wiki.getOwner());
            PageImpl parentPageImpl = this.fetchPageImpl(parentPage);
            PageImpl pageImpl = wikiImpl.createWikiPage();
            pageImpl.setName(page.getName());
            parentPageImpl.addWikiPage(pageImpl);
            pageImpl.setOwner(page.getOwner());
            pageImpl.setPermission(JCRUtils.convertToPermissionMap(page.getPermissions()));
            pageImpl.setTitle(page.getTitle());
            String text = "";
            if (page.getContent() != null) {
                text = page.getContent();
            }
            Date now = GregorianCalendar.getInstance().getTime();
            pageImpl.setCreatedDate(now);
            pageImpl.setUpdatedDate(now);
            pageImpl.setAuthor(page.getAuthor());
            pageImpl.getContent().setText(text);
            pageImpl.setSyntax(page.getSyntax());
            pageImpl.setURL(page.getUrl());
            if (page.getActivityId() != null) {
                pageImpl.setActivityId(page.getActivityId());
            }
            try {
                pageImpl.makeVersionable();
                pageImpl.checkin();
                pageImpl.checkout();
            }
            catch (Exception e) {
                log.error((Object)("Cannot create first version of page " + wiki.getType() + ":" + wiki.getOwner() + ":" + page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
            }
            LinkRegistry linkRegistry = wikiImpl.getLinkRegistry();
            String newEntryName = this.getLinkEntryName(wiki.getType(), wiki.getOwner(), page.getName());
            String newEntryAlias = this.getLinkEntryAlias(wiki.getType(), wiki.getOwner(), page.getName());
            LinkEntry newEntry = linkRegistry.getLinkEntries().get(newEntryName);
            if (newEntry == null) {
                newEntry = linkRegistry.createLinkEntry();
                linkRegistry.getLinkEntries().put(newEntryName, newEntry);
                newEntry.setAlias(newEntryAlias);
                newEntry.setTitle(page.getTitle());
            }
            newEntry.setNewLink(newEntry);
            this.mowService.persist();
            Page page2 = createdPage = this.convertPageImplToPage(pageImpl);
            return page2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getPageOfWikiByName(String wikiType, String wikiOwner, String pageName) throws WikiException {
        PageImpl pageImpl = null;
        boolean created = this.mowService.startSynchronization();
        try {
            Page page;
            WikiImpl wiki = this.fetchWikiImpl(wikiType, wikiOwner);
            if (wiki != null) {
                if ("WikiHome".equals(pageName) || pageName == null) {
                    pageImpl = wiki.getWikiHome();
                } else {
                    String wikiHomeId;
                    page = new Page(pageName);
                    page.setWikiType(wikiType);
                    page.setWikiOwner(wikiOwner);
                    pageImpl = this.fetchPageImpl(page);
                    if (pageImpl == null && (pageImpl = wiki.getWikiHome()) != null && !(wikiHomeId = TitleResolver.getId(pageImpl.getTitle(), true)).equals(pageName)) {
                        pageImpl = null;
                    }
                }
            }
            page = null;
            if (pageImpl != null) {
                try {
                    pageImpl.migrateLegacyData();
                    pageImpl.migrateAttachmentPermission();
                }
                catch (RepositoryException | WikiException e) {
                    log.error((Object)("Cannot migrate page " + wikiType + ":" + wikiOwner + ":" + pageName + " - Cause : " + e.getMessage()), e);
                }
                page = this.convertPageImplToPage(pageImpl);
                page.setWikiId(wiki.getName());
                page.setWikiType(wiki.getType());
                page.setWikiOwner(wiki.getOwner());
            }
            Page page2 = page;
            return page2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getPageById(String id) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        ChromatticSession session = this.mowService.getSession();
        try {
            Page page;
            Page page2 = page = this.convertPageImplToPage((PageImpl)((Object)session.findById(PageImpl.class, id)));
            return page2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DraftPage getDraftPageById(String id) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        ChromatticSession session = this.mowService.getSession();
        try {
            DraftPage draftPage;
            DraftPage draftPage2 = draftPage = this.convertDraftPageImplToDraftPage((DraftPageImpl)((Object)session.findById(DraftPageImpl.class, id)));
            return draftPage2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getParentPageOf(Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            PageImpl parentPageImpl = pageImpl.getParentPage();
            Page parentPage = this.convertPageImplToPage(parentPageImpl);
            if (parentPage != null) {
                parentPage.setWikiId(page.getWikiId());
                parentPage.setWikiType(page.getWikiType());
                parentPage.setWikiOwner(page.getWikiOwner());
            }
            Page page2 = parentPage;
            return page2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Page> getChildrenPageOf(Page page) throws WikiException {
        ArrayList<Page> childrenPages = new ArrayList<Page>();
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            if (pageImpl == null) {
                throw new WikiException("Page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " does not exist, cannot get its children.");
            }
            try {
                Map<String, PageImpl> childrenPageImpls = pageImpl.getChildPages();
                for (PageImpl childPageImpl : childrenPageImpls.values()) {
                    Page childPage = this.convertPageImplToPage(childPageImpl);
                    childPage.setWikiType(page.getWikiType());
                    childPage.setWikiOwner(page.getWikiOwner());
                    childrenPages.add(childPage);
                }
            }
            catch (Exception e) {
                log.error((Object)("Cannot get children pages of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
            }
            ArrayList<Page> arrayList = childrenPages;
            return arrayList;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTemplatePage(Wiki wiki, Template template) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            TemplateContainer templatesContainer = this.getTemplatesContainer(wiki.getType(), wiki.getOwner());
            TemplateImpl templatePage = templatesContainer.createTemplatePage();
            templatePage = templatesContainer.addPage(template.getName(), templatePage);
            templatePage.setTitle(template.getTitle());
            templatePage.setDescription(template.getDescription());
            templatePage.getContent().setText(template.getContent());
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTemplatePage(Template template) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            TemplateContainer templatesContainer = this.getTemplatesContainer(template.getWikiType(), template.getWikiOwner());
            TemplateImpl templateImpl = templatesContainer.getTemplate(template.getName());
            templateImpl.setTitle(template.getTitle());
            templateImpl.setDescription(template.getDescription());
            templateImpl.getContent().setText(template.getContent());
            templateImpl.setSyntax(template.getSyntax());
            this.mowService.persist();
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTemplatePage(String wikiType, String wikiOwner, String templateName) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            TemplateContainer templatesContainer = this.getTemplatesContainer(wikiType, wikiOwner);
            TemplateImpl templateImpl = templatesContainer.getTemplate(templateName);
            templateImpl.remove();
            this.mowService.persist();
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePage(String wikiType, String wikiOwner, String pageId) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            Page page = new Page(pageId);
            page.setWikiType(wikiType);
            page.setWikiOwner(wikiOwner);
            PageImpl pageImpl = this.fetchPageImpl(page);
            if (pageImpl == null) {
                throw new WikiException("Page " + wikiType + ":" + wikiOwner + ":" + pageId + " does not exist, cannot delete it.");
            }
            ChromatticSession session = this.mowService.getSession();
            RemovedMixin mix = (RemovedMixin)session.create(RemovedMixin.class);
            session.setEmbedded((Object)pageImpl, RemovedMixin.class, (Object)mix);
            mix.setRemovedBy(Utils.getCurrentUser());
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTimeInMillis(new Date().getTime());
            mix.setRemovedDate(calendar.getTime());
            mix.setParentPath(pageImpl.getParentPage().getPath());
            WikiImpl wiki = this.fetchWikiImpl(wikiType, wikiOwner);
            Trash trash = wiki.getTrash();
            if (trash.isHasPage(pageImpl.getName())) {
                PageImpl oldDeleted = trash.getPage(pageImpl.getName());
                String removedDate = oldDeleted.getRemovedMixin().getRemovedDate().toGMTString();
                String newName = pageImpl.getName() + "_" + removedDate.replaceAll(" ", "-").replaceAll(":", "-");
                trash.addChild(newName, oldDeleted);
            }
            trash.addRemovedWikiPage(pageImpl);
            LinkRegistry linkRegistry = wiki.getLinkRegistry();
            if (linkRegistry.getLinkEntries().get(this.getLinkEntryName(wikiType, wikiOwner, pageId)) != null) {
                linkRegistry.getLinkEntries().get(this.getLinkEntryName(wikiType, wikiOwner, pageId)).setNewLink(null);
            }
            session.save();
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Template getTemplatePage(WikiPageParams params, String templateId) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            TemplateContainer templatesContainer = this.getTemplatesContainer(params.getType(), params.getOwner());
            Template template = this.convertTemplateImplToTemplate(templatesContainer.getTemplate(templateId));
            if (template != null) {
                template.setWikiType(params.getType());
                template.setWikiOwner(params.getOwner());
            }
            Template template2 = template;
            return template2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Template> getTemplates(WikiPageParams params) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            HashMap<String, Template> templates = new HashMap<String, Template>();
            Map<String, TemplateImpl> templatesImpl = this.getTemplatesContainer(params.getType(), params.getOwner()).getTemplates();
            for (String templateImplKey : templatesImpl.keySet()) {
                Template template = this.convertTemplateImplToTemplate(templatesImpl.get(templateImplKey));
                template.setWikiType(params.getType());
                template.setWikiOwner(params.getOwner());
                templates.put(templateImplKey, template);
            }
            HashMap<String, Template> hashMap = templates;
            return hashMap;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateContainer getTemplatesContainer(String wikiType, String wikiOwner) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            TemplateContainer templateContainer;
            WikiImpl wiki = this.fetchWikiImpl(wikiType, wikiOwner);
            TemplateContainer templateContainer2 = templateContainer = wiki.getPreferences().getTemplateContainer();
            return templateContainer2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteDraftOfPage(Page page, String username) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            UserWiki userWiki = (UserWiki)wStore.getWiki(WikiType.USER, username);
            if (userWiki != null) {
                PageImpl draftPagesContainer = userWiki.getDraftPagesContainer();
                try {
                    Map<String, PageImpl> childPages = draftPagesContainer.getChildPages();
                    for (PageImpl childPage : childPages.values()) {
                        String targetPageId = ((DraftPageImpl)childPage).getTargetPage();
                        if (targetPageId == null || !targetPageId.equals(page.getId())) continue;
                        childPage.remove();
                        return;
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Cannot get drafts of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
                }
            }
            if (!log.isDebugEnabled()) return;
            log.debug((Object)("No draft page of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " for user " + username + ", so nothing to delete."));
            return;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    @Override
    public void deleteDraftByName(String newDraftPageName, String username) throws WikiException {
        if (newDraftPageName == null || StringUtils.isEmpty((String)newDraftPageName)) {
            throw new IllegalArgumentException("Draft page name cannot be null or empty");
        }
        if (username == null || StringUtils.isEmpty((String)username)) {
            throw new IllegalArgumentException("Username cannot be null or empty");
        }
        boolean created = this.mowService.startSynchronization();
        WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
        UserWiki userWiki = (UserWiki)wStore.getWiki(WikiType.USER, username);
        if (userWiki == null) {
            this.mowService.stopSynchronization(created);
            throw new WikiException("Cannot delete draft page with name " + newDraftPageName + " of user " + username + " because no user wiki has been found.");
        }
        PageImpl draftPagesContainer = userWiki.getDraftPagesContainer();
        try {
            Map<String, PageImpl> childPages = draftPagesContainer.getChildPages();
            for (PageImpl childPage : childPages.values()) {
                if (!newDraftPageName.equals(childPage.getName())) continue;
                childPage.remove();
                return;
            }
        }
        catch (Exception e) {
            throw new WikiException("Cannot delete draft page of with name " + newDraftPageName + " of user " + username, e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
        throw new WikiException("Cannot delete draft page with name " + newDraftPageName + " of user " + username + " because it does not exist.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renamePage(String wikiType, String wikiOwner, String pageName, String newName, String newTitle) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            ArrayList<String> ids;
            Page page = new Page(pageName);
            page.setWikiType(wikiType);
            page.setWikiOwner(wikiOwner);
            PageImpl currentPage = this.fetchPageImpl(page);
            PageImpl parentPage = currentPage.getParentPage();
            RenamedMixin mix = currentPage.getRenamedMixin();
            if (mix == null) {
                mix = (RenamedMixin)parentPage.getChromatticSession().create(RenamedMixin.class);
                currentPage.setRenamedMixin(mix);
                ids = new ArrayList();
                ids.add(pageName);
                mix.setOldPageIds(ids.toArray(new String[0]));
            }
            ids = new ArrayList<String>();
            for (String id : mix.getOldPageIds()) {
                ids.add(id);
            }
            mix.setOldPageIds(ids.toArray(new String[0]));
            currentPage.setName(newName);
            this.mowService.persist();
            currentPage.setTitle(newTitle);
            this.mowService.persist();
            WikiImpl wiki = parentPage.getWiki();
            LinkRegistry linkRegistry = wiki.getLinkRegistry();
            String newEntryName = this.getLinkEntryName(wikiType, wikiOwner, newName);
            String newEntryAlias = this.getLinkEntryAlias(wikiType, wikiOwner, newName);
            LinkEntry newEntry = linkRegistry.getLinkEntries().get(newEntryName);
            LinkEntry entry = linkRegistry.getLinkEntries().get(this.getLinkEntryName(wikiType, wikiOwner, pageName));
            if (newEntry == null) {
                newEntry = linkRegistry.createLinkEntry();
                linkRegistry.getLinkEntries().put(newEntryName, newEntry);
                newEntry.setAlias(newEntryAlias);
                newEntry.setNewLink(newEntry);
                newEntry.setTitle(newTitle);
                if (entry != null) {
                    entry.setNewLink(newEntry);
                }
            } else if (entry == null) {
                newEntry.setNewLink(newEntry);
            } else {
                this.processCircularRename(entry, newEntry);
            }
            parentPage.getChromatticSession().save();
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void movePage(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            HashMap<String, String[]> attachmentPermission;
            Page destPage = new Page(newLocationParams.getPageName());
            destPage.setWikiType(newLocationParams.getType());
            destPage.setWikiOwner(newLocationParams.getOwner());
            PageImpl destPageImpl = this.fetchPageImpl(destPage);
            if (destPageImpl == null || !destPageImpl.hasPermission(PermissionType.EDITPAGE)) {
                throw new WikiException("Destination page " + newLocationParams.getType() + ":" + newLocationParams.getOwner() + ":" + newLocationParams.getPageName() + " does not exist");
            }
            ChromatticSession session = this.mowService.getSession();
            Page movePage = new Page(currentLocationParams.getPageName());
            destPage.setWikiType(currentLocationParams.getType());
            destPage.setWikiOwner(currentLocationParams.getOwner());
            PageImpl movePageImpl = this.fetchPageImpl(movePage);
            WikiImpl sourceWiki = movePageImpl.getWiki();
            MovedMixin mix = movePageImpl.getMovedMixin();
            if (mix == null) {
                movePageImpl.setMovedMixin((MovedMixin)session.create(MovedMixin.class));
                mix = movePageImpl.getMovedMixin();
                mix.setTargetPage(movePageImpl.getParentPage());
            }
            mix.setTargetPage(destPageImpl);
            WikiImpl destWiki = destPageImpl.getWiki();
            movePageImpl.setParentPage(destPageImpl);
            movePageImpl.setMinorEdit(false);
            Collection<AttachmentImpl> attachments = movePageImpl.getAttachmentsExcludeContentByRootPermisison();
            HashMap<String, String[]> pagePermission = movePageImpl.getPermission();
            if (!(!PortalConfig.GROUP_TYPE.equals(currentLocationParams.getType()) || currentLocationParams.getOwner().equals(newLocationParams.getOwner()) && PortalConfig.GROUP_TYPE.equals(newLocationParams.getType()))) {
                Iterator<Map.Entry<String, String[]>> pagePermissionIterator = pagePermission.entrySet().iterator();
                while (pagePermissionIterator.hasNext()) {
                    Map.Entry<String, String[]> permissionEntry = pagePermissionIterator.next();
                    if (!StringUtils.substringAfter((String)((String)permissionEntry.getKey()), (String)":").equals(currentLocationParams.getOwner())) continue;
                    pagePermissionIterator.remove();
                }
                for (AttachmentImpl attachment : attachments) {
                    attachmentPermission = attachment.getPermission();
                    Iterator<Map.Entry<String, String[]>> attachmentPermissionIterator = attachmentPermission.entrySet().iterator();
                    while (attachmentPermissionIterator.hasNext()) {
                        Map.Entry<String, String[]> permissionEntry = attachmentPermissionIterator.next();
                        if (!StringUtils.substringAfter((String)permissionEntry.getKey(), (String)":").equals(currentLocationParams.getOwner())) continue;
                        attachmentPermissionIterator.remove();
                    }
                    attachment.setPermission(attachmentPermission);
                }
            }
            HashMap<String, String[]> parentPermissions = destPageImpl.getPermission();
            pagePermission.putAll(parentPermissions);
            movePageImpl.setPermission(pagePermission);
            for (AttachmentImpl attachment : attachments) {
                attachmentPermission = attachment.getPermission();
                attachmentPermission.putAll(parentPermissions);
                attachment.setPermission(attachmentPermission);
            }
            if (!newLocationParams.getType().equals(currentLocationParams.getType()) || PortalConfig.GROUP_TYPE.equals(currentLocationParams.getType()) && !currentLocationParams.getOwner().equals(newLocationParams.getOwner())) {
                LinkRegistry sourceLinkRegistry = sourceWiki.getLinkRegistry();
                LinkRegistry destLinkRegistry = destWiki.getLinkRegistry();
                String newEntryName = this.getLinkEntryName(newLocationParams.getType(), newLocationParams.getOwner(), currentLocationParams.getPageName());
                String newEntryAlias = this.getLinkEntryAlias(newLocationParams.getType(), newLocationParams.getOwner(), currentLocationParams.getPageName());
                LinkEntry newEntry = destLinkRegistry.getLinkEntries().get(newEntryName);
                LinkEntry entry = sourceLinkRegistry.getLinkEntries().get(this.getLinkEntryName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName()));
                if (newEntry == null) {
                    newEntry = destLinkRegistry.createLinkEntry();
                    destLinkRegistry.getLinkEntries().put(newEntryName, newEntry);
                    newEntry.setAlias(newEntryAlias);
                    newEntry.setNewLink(newEntry);
                    newEntry.setTitle(destPageImpl.getTitle());
                    if (entry != null) {
                        entry.setNewLink(newEntry);
                    }
                } else if (entry == null) {
                    newEntry.setNewLink(newEntry);
                } else {
                    this.processCircularRename(entry, newEntry);
                }
            }
            session.save();
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PermissionEntry> getWikiPermission(String wikiType, String wikiOwner) throws WikiException {
        List<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        boolean created = this.mowService.startSynchronization();
        try {
            WikiImpl wikiImpl = this.fetchWikiImpl(wikiType, wikiOwner);
            if (wikiImpl == null) {
                ArrayList<PermissionEntry> arrayList = permissionEntries;
                return arrayList;
            }
            List<String> permissions = wikiImpl.getWikiPermissions();
            List<PermissionEntry> list = permissionEntries = JCRUtils.convertWikiPermissionsToPermissionEntryList(permissions);
            return list;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWikiPermission(String wikiType, String wikiOwner, List<PermissionEntry> permissionEntries) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            WikiImpl wiki = this.fetchWikiImpl(wikiType, wikiOwner);
            ArrayList<String> permissions = new ArrayList<String>();
            HashMap<String, String[]> permMap = new HashMap<String, String[]>();
            for (PermissionEntry entry : permissionEntries) {
                StringBuilder actions = new StringBuilder();
                Permission[] pers = entry.getPermissions();
                ArrayList<String> permlist = new ArrayList<String>();
                for (int i = 0; i < pers.length; ++i) {
                    Permission perm = pers[i];
                    if (!perm.isAllowed()) continue;
                    actions.append(perm.getPermissionType().toString());
                    if (i < pers.length - 1) {
                        actions.append(",");
                    }
                    if (perm.getPermissionType().equals((Object)PermissionType.VIEWPAGE)) {
                        permlist.add("read");
                        continue;
                    }
                    if (!perm.getPermissionType().equals((Object)PermissionType.EDITPAGE)) continue;
                    permlist.add("add_node");
                    permlist.add("remove");
                    permlist.add("set_property");
                }
                if (actions.toString().length() > 0) {
                    actions.append(":").append((Object)entry.getIdType()).append(":").append(entry.getId());
                    permissions.add(actions.toString());
                }
                if (permlist.size() <= 0) continue;
                permMap.put(entry.getId(), permlist.toArray(new String[permlist.size()]));
            }
            wiki.setWikiPermissions(permissions);
            this.updateAllPagesPermissions(wikiType, wikiOwner, permMap);
            this.mowService.persist();
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    @Override
    public List<Page> getRelatedPagesOfPage(Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            ArrayList<Page> relatedPages = new ArrayList<Page>();
            PageImpl pageImpl = this.fetchPageImpl(page);
            List<PageImpl> relatedPageImpls = pageImpl.getRelatedPages();
            for (PageImpl relatedPageImpl : relatedPageImpls) {
                relatedPages.add(this.convertPageImplToPage(relatedPageImpl));
            }
            ArrayList<Page> arrayList = relatedPages;
            return arrayList;
        }
        catch (RepositoryException e) {
            throw new WikiException("Cannot get related pages of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage(), e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getRelatedPage(String wikiType, String wikiOwner, String pageId) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            Page pageWithLinkEntry;
            int circularFlag;
            WikiImpl wiki = this.fetchWikiImpl(wikiType, wikiOwner);
            LinkRegistry linkRegistry = wiki.getLinkRegistry();
            LinkEntry oldLinkEntry = linkRegistry.getLinkEntries().get(this.getLinkEntryName(wikiType, wikiOwner, pageId));
            LinkEntry newLinkEntry = null;
            if (oldLinkEntry != null) {
                newLinkEntry = oldLinkEntry.getNewLink();
            }
            for (circularFlag = 1000; newLinkEntry != null && !newLinkEntry.equals(oldLinkEntry) && circularFlag > 0; --circularFlag) {
                oldLinkEntry = newLinkEntry;
                newLinkEntry = oldLinkEntry.getNewLink();
            }
            if (newLinkEntry == null) {
                Page page = null;
                return page;
            }
            if (circularFlag == 0) {
                for (circularFlag = 1000; circularFlag > 0 && this.getPageWithLinkEntry(newLinkEntry) == null; --circularFlag) {
                    newLinkEntry = newLinkEntry.getNewLink();
                }
                if (circularFlag > 0) {
                    newLinkEntry.setNewLink(newLinkEntry);
                }
            }
            Page page = pageWithLinkEntry = this.getPageWithLinkEntry(newLinkEntry);
            return page;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    @Override
    public void addRelatedPage(Page page, Page relatedPage) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            PageImpl relatedPageImpl = this.fetchPageImpl(relatedPage);
            pageImpl.addRelatedPage(relatedPageImpl);
        }
        catch (RepositoryException e) {
            throw new WikiException("Cannot add related page " + relatedPage.getWikiType() + ":" + relatedPage.getWikiOwner() + ":" + relatedPage.getName() + " for page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage(), e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    @Override
    public void removeRelatedPage(Page page, Page relatedPage) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            PageImpl relatedPageImpl = this.fetchPageImpl(relatedPage);
            pageImpl.removeRelatedPage(relatedPageImpl);
        }
        catch (RepositoryException e) {
            throw new WikiException("Cannot remove related page " + relatedPage.getWikiType() + ":" + relatedPage.getWikiOwner() + ":" + relatedPage.getName() + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage(), e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getExsitedOrNewDraftPageById(String wikiType, String wikiOwner, String pageId, String username) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            Page draftPage;
            UserWiki userWiki;
            if (IdentityConstants.ANONIM.equals(username)) {
                WikiStore wStore = this.mowService.getWikiStore();
                PageImpl draftNewPagesContainer = wStore.getDraftNewPagesContainer();
                PageImpl draftPage2 = draftNewPagesContainer.getChildPages().get(pageId);
                if (draftPage2 == null) {
                    draftPage2 = wStore.createPage();
                    draftPage2.setName(pageId);
                    draftNewPagesContainer.addPublicPage(draftPage2);
                }
                Page page = this.convertPageImplToPage(draftPage2);
                return page;
            }
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            if (username == null && pageId.contains("_A_A_")) {
                String[] texts = pageId.split("_A_A_");
                username = texts[0];
                WikiContainer userWikiContainer = wStore.getWikiContainer(WikiType.USER);
                userWiki = (UserWiki)userWikiContainer.getWiki(username);
                Collection<PageImpl> childPages = userWiki.getDraftPagesContainer().getChildrenByRootPermission().values();
                for (PageImpl pageImpl : childPages) {
                    if (!pageImpl.getName().equals(pageId)) continue;
                    Page page = this.convertPageImplToPage(pageImpl);
                    return page;
                }
            } else {
                DraftPage draftPage3;
                userWiki = (UserWiki)this.fetchWikiImpl(PortalConfig.USER_TYPE, username);
                if (userWiki == null) {
                    userWiki = (UserWiki)wStore.addWiki(WikiType.USER, username);
                }
                if ((draftPage3 = this.getDraft(pageId, username)) != null) {
                    DraftPage userWikiContainer = draftPage3;
                    return userWikiContainer;
                }
            }
            PageImpl draftPagesContainer = userWiki.getDraftPagesContainer();
            DraftPageImpl draftPageImpl = userWiki.createDraftPage();
            draftPageImpl.setName(pageId);
            draftPagesContainer.addWikiPage(draftPageImpl);
            draftPageImpl.setNewPage(true);
            draftPageImpl.setTargetPage(null);
            draftPageImpl.setTargetRevision("1");
            HashMap<String, String[]> permissions = draftPageImpl.getPermission();
            permissions.put(IdentityConstants.ANY, new String[]{"read"});
            draftPageImpl.setPermission(permissions);
            Page page = draftPage = this.convertPageImplToPage(draftPageImpl);
            return page;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DraftPage getDraft(WikiPageParams param, String username) throws WikiException {
        if (IdentityConstants.ANONIM.equals(username)) {
            return null;
        }
        if (param.getPageName() == null || param.getOwner() == null || param.getType() == null) {
            return null;
        }
        Page page = new Page(param.getPageName());
        page.setWikiType(param.getType());
        page.setWikiOwner(param.getOwner());
        PageImpl targetPage = this.fetchPageImpl(page);
        if (param.getPageName() == null || targetPage == null) {
            return null;
        }
        boolean created = this.mowService.startSynchronization();
        try {
            DraftPage draftPage;
            UserWiki userWiki = (UserWiki)this.fetchWikiImpl(PortalConfig.USER_TYPE, username);
            Collection<PageImpl> childPages = userWiki.getDraftPagesContainer().getChildPages().values();
            PageImpl lastestDraft = null;
            for (PageImpl draft : childPages) {
                DraftPageImpl draftPage2 = (DraftPageImpl)draft;
                try {
                    if (draftPage2.getTargetPage() == null || draftPage2.isNewPage() || !draftPage2.getTargetPage().equals(targetPage.getJCRPageNode().getUUID()) || lastestDraft != null && lastestDraft.getUpdatedDate().getTime() >= draftPage2.getUpdatedDate().getTime()) continue;
                    lastestDraft = draftPage2;
                }
                catch (RepositoryException e) {
                    log.error((Object)("Cannot get JCR node of page " + param.getType() + ":" + param.getOwner() + ":" + param.getPageName() + " for user " + username + " - Cause : " + e.getMessage()), (Throwable)e);
                }
            }
            DraftPage draftPage3 = draftPage = this.convertDraftPageImplToDraftPage((DraftPageImpl)lastestDraft);
            return draftPage3;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DraftPage getLastestDraft(String username) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            DraftPage draftPage;
            UserWiki userWiki = (UserWiki)this.fetchWikiImpl(PortalConfig.USER_TYPE, username);
            Collection<PageImpl> childPages = userWiki.getDraftPagesContainer().getChildPages().values();
            PageImpl lastestDraft = null;
            for (PageImpl draft : childPages) {
                DraftPageImpl draftPage2 = (DraftPageImpl)draft;
                if (lastestDraft != null && lastestDraft.getUpdatedDate().getTime() >= draftPage2.getUpdatedDate().getTime()) continue;
                lastestDraft = draftPage2;
            }
            DraftPage draftPage3 = draftPage = this.convertDraftPageImplToDraftPage((DraftPageImpl)lastestDraft);
            return draftPage3;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DraftPage getDraft(String draftName, String username) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            DraftPage page = null;
            List<DraftPage> drafts = this.getDraftPagesOfUser(username);
            for (DraftPage draftPage : drafts) {
                if (!draftPage.getName().equals(draftName)) continue;
                page = draftPage;
                break;
            }
            Iterator<DraftPage> iterator = page;
            return iterator;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DraftPage> getDraftPagesOfUser(String username) throws WikiException {
        ArrayList<DraftPage> draftPages = new ArrayList<DraftPage>();
        boolean created = this.mowService.startSynchronization();
        try {
            UserWiki userWiki = (UserWiki)this.mowService.getWikiStore().getWiki(WikiType.USER, username);
            if (userWiki != null) {
                Collection<PageImpl> childPages = userWiki.getDraftPagesContainer().getChildPages().values();
                for (PageImpl page : childPages) {
                    DraftPage draftPage = this.convertDraftPageImplToDraftPage((DraftPageImpl)page);
                    draftPage.setWikiType(userWiki.getType());
                    draftPage.setWikiOwner(userWiki.getOwner());
                    draftPages.add(draftPage);
                }
            }
            ArrayList<DraftPage> arrayList = draftPages;
            return arrayList;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDraftPageForUser(DraftPage draftPage, String username) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            WikiStore wikiStore = this.mowService.getWikiStore();
            UserWiki userWiki = (UserWiki)wikiStore.getWiki(WikiType.USER, username);
            if (userWiki == null) {
                userWiki = (UserWiki)wikiStore.addWiki(WikiType.USER, username);
            }
            PageImpl draftPagesContainer = userWiki.getDraftPagesContainer();
            DraftPageImpl draftPageImpl = userWiki.createDraftPage();
            draftPageImpl.setName(draftPage.getName());
            draftPagesContainer.addWikiPage(draftPageImpl);
            draftPageImpl.setNewPage(draftPage.isNewPage());
            draftPageImpl.setTitle(draftPage.getTitle());
            draftPageImpl.getContent().setText(draftPage.getContent());
            draftPageImpl.setTargetPage(draftPage.getTargetPageId());
            draftPageImpl.setTargetRevision(draftPage.getTargetPageRevision());
            draftPageImpl.setCreatedDate(draftPage.getCreatedDate());
            draftPageImpl.setUpdatedDate(draftPage.getUpdatedDate());
            this.mowService.persist();
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    @Override
    public PageList<SearchResult> search(WikiSearchData data) throws WikiException {
        ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
        ArrayList<JCRSearchResult> jcrResultList = new ArrayList<JCRSearchResult>();
        long numberOfSearchForTitleResult = 0L;
        boolean created = this.mowService.startSynchronization();
        try {
            ChromatticSession session = this.mowService.getSession();
            if (!StringUtils.isEmpty((String)data.getTitle())) {
                QueryResult result;
                RowIterator iter;
                String statement = new JCRWikiSearchQueryBuilder(data).getStatementForSearchingTitle();
                QueryImpl queryImpl = (QueryImpl)((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
                if (data.getOffset() > 0L) {
                    queryImpl.setOffset(data.getOffset());
                }
                if (data.getLimit() > 0) {
                    queryImpl.setLimit((long)data.getLimit());
                }
                if ((numberOfSearchForTitleResult = (iter = (result = queryImpl.execute()).getRows()).getSize()) > 0L) {
                    while (iter.hasNext()) {
                        JCRSearchResult tempResult = this.getResult(iter.nextRow(), data);
                        if (tempResult == null || this.isContains(jcrResultList, tempResult)) continue;
                        jcrResultList.add(tempResult);
                    }
                }
            }
            if (jcrResultList.size() < data.getLimit() && !StringUtils.isEmpty((String)data.getContent())) {
                long searchForContentOffset = data.getOffset();
                long searchForContentLimit = (long)data.getLimit() - numberOfSearchForTitleResult;
                if (data.getLimit() == Integer.MAX_VALUE) {
                    searchForContentLimit = Integer.MAX_VALUE;
                }
                if (searchForContentOffset >= 0L && searchForContentLimit > 0L) {
                    JCRWikiSearchQueryBuilder queryBuilder = new JCRWikiSearchQueryBuilder(data);
                    String statement = queryBuilder.getStatementForSearchingContent();
                    QueryImpl q = (QueryImpl)((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
                    q.setOffset(searchForContentOffset);
                    q.setLimit(searchForContentLimit);
                    QueryResult result = q.execute();
                    RowIterator iter = result.getRows();
                    while (iter.hasNext()) {
                        JCRSearchResult tempResult = this.getResult(iter.nextRow(), data);
                        if (tempResult == null || this.isContains(jcrResultList, tempResult) || this.isDuplicateTitle(jcrResultList, tempResult)) continue;
                        jcrResultList.add(tempResult);
                    }
                }
            }
            for (SearchResult searchResult : jcrResultList) {
                resultList.add(searchResult);
            }
            ObjectPageList objectPageList = new ObjectPageList(resultList, resultList.size());
            return objectPageList;
        }
        catch (RepositoryException e) {
            throw new WikiException("Cannot search in wiki " + data.getWikiType() + ":" + data.getWikiOwner(), e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Attachment> getAttachmentsOfPage(Page page) throws WikiException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            if (pageImpl == null) throw new WikiException("Cannot get attachments of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because the page does not exist.");
            try {
                Collection<AttachmentImpl> attachmentsExcludeContent = pageImpl.getAttachmentsExcludeContent();
                if (attachmentsExcludeContent != null) {
                    for (AttachmentImpl attachmentImpl : attachmentsExcludeContent) {
                        attachments.add(this.convertAttachmentImplToAttachment(attachmentImpl));
                    }
                }
            }
            catch (RepositoryException e) {
                throw new WikiException("Cannot get attachments of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName(), e);
            }
            ArrayList<Attachment> arrayList = attachments;
            return arrayList;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttachmentToPage(Attachment attachment, Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            AttachmentImpl attachmentImpl = pageImpl.createAttachment(attachment.getName(), new Resource(attachment.getMimeType(), "UTF-8", attachment.getContent()));
            attachmentImpl.setTitle(attachment.getTitle());
            attachmentImpl.setCreator(attachment.getCreator());
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAttachmentOfPage(String attachmentId, Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            pageImpl.removeAttachment(attachmentId);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getHelpSyntaxPage(String syntaxId, boolean fullContent, List<ValuesParam> syntaxHelpParams, ConfigurationManager configurationManager) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            Map<String, PageImpl> childPages;
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            HelpPage helpPageByChromattic = wStore.getHelpPageByChromattic();
            if (helpPageByChromattic == null || wStore.getHelpPagesContainer().getChildPages().size() == 0) {
                this.createHelpPages(syntaxHelpParams, configurationManager);
            }
            PageImpl helpPageImpl = null;
            for (PageImpl syntaxPage : wStore.getHelpPagesContainer().getChildPages().values()) {
                if (!syntaxPage.getSyntax().equals(syntaxId)) continue;
                helpPageImpl = syntaxPage;
                break;
            }
            if (helpPageImpl != null && fullContent && (childPages = helpPageImpl.getChildPages()) != null && childPages.size() > 0) {
                helpPageImpl = childPages.values().iterator().next();
            }
            Page page = this.convertPageImplToPage(helpPageImpl);
            return page;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createEmotionIcon(EmotionIcon emotionIcon) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            String mimetype;
            PageImpl emotionIconsPage;
            block5: {
                WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
                emotionIconsPage = wStore.getEmotionIconsContainer();
                try {
                    mimetype = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(emotionIcon.getImage()));
                }
                catch (IOException e) {
                    log.warn((Object)("Cannot guess mimetype from inputstream for emotion icon " + emotionIcon.getName() + " - Cause : " + e.getMessage()));
                    mimetype = URLConnection.guessContentTypeFromName(emotionIcon.getName());
                    if (mimetype != null) break block5;
                    mimetype = "image/*";
                }
            }
            AttachmentImpl emotionIconAttachment = emotionIconsPage.createAttachment(emotionIcon.getName(), new Resource(mimetype, "UTF-8", emotionIcon.getImage()));
            emotionIconsPage.addAttachment(emotionIconAttachment);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EmotionIcon> getEmotionIcons() throws WikiException {
        ArrayList<EmotionIcon> emotionIcons = null;
        boolean created = this.mowService.startSynchronization();
        try {
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            PageImpl emotionIconsPage = wStore.getEmotionIconsContainer();
            if (emotionIconsPage != null) {
                emotionIcons = new ArrayList<EmotionIcon>();
                String baseUrl = JCRUtils.getCurrentRepositoryWebDavUri();
                Collection<AttachmentImpl> emotionIconsAttachments = emotionIconsPage.getAttachments();
                for (AttachmentImpl emotionIconAttachment : emotionIconsAttachments) {
                    EmotionIcon emotionIcon = new EmotionIcon();
                    emotionIcon.setName(emotionIconAttachment.getName());
                    StringBuilder sbUrl = new StringBuilder(baseUrl).append(this.mowService.getSession().getJCRSession().getWorkspace().getName()).append(emotionIconsPage.getPath()).append("/").append(emotionIconAttachment.getName());
                    emotionIcon.setUrl(sbUrl.toString());
                    emotionIcons.add(emotionIcon);
                }
            }
            ArrayList<EmotionIcon> arrayList = emotionIcons;
            return arrayList;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmotionIcon getEmotionIconByName(String name) throws WikiException {
        EmotionIcon emotionIcon = null;
        boolean created = this.mowService.startSynchronization();
        try {
            AttachmentImpl emotionIconAttachment;
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            String baseUrl = JCRUtils.getCurrentRepositoryWebDavUri();
            PageImpl emotionIconsPage = wStore.getEmotionIconsContainer();
            if (emotionIconsPage != null && (emotionIconAttachment = emotionIconsPage.getAttachment(name)) != null) {
                emotionIcon = new EmotionIcon();
                emotionIcon.setName(name);
                StringBuilder sbUrl = new StringBuilder(baseUrl).append(this.mowService.getSession().getJCRSession().getWorkspace().getName()).append(emotionIconsPage.getPath()).append("/").append(emotionIconAttachment.getName());
                emotionIcon.setUrl(sbUrl.toString());
                emotionIcon.setImage(emotionIconAttachment.getContentResource().getData());
            }
            EmotionIcon emotionIcon2 = emotionIcon;
            return emotionIcon2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createHelpPages(List<ValuesParam> syntaxHelpParams, ConfigurationManager configurationManager) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            HelpPage helpPage = wStore.getHelpPagesContainer();
            if (helpPage.getChildPages().size() == 0) {
                for (ValuesParam syntaxhelpParam : syntaxHelpParams) {
                    try {
                        String syntaxName = syntaxhelpParam.getName();
                        List syntaxValues = syntaxhelpParam.getValues();
                        String shortFilePath = (String)syntaxValues.get(0);
                        String fullFilePath = (String)syntaxValues.get(1);
                        InputStream shortFile = configurationManager.getInputStream(shortFilePath);
                        InputStream fullFile = configurationManager.getInputStream(fullFilePath);
                        HelpPage syntaxPage = this.addSyntaxPage(wStore, helpPage, syntaxName, shortFile, " Short help Page");
                        this.addSyntaxPage(wStore, syntaxPage, syntaxName, fullFile, " Full help Page");
                        this.mowService.persist();
                    }
                    catch (Exception e) {
                        log.error((Object)("Can not create Help page " + syntaxhelpParam.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAdminSpacePermission(String wikiType, String owner, Identity user) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            boolean hasPermission;
            List<AccessControlEntry> aces = this.getAccessControls(wikiType, owner);
            AccessControlList acl = new AccessControlList(owner, aces);
            String[] permission = new String[]{PermissionType.ADMINSPACE.toString()};
            boolean bl = hasPermission = JCRUtils.hasPermission(acl, permission, user);
            return bl;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAdminPagePermission(String wikiType, String owner, Identity user) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            boolean hasPermission;
            List<AccessControlEntry> aces = this.getAccessControls(wikiType, owner);
            AccessControlList acl = new AccessControlList(owner, aces);
            String[] permission = new String[]{PermissionType.ADMINPAGE.toString()};
            boolean bl = hasPermission = JCRUtils.hasPermission(acl, permission, user);
            return bl;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPermissionOnPage(Page page, PermissionType permissionType, Identity user) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        boolean hasPermission = false;
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            if (pageImpl != null) {
                hasPermission = pageImpl.hasPermission(permissionType, user);
            } else {
                log.error((Object)("Cannot check permissions on page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page cannot be fetched"));
            }
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
        return hasPermission;
    }

    @Override
    public boolean hasPermissionOnWiki(Wiki wiki, PermissionType permissionType, Identity identity) throws WikiException {
        throw new UnsupportedOperationException("The JCR implementation must not be used anymore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AccessControlEntry> getAccessControls(String wikiType, String wikiOwner) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        ArrayList<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
        try {
            List<PermissionEntry> permissionEntries = this.getWikiPermission(wikiType, wikiOwner);
            for (PermissionEntry perm : permissionEntries) {
                Permission[] permissions = perm.getPermissions();
                ArrayList<String> actions = new ArrayList<String>();
                for (Permission permission : permissions) {
                    if (!permission.isAllowed()) continue;
                    actions.add(permission.getPermissionType().toString());
                }
                for (String action : actions) {
                    aces.add(new AccessControlEntry(perm.getId(), action));
                }
            }
        }
        catch (WikiException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"failed in method getAccessControls:", (Throwable)e);
            }
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
        return aces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PageVersion> getVersionsOfPage(Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            ArrayList<PageVersion> versions = new ArrayList<PageVersion>();
            VersionableMixin versionableMixin = pageImpl.getVersionableMixin();
            if (versionableMixin != null) {
                for (NTVersion version : versionableMixin.getVersionHistory()) {
                    if ("rootVersion".equals(version.getName())) continue;
                    try {
                        PageVersion pageVersion = new PageVersion();
                        pageVersion.setName(version.getName());
                        pageVersion.setAuthor(version.getNTFrozenNode().getAuthor());
                        pageVersion.setCreatedDate(version.getCreated());
                        pageVersion.setUpdatedDate(version.getNTFrozenNode().getUpdatedDate());
                        pageVersion.setContent(version.getNTFrozenNode().getContentString());
                        pageVersion.setComment(version.getNTFrozenNode().getComment());
                        versions.add(pageVersion);
                    }
                    catch (RepositoryException e) {
                        log.error((Object)("Cannot get version " + version.getName() + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            Collections.sort(versions, new VersionNameComparatorDesc());
            ArrayList<PageVersion> arrayList = versions;
            return arrayList;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    @Override
    public void addPageVersion(Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            if (pageImpl.getVersionableMixin() == null) {
                pageImpl.makeVersionable();
            }
            pageImpl.checkin();
            pageImpl.checkout();
        }
        catch (RepositoryException e) {
            throw new WikiException("Cannot create new version of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName(), e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreVersionOfPage(String versionName, Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            pageImpl.restore(versionName, false);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePage(Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            pageImpl.setTitle(page.getTitle());
            pageImpl.setOwner(page.getOwner());
            pageImpl.setAuthor(page.getAuthor());
            pageImpl.setSyntax(page.getSyntax());
            List<PermissionEntry> currentPermissions = JCRUtils.convertToPermissionEntryList(pageImpl.getPermission());
            if (!CollectionUtils.isEqualCollection(currentPermissions, page.getPermissions())) {
                pageImpl.setPermission(JCRUtils.convertToPermissionMap(page.getPermissions()));
                pageImpl.setOverridePermission(true);
            }
            pageImpl.setURL(page.getUrl());
            pageImpl.getContent().setText(page.getContent());
            pageImpl.setComment(page.getComment());
            pageImpl.setUpdatedDate(GregorianCalendar.getInstance().getTime());
            if (page.getActivityId() != null) {
                pageImpl.setActivityId(page.getActivityId());
            }
            this.mowService.persist();
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    @Override
    public List<String> getPreviousNamesOfPage(Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            if (pageImpl != null) {
                List<String> previousNames = new ArrayList<String>();
                RenamedMixin renamedMixin = pageImpl.getRenamedMixin();
                if (renamedMixin != null) {
                    previousNames = Arrays.asList(renamedMixin.getOldPageIds());
                }
                ArrayList<String> arrayList = previousNames;
                return arrayList;
            }
            throw new WikiException("Cannot get previous names of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because the page does not exist.");
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    @Override
    public List<String> getWatchersOfPage(Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl pageImpl = this.fetchPageImpl(page);
            if (pageImpl != null) {
                WatchedMixin watchedMixin = pageImpl.getWatchedMixin();
                List<String> watchers = watchedMixin != null ? watchedMixin.getWatchers() : Collections.EMPTY_LIST;
                List<String> list = watchers;
                return list;
            }
            throw new WikiException("Cannot get watchers of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because the page does not exist.");
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWatcherToPage(String username, Page page) throws WikiException {
        block6: {
            boolean created = this.mowService.startSynchronization();
            try {
                PageImpl pageImpl = this.fetchPageImpl(page);
                if (pageImpl != null) {
                    pageImpl.makeWatched();
                    List<String> watchers = pageImpl.getWatchedMixin().getWatchers();
                    if (watchers == null) {
                        watchers = new ArrayList<String>();
                    }
                    if (!watchers.contains(username)) {
                        watchers.add(username);
                        pageImpl.getWatchedMixin().setWatchers(watchers);
                    }
                    this.mowService.persist();
                    break block6;
                }
                throw new WikiException("Cannot add watcher " + username + " to page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because the page does not exist.");
            }
            finally {
                this.mowService.stopSynchronization(created);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWatcherOfPage(String username, Page page) throws WikiException {
        block5: {
            boolean created = this.mowService.startSynchronization();
            try {
                PageImpl pageImpl = this.fetchPageImpl(page);
                if (pageImpl != null) {
                    pageImpl.makeWatched();
                    List<String> watchers = pageImpl.getWatchedMixin().getWatchers();
                    if (watchers != null && watchers.contains(username)) {
                        watchers.remove(username);
                        pageImpl.getWatchedMixin().setWatchers(watchers);
                    }
                    this.mowService.persist();
                    break block5;
                }
                throw new WikiException("Cannot delete watcher " + username + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because the page does not exist.");
            }
            finally {
                this.mowService.stopSynchronization(created);
            }
        }
    }

    private HelpPage addSyntaxPage(WikiStoreImpl wStore, PageImpl parentPage, String name, InputStream content, String type) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        StringBuilder stringContent = new StringBuilder();
        BufferedReader bufferReader = null;
        try {
            String tempLine;
            bufferReader = new BufferedReader(new InputStreamReader(content));
            while ((tempLine = bufferReader.readLine()) != null) {
                stringContent.append(tempLine).append("\n");
            }
            HelpPage syntaxPage = wStore.createHelpPage();
            String realName = name.replace("/", "");
            syntaxPage.setName(realName + type);
            parentPage.addPublicPage(syntaxPage);
            AttachmentImpl pageContent = syntaxPage.getContent();
            syntaxPage.setTitle(realName + type);
            pageContent.setText(stringContent.toString());
            syntaxPage.setSyntax(name);
            syntaxPage.setNonePermission();
            HelpPage helpPage = syntaxPage;
            return helpPage;
        }
        catch (IOException e) {
            throw new WikiException("Cannot create help page " + type, e);
        }
        finally {
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException e) {
                    log.error((Object)("Cannot close input stream of help page " + type + " - Cause : " + e.getMessage()), (Throwable)e);
                }
            }
            if (bufferReader != null) {
                try {
                    bufferReader.close();
                }
                catch (IOException e) {
                    log.error((Object)("Cannot close buffer reader of help page " + type + " - Cause : " + e.getMessage()), (Throwable)e);
                }
            }
            this.mowService.stopSynchronization(created);
        }
    }

    private boolean isDuplicateTitle(List<JCRSearchResult> list, JCRSearchResult result) {
        for (JCRSearchResult searchResult : list) {
            if (!result.getTitle().equals(searchResult.getTitle())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllPagesPermissions(String wikiType, String wikiOwner, HashMap<String, String[]> permMap) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            WikiHome page = this.fetchWikiImpl(wikiType, wikiOwner).getWikiHome();
            LinkedList<PageImpl> queue = new LinkedList<PageImpl>();
            queue.add(page);
            while (queue.peek() != null) {
                PageImpl p = (PageImpl)((Object)queue.poll());
                if (!p.getOverridePermission()) {
                    p.setPermission(permMap);
                    p.setUpdateAttachmentMixin(null);
                }
                Iterator<PageImpl> iter = p.getChildPages().values().iterator();
                while (iter.hasNext()) {
                    queue.add(iter.next());
                }
            }
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page getPageWithLinkEntry(LinkEntry entry) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            Page page;
            String linkEntryAlias = entry.getAlias();
            String[] splits = linkEntryAlias.split("@");
            String wikiType = splits[0];
            String wikiOwner = splits[1];
            String pageId = linkEntryAlias.substring((wikiType + "@" + wikiOwner + "@").length());
            Page page2 = page = this.getPageOfWikiByName(wikiType, wikiOwner, pageId);
            return page2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    private String getLinkEntryName(String wikiType, String wikiOwner, String pageId) {
        if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
            wikiOwner = wikiOwner.replace("/", "-");
        }
        return wikiType + "@" + wikiOwner + "@" + pageId;
    }

    private String getLinkEntryAlias(String wikiType, String wikiOwner, String pageId) {
        return wikiType + "@" + wikiOwner + "@" + pageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findByPath(String path, String objectNodeType) throws WikiException {
        String relPath = path;
        if (relPath.startsWith("/")) {
            relPath = relPath.substring(1);
        }
        boolean created = this.mowService.startSynchronization();
        try {
            Object object = null;
            if ("wiki:page".equals(objectNodeType)) {
                object = this.mowService.getSession().findByPath(PageImpl.class, relPath);
            } else if ("wiki:attachment".equals(objectNodeType)) {
                object = this.mowService.getSession().findByPath(AttachmentImpl.class, relPath);
            } else if ("wiki:template".equals(objectNodeType)) {
                object = this.mowService.getSession().findByPath(Template.class, relPath);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    private JCRSearchResult getResult(Row row, WikiSearchData data) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            JCRSearchResult jCRSearchResult;
            PageImpl page;
            String type = row.getValue("jcr:primaryType").getString();
            String path = row.getValue("jcr:path").getString();
            JCRSearchResult result = new JCRSearchResult();
            long score = row.getValue("jcr:score").getLong();
            Calendar createdDate = GregorianCalendar.getInstance();
            Calendar updatedDate = GregorianCalendar.getInstance();
            if ("wiki:attachment".equals(type) || "nt:resource".equals(type)) {
                result.setType(SearchResultType.ATTACHMENT);
                if (!path.endsWith("content")) {
                    result.setType(SearchResultType.PAGE_CONTENT);
                    AttachmentImpl searchAtt = (AttachmentImpl)this.findByPath(path, "wiki:attachment");
                    updatedDate = searchAtt.getUpdatedDate();
                    page = searchAtt.getParentPage();
                    createdDate.setTime(page.getCreatedDate());
                    result.setAttachmentName(searchAtt.getName());
                } else {
                    result.setType(SearchResultType.ATTACHMENT);
                    String pagePath = path.substring(0, path.lastIndexOf("/content"));
                    result.setType(SearchResultType.PAGE_CONTENT);
                    page = (PageImpl)((Object)this.findByPath(pagePath, "wiki:page"));
                    updatedDate.setTime(page.getUpdatedDate());
                    createdDate.setTime(page.getCreatedDate());
                }
            } else if ("wiki:page".equals(type)) {
                result.setType(SearchResultType.PAGE);
                page = (PageImpl)((Object)this.findByPath(path, type));
                updatedDate.setTime(page.getUpdatedDate());
                createdDate.setTime(page.getCreatedDate());
            } else {
                JCRSearchResult jCRSearchResult2 = null;
                return jCRSearchResult2;
            }
            if (page == null || !page.hasPermission(PermissionType.VIEWPAGE)) {
                jCRSearchResult = null;
                return jCRSearchResult;
            }
            result.setWikiType(page.getWiki().getType());
            result.setWikiOwner(page.getWiki().getOwner());
            result.setPageName(page.getName());
            result.setTitle(page.getTitle());
            result.setPath(path);
            result.setCreatedDate(createdDate);
            result.setUpdatedDate(updatedDate);
            result.setUrl(page.getURL());
            result.setScore(score);
            result.setExcerpt(this.getExcerpt(row, type));
            jCRSearchResult = result;
            return jCRSearchResult;
        }
        catch (RepositoryException e) {
            throw new WikiException("Cannot get search result", e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCircularRename(LinkEntry entry, LinkEntry newEntry) {
        boolean created = this.mowService.startSynchronization();
        try {
            int circularFlag;
            boolean isCircular = true;
            LinkEntry checkEntry = newEntry;
            for (circularFlag = 1000; !checkEntry.equals(entry) && circularFlag > 0; --circularFlag) {
                if ((checkEntry = checkEntry.getNewLink()) != null && (!checkEntry.equals(checkEntry.getNewLink()) || checkEntry.equals(entry))) continue;
                isCircular = false;
                break;
            }
            if (!isCircular || circularFlag == 0) {
                entry.setNewLink(newEntry);
            } else {
                LinkEntry nextEntry = newEntry.getNewLink();
                while (!nextEntry.equals(newEntry)) {
                    LinkEntry deletedEntry = nextEntry;
                    if (!(nextEntry = nextEntry.getNewLink()).equals(deletedEntry)) {
                        deletedEntry.remove();
                        continue;
                    }
                    deletedEntry.remove();
                    break;
                }
            }
            newEntry.setNewLink(newEntry);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExcerpt(Row row, String type) throws RepositoryException {
        boolean created = this.mowService.startSynchronization();
        try {
            String[] properties;
            String[] stringArray;
            StringBuilder ret = new StringBuilder();
            if ("wiki:content".equals(type) || "wiki:attachment".equals(type)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ".";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "title";
                stringArray = stringArray3;
                stringArray3[1] = "url";
            }
            for (String prop : properties = stringArray) {
                Value excerptValue = row.getValue("rep:excerpt(" + prop + ")");
                if (excerptValue == null) continue;
                ret.append(excerptValue.getString()).append("...");
            }
            if (ret.length() > 430) {
                String string = ret.substring(0, 430) + "...";
                return string;
            }
            String string = ret.toString();
            return string;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResult getResult(Node node) throws RepositoryException, IOException {
        boolean created = this.mowService.startSynchronization();
        try {
            SearchResult result = new SearchResult();
            result.setPageName(node.getName());
            String title = node.getProperty("title").getString();
            InputStream data = node.getNode("content").getNode("jcr:content").getProperty("jcr:data").getStream();
            byte[] bytes = IO.getBytes((InputStream)data);
            String content = new String(bytes, "UTF-8");
            if (content.length() > 100) {
                content = content.substring(0, 100) + "...";
            }
            result.setExcerpt(content);
            result.setTitle(title);
            SearchResult searchResult = result;
            return searchResult;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isContains(List<JCRSearchResult> list, JCRSearchResult result) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            boolean contains = false;
            AttachmentImpl att = null;
            PageImpl page = null;
            if ("wiki:attachment".equals((Object)result.getType())) {
                att = (AttachmentImpl)this.findByPath(result.getPath(), "wiki:attachment");
            } else if ("nt:resource".equals((Object)result.getType())) {
                String attPath = result.getPath().substring(0, result.getPath().lastIndexOf("/"));
                att = (AttachmentImpl)this.findByPath(attPath, "wiki:attachment");
            } else if ("wiki:page".equals((Object)result.getType()) || "exo:wikihome".equals((Object)result.getType())) {
                page = (PageImpl)((Object)this.findByPath(result.getPath(), "wiki:page"));
            } else if ("wiki:content".equals((Object)result.getType())) {
                att = (AttachmentImpl)this.findByPath(result.getPath(), "wiki:attachment");
                page = att.getParentPage();
            }
            if (att != null || page != null) {
                Iterator<JCRSearchResult> iter = list.iterator();
                while (iter.hasNext()) {
                    JCRSearchResult child = iter.next();
                    if ("wiki:attachment".equals((Object)child.getType()) || "wiki:content".equals((Object)child.getType())) {
                        AttachmentImpl tempAtt = (AttachmentImpl)this.findByPath(child.getPath(), "wiki:attachment");
                        if (att != null && att.equals(tempAtt)) {
                            if (child.getExcerpt() == null && result.getExcerpt() != null) {
                                child.setExcerpt(result.getExcerpt());
                            }
                            contains = true;
                        }
                        if (page == null || !page.getName().equals((Object)tempAtt.getParentPage())) continue;
                        contains = true;
                        continue;
                    }
                    if (!"wiki:page".equals((Object)child.getType()) || page == null || !page.getPath().equals(child.getPath())) continue;
                    iter.remove();
                    contains = false;
                }
            }
            boolean bl = contains;
            return bl;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    @Override
    public List<TemplateSearchResult> searchTemplate(TemplateSearchData data) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            ChromatticSession session = this.mowService.getSession();
            ArrayList<TemplateSearchResult> resultList = new ArrayList<TemplateSearchResult>();
            String statement = new JCRTemplateSearchQueryBuilder(data).getStatementForSearchingTitle();
            Query q = ((ChromatticSessionImpl)session).getDomainSession().getSessionWrapper().createQuery(statement);
            QueryResult result = q.execute();
            RowIterator iter = result.getRows();
            while (iter.hasNext()) {
                TemplateSearchResult tempResult = this.getTemplateResult(iter.nextRow(), data);
                resultList.add(tempResult);
            }
            ArrayList<TemplateSearchResult> arrayList = resultList;
            return arrayList;
        }
        catch (RepositoryException e) {
            throw new WikiException("Cannot search templates in wiki " + data.getWikiType() + ":" + data.getWikiOwner(), e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    private TemplateSearchResult getTemplateResult(Row row, TemplateSearchData data) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            TemplateSearchResult result;
            String path = row.getValue("jcr:path").getString();
            String title = row.getValue("title") == null ? null : row.getValue("title").getString();
            TemplateImpl templateImpl = (TemplateImpl)((Object)this.findByPath(path, "wiki:page"));
            String description = templateImpl.getDescription();
            TemplateSearchResult templateSearchResult = result = new TemplateSearchResult(data.getWikiType(), data.getWikiOwner(), templateImpl.getName(), title, SearchResultType.TEMPLATE, null, null, description);
            return templateSearchResult;
        }
        catch (RepositoryException e) {
            throw new WikiException("Cannot get template", e);
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WikiImpl fetchWikiImpl(String wikiType, String wikiOwner) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            WikiStoreImpl wStore = (WikiStoreImpl)this.mowService.getWikiStore();
            WikiImpl wiki = null;
            if (PortalConfig.PORTAL_TYPE.equals(wikiType)) {
                WikiContainer portalWikiContainer = wStore.getWikiContainer(WikiType.PORTAL);
                wiki = (WikiImpl)portalWikiContainer.getWiki(wikiOwner);
            } else if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
                WikiContainer groupWikiContainer = wStore.getWikiContainer(WikiType.GROUP);
                wiki = (WikiImpl)groupWikiContainer.getWiki(wikiOwner);
            } else if (PortalConfig.USER_TYPE.equals(wikiType)) {
                WikiContainer userWikiContainer = wStore.getWikiContainer(WikiType.USER);
                wiki = (WikiImpl)userWikiContainer.getWiki(wikiOwner);
            }
            WikiImpl wikiImpl = wiki;
            return wikiImpl;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageImpl fetchPageImpl(Page page) throws WikiException {
        boolean created = this.mowService.startSynchronization();
        try {
            PageImpl wikiPage = null;
            ChromatticSession session = this.mowService.getSession();
            if (page.getId() != null && !StringUtils.isEmpty((String)page.getId())) {
                wikiPage = (PageImpl)((Object)session.findById(PageImpl.class, page.getId()));
            } else if ("WikiHome".equals(page.getName())) {
                WikiImpl wikiImpl = this.fetchWikiImpl(page.getWikiType(), page.getWikiOwner());
                wikiPage = wikiImpl.getWikiHome();
            } else {
                org.chromattic.api.query.QueryResult result;
                WikiSearchData searchData = new WikiSearchData(page.getWikiType(), page.getWikiOwner(), Text.escapeIllegalJcrChars((String)page.getName()));
                JCRWikiSearchQueryBuilder queryBuilder = new JCRWikiSearchQueryBuilder(searchData);
                String statement = queryBuilder.getPageConstraint();
                if (statement != null && (result = session.createQueryBuilder(PageImpl.class).where(statement).get().objects()).hasNext()) {
                    wikiPage = (PageImpl)((Object)result.next());
                }
                if (wikiPage != null) {
                    String path = wikiPage.getPath();
                    if (path.startsWith("/")) {
                        path = path.substring(1, path.length());
                    }
                    wikiPage = (PageImpl)((Object)session.findByPath(PageImpl.class, path));
                }
                if (wikiPage != null) {
                    // empty if block
                }
            }
            PageImpl pageImpl = wikiPage;
            return pageImpl;
        }
        finally {
            this.mowService.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Wiki convertWikiImplToWiki(WikiImpl wikiImpl) throws WikiException {
        Wiki wiki = null;
        if (wikiImpl != null) {
            boolean created = this.mowService.startSynchronization();
            try {
                wiki = new Wiki();
                wiki.setId(wikiImpl.getName());
                wiki.setType(wikiImpl.getType());
                wiki.setOwner(wikiImpl.getOwner());
                Page wikiHome = this.convertPageImplToPage(wikiImpl.getWikiHome());
                wikiHome.setWikiId(wikiImpl.getName());
                wikiHome.setWikiType(wikiImpl.getType());
                wikiHome.setWikiOwner(wikiImpl.getOwner());
                wiki.setWikiHome(wikiHome);
                wiki.setPermissions(JCRUtils.convertWikiPermissionsToPermissionEntryList(wikiImpl.getWikiPermissions()));
                wiki.setDefaultPermissionsInited(wikiImpl.getDefaultPermissionsInited());
                PreferencesImpl preferencesImpl = wikiImpl.getPreferences();
                if (preferencesImpl != null) {
                    WikiPreferencesSyntax wikiPreferencesSyntax = new WikiPreferencesSyntax();
                    PreferencesSyntax preferencesSyntax = preferencesImpl.getPreferencesSyntax();
                    if (preferencesSyntax != null) {
                        wikiPreferencesSyntax.setDefaultSyntax(preferencesSyntax.getDefaultSyntax());
                        wikiPreferencesSyntax.setAllowMultipleSyntaxes(preferencesSyntax.getAllowMutipleSyntaxes());
                    }
                    WikiPreferences wikiPreferences = new WikiPreferences();
                    wikiPreferences.setPath(preferencesImpl.getPath());
                    wikiPreferences.setWikiPreferencesSyntax(wikiPreferencesSyntax);
                    wiki.setPreferences(wikiPreferences);
                }
            }
            finally {
                this.mowService.stopSynchronization(created);
            }
        }
        return wiki;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page convertPageImplToPage(PageImpl pageImpl) throws WikiException {
        Page page = null;
        if (pageImpl != null) {
            boolean created = this.mowService.startSynchronization();
            try {
                page = new Page();
                try {
                    page.setId(pageImpl.getID());
                }
                catch (RepositoryException e) {
                    throw new WikiException("Cannot get page id", e);
                }
                WikiImpl wiki = pageImpl.getWiki();
                if (wiki != null) {
                    page.setWikiId(wiki.getName());
                    page.setWikiType(wiki.getWikiType().toString().toLowerCase());
                    page.setWikiOwner(wiki.getOwner());
                }
                page.setOwner(pageImpl.getOwner());
                page.setName(pageImpl.getName());
                page.setTitle(pageImpl.getTitle());
                page.setAuthor(pageImpl.getAuthor());
                page.setUrl(pageImpl.getURL());
                page.setCreatedDate(pageImpl.getCreatedDate());
                page.setUpdatedDate(pageImpl.getUpdatedDate());
                page.setComment(pageImpl.getComment());
                page.setContent(pageImpl.getContent().getText());
                page.setSyntax(pageImpl.getSyntax());
                page.setPermissions(JCRUtils.convertToPermissionEntryList(pageImpl.getPermission()));
                page.setActivityId(pageImpl.getActivityId());
            }
            finally {
                this.mowService.stopSynchronization(created);
            }
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DraftPage convertDraftPageImplToDraftPage(DraftPageImpl draftPageImpl) throws WikiException {
        DraftPage draftPage = null;
        if (draftPageImpl != null) {
            boolean created = this.mowService.startSynchronization();
            try {
                draftPage = new DraftPage();
                try {
                    draftPage.setId(draftPageImpl.getID());
                }
                catch (RepositoryException e) {
                    throw new WikiException("Cannot get draft page id", e);
                }
                draftPage.setOwner(draftPageImpl.getOwner());
                draftPage.setName(draftPageImpl.getName());
                draftPage.setAuthor(draftPageImpl.getAuthor());
                draftPage.setTitle(draftPageImpl.getTitle());
                draftPage.setUrl(draftPageImpl.getURL());
                draftPage.setCreatedDate(draftPageImpl.getCreatedDate());
                draftPage.setUpdatedDate(draftPageImpl.getUpdatedDate());
                draftPage.setComment(draftPageImpl.getComment());
                draftPage.setContent(draftPageImpl.getContent().getText());
                draftPage.setSyntax(draftPageImpl.getSyntax());
                draftPage.setPermissions(JCRUtils.convertToPermissionEntryList(draftPageImpl.getPermission()));
                draftPage.setTargetPageId(draftPageImpl.getTargetPage());
                draftPage.setTargetPageRevision(draftPageImpl.getTargetRevision());
                draftPage.setNewPage(draftPageImpl.isNewPage());
            }
            finally {
                this.mowService.stopSynchronization(created);
            }
        }
        return draftPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attachment convertAttachmentImplToAttachment(AttachmentImpl attachmentImpl) throws WikiException {
        Attachment attachment = null;
        if (attachmentImpl != null) {
            boolean created = this.mowService.startSynchronization();
            try {
                attachment = new Attachment();
                attachment.setName(attachmentImpl.getName());
                attachment.setTitle(attachmentImpl.getTitle());
                attachment.setFullTitle(attachmentImpl.getFullTitle());
                attachment.setCreator(attachmentImpl.getCreator());
                attachment.setCreatedDate(attachmentImpl.getCreatedDate());
                attachment.setUpdatedDate(attachmentImpl.getUpdatedDate());
                attachment.setContent(attachmentImpl.getContentResource().getData());
                attachment.setMimeType(attachmentImpl.getContentResource().getMimeType());
                attachment.setPermissions(JCRUtils.convertToPermissionEntryList(attachmentImpl.getPermission()));
                attachment.setDownloadURL(attachmentImpl.getDownloadURL());
                attachment.setWeightInBytes(attachmentImpl.getWeightInBytes());
            }
            finally {
                this.mowService.stopSynchronization(created);
            }
        }
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template convertTemplateImplToTemplate(TemplateImpl templateImpl) throws WikiException {
        Template template = null;
        if (templateImpl != null) {
            boolean created = this.mowService.startSynchronization();
            try {
                template = new Template();
                template.setName(templateImpl.getName());
                template.setTitle(templateImpl.getTitle());
                template.setDescription(templateImpl.getDescription());
                template.setContent(templateImpl.getContent().getText());
            }
            finally {
                this.mowService.stopSynchronization(created);
            }
        }
        return template;
    }

    @Override
    public List<Page> getPagesOfWiki(String wikiType, String wikiOwner) {
        throw new UnsupportedOperationException();
    }
}

