/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.chromattic.api.NoSuchNodeException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.service.search.SearchData;
import org.exoplatform.wiki.utils.JCRUtils;

public class JCRTemplateSearchQueryBuilder {
    private Log log = ExoLogger.getLogger(JCRTemplateSearchQueryBuilder.class);
    public static final String ALL_PATH = "%/";
    protected static String PORTAL_PATH = "/exo:applications/eXoWiki/wikis/%/";
    protected static String GROUP_PATH = "/Groups/%/ApplicationData/eXoWiki/";
    protected String USER_PATH = "/Users/%/ApplicationData/eXoWiki/";
    public static String TEMPLATE_PATH = "Preferences/TemplateContainer/%";
    public static String ALL_TEMPLATESPATH = "%/" + TEMPLATE_PATH;
    public static String PORTAL_TEMPLATESPATH = PORTAL_PATH + TEMPLATE_PATH;
    public static String GROUP_TEMPLATESPATH = GROUP_PATH + TEMPLATE_PATH;
    private SearchData searchData;
    private String nodeType = null;
    protected List<String> propertyConstraints = new ArrayList<String>();

    public JCRTemplateSearchQueryBuilder(SearchData searchData) {
        this.searchData = searchData;
        if (PortalConfig.USER_TYPE.equals(searchData.getWikiType())) {
            NodeHierarchyCreator nodeHierachyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            try {
                if (searchData.getWikiOwner() != null && searchData.getWikiOwner().length() > 0) {
                    Node userNode = nodeHierachyCreator.getUserApplicationNode(JCRUtils.createSystemProvider(), searchData.getWikiOwner());
                    this.USER_PATH = userNode.getPath() + "/" + "eXoWiki" + "/";
                }
            }
            catch (Exception e) {
                if (e instanceof PathNotFoundException) {
                    throw new NoSuchNodeException((Throwable)e);
                }
                throw new UndeclaredRepositoryException(e.getMessage());
            }
        }
        this.propertyConstraints = new ArrayList<String>();
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public List<String> getPropertyConstraints() {
        return new ArrayList<String>(this.propertyConstraints);
    }

    public void addPropertyConstraints(List<String> value) {
        if (value != null) {
            this.propertyConstraints.addAll(value);
        }
    }

    public void addPropertyConstraint(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.propertyConstraints.add(value);
        }
    }

    public String createJcrQueryPath() {
        String jcrQueryPath = "";
        if (this.searchData.getWikiType() == null && this.searchData.getWikiOwner() == null) {
            jcrQueryPath = "jcr:path LIKE '" + ALL_TEMPLATESPATH + "'";
        }
        if (this.searchData.getWikiType() != null) {
            if (this.searchData.getWikiType().equals(PortalConfig.USER_TYPE)) {
                jcrQueryPath = "jcr:path LIKE '" + this.USER_PATH + TEMPLATE_PATH + "'";
            } else {
                if (this.searchData.getWikiType().equals(PortalConfig.PORTAL_TYPE)) {
                    jcrQueryPath = "jcr:path LIKE '" + PORTAL_TEMPLATESPATH + "'";
                } else if (this.searchData.getWikiType().equals(PortalConfig.GROUP_TYPE)) {
                    jcrQueryPath = "jcr:path LIKE '" + GROUP_TEMPLATESPATH + "'";
                }
                if (this.searchData.getWikiOwner() != null) {
                    jcrQueryPath = jcrQueryPath.replaceFirst("%", this.searchData.getWikiOwner());
                }
            }
        }
        return jcrQueryPath;
    }

    public String getStatementForSearchingTitle() {
        StringBuilder statement = new StringBuilder();
        try {
            String title = this.searchData.getTitle();
            statement.append("SELECT title, jcr:primaryType, path,description").append(" FROM ").append("wiki:page").append(" WHERE ");
            statement.append(this.createJcrQueryPath());
            if (title != null && title.length() > 0) {
                statement.append(" AND ").append(" CONTAINS(title, '").append(title).append("') ");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to get statement ", (Throwable)e);
        }
        return statement.toString();
    }
}

