/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.wiki.GroupWikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.HelpPage;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PortalWikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.UserWikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;
import org.exoplatform.wiki.mow.core.api.wiki.WikiStore;

@PrimaryType(name="wiki:store")
public abstract class WikiStoreImpl
implements WikiStore {
    private MOWService mowService;

    public void setMOWService(MOWService mowService) {
        this.mowService = mowService;
    }

    @Override
    public WikiImpl addWiki(WikiType wikiType, String name) throws WikiException {
        return this.getWikiContainer(wikiType).addWiki(new Wiki(wikiType.toString(), name));
    }

    @Override
    public WikiImpl getWiki(WikiType wikiType, String name) {
        return this.getWikiContainer(wikiType).getWiki(name);
    }

    @Override
    public Collection<WikiImpl> getWikis() {
        CopyOnWriteArraySet<WikiImpl> col = new CopyOnWriteArraySet<WikiImpl>();
        col.addAll(this.getPortalWikiContainer().getAllWikis());
        col.addAll(this.getGroupWikiContainer().getAllWikis());
        col.addAll(this.getUserWikiContainer().getAllWikis());
        return col;
    }

    @Override
    public <W extends WikiImpl> WikiContainer<W> getWikiContainer(WikiType wikiType) {
        WikiContainer wikiContainer;
        boolean created = this.mowService.startSynchronization();
        if (wikiType == WikiType.PORTAL) {
            wikiContainer = this.getPortalWikiContainer();
        } else if (wikiType == WikiType.GROUP) {
            wikiContainer = this.getGroupWikiContainer();
        } else if (wikiType == WikiType.USER) {
            wikiContainer = this.getUserWikiContainer();
        } else {
            throw new UnsupportedOperationException();
        }
        this.mowService.stopSynchronization(created);
        return wikiContainer;
    }

    @Override
    @Create
    public abstract PageImpl createPage();

    @Create
    public abstract HelpPage createHelpPage();

    public HelpPage getHelpPagesContainer() {
        boolean created = this.mowService.startSynchronization();
        HelpPage page = this.getHelpPageByChromattic();
        if (page == null) {
            page = this.createHelpPage();
            this.setHelpPageByChromattic(page);
        }
        this.mowService.stopSynchronization(created);
        return page;
    }

    @Override
    public PageImpl getDraftNewPagesContainer() {
        boolean created = this.mowService.startSynchronization();
        PageImpl page = this.getDraftNewPagesContainerByChromattic();
        if (page == null) {
            page = this.createPage();
            this.setDraftNewPagesContainerByChromattic(page);
        }
        this.mowService.stopSynchronization(created);
        return page;
    }

    public PageImpl getEmotionIconsContainer() {
        boolean created = this.mowService.startSynchronization();
        PageImpl page = this.getEmotionIconsPageByChromattic();
        if (page == null) {
            page = this.createEmotionIconsPage();
            this.setEmotionIconsPageByChromattic(page);
        }
        this.mowService.stopSynchronization(created);
        return page;
    }

    @OneToOne
    @Owner
    @MappedBy(value="EmotionIconsPage")
    protected abstract PageImpl getEmotionIconsPageByChromattic();

    protected abstract void setEmotionIconsPageByChromattic(PageImpl var1);

    @Create
    protected abstract PageImpl createEmotionIconsPage();

    @OneToOne
    @Owner
    @MappedBy(value="portalwikis")
    protected abstract PortalWikiContainer getPortalWikiContainerByChromattic();

    protected abstract void setPortalWikiContainerByChromattic(PortalWikiContainer var1);

    @Create
    protected abstract PortalWikiContainer createPortalWikiContainer();

    @OneToOne
    @Owner
    @MappedBy(value="groupwikis")
    protected abstract GroupWikiContainer getGroupWikiContainerByChromattic();

    protected abstract void setGroupWikiContainerByChromattic(GroupWikiContainer var1);

    @Create
    protected abstract GroupWikiContainer createGroupWikiContainer();

    @OneToOne
    @Owner
    @MappedBy(value="userwikis")
    protected abstract UserWikiContainer getUserWikiContainerByChromattic();

    protected abstract void setUserWikiContainerByChromattic(UserWikiContainer var1);

    @Create
    protected abstract UserWikiContainer createUserWikiContainer();

    @OneToOne
    @Owner
    @MappedBy(value="helppages")
    public abstract HelpPage getHelpPageByChromattic();

    protected abstract void setHelpPageByChromattic(HelpPage var1);

    @OneToOne
    @Owner
    @MappedBy(value="draftNewPages")
    protected abstract PageImpl getDraftNewPagesContainerByChromattic();

    protected abstract void setDraftNewPagesContainerByChromattic(PageImpl var1);

    private PortalWikiContainer getPortalWikiContainer() {
        boolean created = this.mowService.startSynchronization();
        PortalWikiContainer portalWikiContainer = this.getPortalWikiContainerByChromattic();
        if (portalWikiContainer == null) {
            portalWikiContainer = this.createPortalWikiContainer();
            this.setPortalWikiContainerByChromattic(portalWikiContainer);
            this.mowService.persist();
        }
        this.mowService.stopSynchronization(created);
        return portalWikiContainer;
    }

    private GroupWikiContainer getGroupWikiContainer() {
        GroupWikiContainer groupWikiContainer = this.getGroupWikiContainerByChromattic();
        if (groupWikiContainer == null) {
            groupWikiContainer = this.createGroupWikiContainer();
            this.setGroupWikiContainerByChromattic(groupWikiContainer);
            this.mowService.persist();
        }
        return groupWikiContainer;
    }

    private UserWikiContainer getUserWikiContainer() {
        UserWikiContainer userWikiContainer = this.getUserWikiContainerByChromattic();
        if (userWikiContainer == null) {
            userWikiContainer = this.createUserWikiContainer();
            this.setUserWikiContainerByChromattic(userWikiContainer);
            this.mowService.persist();
        }
        return userWikiContainer;
    }
}

