/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.notification.listener;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.notification.Utils.NotificationsUtils;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;

public class EditWikiListener
extends Listener<WikiService, Page> {
    private static final Log LOG = ExoLogger.getLogger(EditWikiListener.class);

    public void onEvent(Event<WikiService, Page> event) {
        WikiService wikiService = (WikiService)event.getSource();
        Page page = (Page)event.getData();
        NotificationContext ctx = this.buildContext(wikiService, page);
        this.dispatch(ctx, "EditWikiNotificationPlugin");
    }

    private NotificationContext buildContext(WikiService wikiService, Page page) {
        String creatorId = Utils.getCurrentUser();
        String changes = null;
        try {
            changes = Utils.getWikiOnChangeContent(page);
        }
        catch (WikiException | DifferentiationFailedException e) {
            LOG.error((Object)("Cannot send notification email on page change - Cause : " + e.getMessage()), e);
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationsUtils.PAGE, (Object)page).append(NotificationsUtils.WIKI_URL, (Object)page.getUrl()).append(NotificationsUtils.WIKI_PAGE_NAME, (Object)page.getTitle()).append(NotificationsUtils.WIKI_EDITOR, (Object)Utils.getIdentityUser(creatorId)).append(NotificationsUtils.CONTENT_CHANGE, (Object)changes);
        HashSet<String> receivers = new HashSet<String>();
        try {
            List<String> watchers = wikiService.getWatchersOfPage(page);
            if (watchers != null && watchers.size() > 0) {
                for (String watcher : watchers) {
                    receivers.add(watcher);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Cannot have list of watchers for wiki page {} ", new Object[]{page.getName(), e});
        }
        receivers.remove(creatorId);
        ctx.append(NotificationsUtils.WATCHERS, receivers);
        return ctx;
    }

    private void dispatch(NotificationContext ctx, String ... pluginId) {
        ArrayList<NotificationCommand> commands = new ArrayList<NotificationCommand>(pluginId.length);
        for (String p : pluginId) {
            commands.add(ctx.makeCommand(PluginKey.key((String)p)));
        }
        ctx.getNotificationExecutor().with(commands).execute(ctx);
    }
}

