/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.utils.Utils;

public class WikiSpaceAccessLifecycle
extends BaseComponentPlugin
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final String WIKI_PORTLET_NAME = "wiki";
    private static final Log LOG = ExoLogger.getLogger((String)WikiSpaceAccessLifecycle.class.toString());

    public void onInit(Application app) {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        String siteName = pcontext.getSiteName();
        try {
            if (pcontext.getSiteType().equals((Object)SiteType.GROUP) && siteName.startsWith("/spaces") && requestPath != null && requestPath.length() > 0) {
                String currentUser = Utils.getCurrentUser();
                String[] params = requestPath.split("/");
                if (params.length > 1 && params[1].equals(WIKI_PORTLET_NAME)) {
                    SpaceService spaceService;
                    Space space;
                    String spaceId = params[0];
                    String owner = siteName;
                    String pageId = "WikiHome";
                    if (params.length > 2) {
                        pageId = params[2];
                    }
                    if ((space = (spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class)).getSpaceById(spaceId)) == null && (space = spaceService.getSpaceByPrettyName(spaceId)) == null) {
                        space = spaceService.getSpaceByGroupId(spaceId);
                    }
                    if (!(space == null || "hidden".equals(space.getVisibility()) || spaceService.isSuperManager(currentUser) || spaceService.isMember(space, currentUser))) {
                        WikiPageParams wikiPageParams = new WikiPageParams(PortalConfig.GROUP_TYPE, owner, pageId);
                        String permalink = Utils.getPermanlink(wikiPageParams, false);
                        WikiSpaceAccessLifecycle.redirect(permalink);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)String.format("Can not process url for request: site name = [%s], request path = [%s]", siteName, requestPath), (Throwable)ex);
        }
    }

    private static void redirect(String url) throws Exception {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        portalRequestContext.sendRedirect(url);
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) {
    }
}

