/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.upgrade;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RemoveSandboxPageUpgradePlugin
extends UpgradeProductPlugin {
    private static final String SANDBOX_PATH = "/Groups/sandbox";
    private static Log LOG = ExoLogger.getLogger((String)RemoveSandboxPageUpgradePlugin.class.getName());
    private RepositoryService repositoryService;

    public RemoveSandboxPageUpgradePlugin(RepositoryService repositoryService, InitParams initParams) {
        super(initParams);
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Start RemoveSandboxPageUpgradePlugin starting ...");
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
            Session systemSession = sessionProvider.getSession(currentRepository.getConfiguration().getDefaultWorkspaceName(), currentRepository);
            try {
                Node sandBoxGroup = (Node)systemSession.getItem(SANDBOX_PATH);
                sandBoxGroup.remove();
                systemSession.save();
            }
            catch (PathNotFoundException e) {
                LOG.info((Object)"SandBox Group does not exist...");
            }
            LOG.info((Object)"Finish RemoveSandboxPageUpgradePlugin ...");
        }
        catch (Exception e) {
            LOG.error((Object)"RemoveSandboxPageUpgradePlugin fail: ", (Throwable)e);
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

