/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.Permission;
import org.exoplatform.wiki.service.PermissionEntry;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.webui.UIPermissionGrid;
import org.exoplatform.wiki.webui.UIWikiPermissionEntry;
import org.exoplatform.wiki.webui.UIWikiPermissionForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiForm;
import org.exoplatform.wiki.webui.form.UIFormInputWithActions;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiPermissionForm.gtmpl", events={@EventConfig(listeners={AddEntryActionListener.class}), @EventConfig(listeners={DeleteEntryActionListener.class}), @EventConfig(listeners={OpenSelectUserFormActionListener.class}), @EventConfig(listeners={SelectUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenSelectGroupFormActionListener.class}), @EventConfig(listeners={SelectGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenSelectMembershipFormActionListener.class}), @EventConfig(listeners={SelectMembershipActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class})}), @ComponentConfig(type=UIPopupWindow.class, id="UIWikiUserPermissionPopupSelector", template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup"), @EventConfig(listeners={SelectUserActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseUserPopupActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UIWikiPermissionForm
extends UIWikiForm
implements UIPopupComponent {
    private List<PermissionEntry> permissionEntries = new ArrayList();
    private Scope scope;
    public static final String ANY = "any";
    public static final String ADD_ENTRY = "AddEntry";
    public static final String DELETE_ENTRY = "DeleteEntry";
    public static final String WIKI_PERMISSION_OWNER = "UIWikiPermissionOwner";
    public static final String PERMISSION_OWNER = "PermissionOwner";
    public static final String PERMISSION_POPUP_SELECTOR = "UIWikiPermissionPopupSelector";
    public static final String USER_PERMISSION_POPUP_SELECTOR = "UIWikiUserPermissionPopupSelector";
    public static final String OPEN_SELECT_USER_FORM = "OpenSelectUserForm";
    public static final String OPEN_SELECT_GROUP_FORM = "OpenSelectGroupForm";
    public static final String OPEN_SELECT_MEMBERSHIP_FORM = "OpenSelectMembershipForm";
    public static final String GROUP_ICON = "ActionIcon GroupIcon";
    public static final String USER_ICON = "ActionIcon UserIcon";
    public static final String MEMBERSHIP_ICON = "ActionIcon MembershipIcon";
    public static final String ADD_ICON = "ActionIcon Add";
    public static final String SAVE = "Save";
    public static final String CLOSE = "Close";
    private UIWikiPortlet.PopupLevel popupLevel = UIWikiPortlet.PopupLevel.L1;

    public UIPopupWindow getUserPermissionPopupSelector() {
        return (UIPopupWindow)this.getChildById(this.createIdByScope("UIWikiUserPermissionPopupSelector"));
    }

    public UIPopupWindow getPermissionPopupSelector() {
        return (UIPopupWindow)this.getChildById(this.createIdByScope("UIWikiPermissionPopupSelector"));
    }

    private String createIdByScope(String defaultId) {
        if (this.scope == null) {
            return defaultId;
        }
        return defaultId + "_" + this.scope.name();
    }

    public UIWikiPermissionForm() throws Exception {
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.addChild(UIPermissionGrid.class, null, null);
        permissionGrid.setPermissionEntries(this.permissionEntries);
        String[] actionNames = new String[]{"OpenSelectUserForm", "OpenSelectGroupForm", "OpenSelectMembershipForm", "AddEntry"};
        String[] actionIcons = new String[]{"ActionIcon UserIcon", "ActionIcon GroupIcon", "ActionIcon MembershipIcon", "ActionIcon Add"};
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        for (int i = 0; i < actionNames.length; ++i) {
            UIFormInputWithActions.ActionData action = new UIFormInputWithActions.ActionData();
            action.setActionListener(actionNames[i]);
            if (i < actionNames.length - 1) {
                action.setActionType(0);
            } else {
                action.setActionType(2);
            }
            action.setActionName(actionNames[i]);
            action.setCssIconClass(actionIcons[i]);
            actions.add(action);
        }
        UIFormInputWithActions owner = new UIFormInputWithActions("UIWikiPermissionOwner");
        owner.addUIFormInput((UIFormInput)new UIFormStringInput("PermissionOwner", "PermissionOwner", null));
        owner.setActionField("PermissionOwner", actions);
        this.addChild((UIComponent)owner);
        this.addPopupWindow();
        this.setActions(new String[]{"Save", "Close"});
    }

    public Scope getScope() {
        return this.scope;
    }

    public UIWikiPortlet.PopupLevel getPopupLevel() {
        return this.popupLevel;
    }

    public void setPopupLevel(UIWikiPortlet.PopupLevel popupLevel) {
        this.popupLevel = popupLevel;
    }

    public void cancelPopupAction() throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(this.getPopupLevel());
        popupContainer.cancelPopupAction();
        this.setPopupLevel(UIWikiPortlet.PopupLevel.L1);
    }

    private void addPopupWindow() throws Exception {
        this.addChild(UIPopupWindow.class, "UIWikiUserPermissionPopupSelector", this.createIdByScope("UIWikiUserPermissionPopupSelector"));
        this.addChild(UIPopupWindow.class, null, this.createIdByScope("UIWikiPermissionPopupSelector"));
    }

    private void removeAllPopupWindow() {
        ArrayList children = new ArrayList(this.getChildren());
        for (UIComponent uichild : children) {
            if (!(uichild instanceof UIPopupWindow)) continue;
            this.removeChild(uichild.getClass());
        }
    }

    private void closeAllPopupAction() {
        ArrayList children = new ArrayList(this.getChildren());
        for (UIComponent uichild : children) {
            if (!(uichild instanceof UIPopupWindow)) continue;
            UIWikiPermissionForm.closePopupAction((UIPopupWindow)((UIPopupWindow)uichild));
        }
    }

    private static void closePopupAction(UIPopupWindow uiPopupWindow) {
        uiPopupWindow.setUIComponent(null);
        uiPopupWindow.setShow(false);
    }

    private static void openPopupAction(UIPopupWindow uiPopup, UIComponent component) {
        uiPopup.setUIComponent(component);
        uiPopup.setShow(true);
        uiPopup.setWindowSize(550, 0);
    }

    public void setScope(Scope scope) throws Exception {
        this.scope = scope;
        this.removeAllPopupWindow();
        this.addPopupWindow();
        if (Scope.WIKI.equals((Object)this.scope)) {
            this.accept_Modes = Arrays.asList(WikiMode.VIEW, WikiMode.EDITPAGE, WikiMode.ADDPAGE, WikiMode.DELETEPAGE, WikiMode.VIEWREVISION, WikiMode.SHOWHISTORY, WikiMode.ADVANCEDSEARCH, WikiMode.SPACESETTING);
            this.setActions(new String[]{"Save"});
        } else if (Scope.PAGE.equals((Object)this.scope)) {
            this.accept_Modes = Arrays.asList(WikiMode.VIEW);
            this.setActions(new String[]{"Save", "Close"});
        }
    }

    public void setPermission(List<PermissionEntry> permissionEntries) throws Exception {
        this.permissionEntries = permissionEntries;
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.getChild(UIPermissionGrid.class);
        permissionGrid.setPermissionEntries(this.permissionEntries);
    }

    public List<PermissionEntry> convertToPermissionEntryList(HashMap<String, String[]> permissions) {
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        Set<Map.Entry<String, String[]>> entries = permissions.entrySet();
        for (Map.Entry<String, String[]> entry : entries) {
            PermissionEntry permissionEntry = new PermissionEntry();
            String key = entry.getKey();
            IDType idType = IDType.USER;
            if (key.indexOf(":") > 0) {
                idType = IDType.MEMBERSHIP;
            } else if (key.indexOf("/") == 0) {
                idType = IDType.GROUP;
            }
            permissionEntry.setIdType(idType);
            permissionEntry.setId(key);
            Permission[] perms = new Permission[2];
            perms[0] = new Permission();
            perms[0].setPermissionType(PermissionType.VIEWPAGE);
            perms[1] = new Permission();
            perms[1].setPermissionType(PermissionType.EDITPAGE);
            for (String action : entry.getValue()) {
                if ("read".equals(action)) {
                    perms[0].setAllowed(true);
                    continue;
                }
                if (!"add_node".equals(action) && !"remove".equals(action) && !"set_property".equals(action)) continue;
                perms[1].setAllowed(true);
            }
            permissionEntry.setPermissions(perms);
            permissionEntries.add(permissionEntry);
        }
        return permissionEntries;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    private void processPostAction() throws Exception {
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.getChild(UIPermissionGrid.class);
        ArrayList uiPermissionEntries = new ArrayList();
        permissionGrid.findComponentOfType(uiPermissionEntries, UIWikiPermissionEntry.class);
        ArrayList<PermissionEntry> permEntries = new ArrayList<PermissionEntry>();
        for (UIWikiPermissionEntry uiPermissionEntry : uiPermissionEntries) {
            PermissionEntry permissionEntry = uiPermissionEntry.getPermissionEntry();
            if (!uiPermissionEntry.isImmutable()) {
                Permission[] permissions = permissionEntry.getPermissions();
                for (int i = 0; i < permissions.length; ++i) {
                    UICheckBoxInput checkboxInput = (UICheckBoxInput)uiPermissionEntry.getChildById(permissions[i].getPermissionType().name() + permissionEntry.getId());
                    checkboxInput.setHTMLAttribute("title", (String)UIWikiPermissionEntry.getPermissionLabels().get(permissions[i].getPermissionType().name()));
                    permissions[i].setAllowed(checkboxInput.isChecked());
                }
            }
            permEntries.add(permissionEntry);
        }
        this.setPermission(permEntries);
    }

    private HashMap<String, String[]> convertToPermissionMap(List<PermissionEntry> permissionEntries) {
        HashMap<String, String[]> permissionMap = new HashMap<String, String[]>();
        for (PermissionEntry permissionEntry : permissionEntries) {
            Permission[] permissions = permissionEntry.getPermissions();
            ArrayList<String> permlist = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                Permission permission = permissions[i];
                if (!permission.isAllowed()) continue;
                if (permission.getPermissionType().equals((Object)PermissionType.VIEWPAGE)) {
                    permlist.add("read");
                    continue;
                }
                if (!permission.getPermissionType().equals((Object)PermissionType.EDITPAGE)) continue;
                permlist.add("add_node");
                permlist.add("remove");
                permlist.add("set_property");
            }
            if (permlist.size() <= 0) continue;
            permissionMap.put(permissionEntry.getId(), permlist.toArray(new String[permlist.size()]));
        }
        return permissionMap;
    }

    static /* synthetic */ void access$000(UIWikiPermissionForm x0) throws Exception {
        x0.processPostAction();
    }

    static /* synthetic */ List access$100(UIWikiPermissionForm x0) {
        return x0.permissionEntries;
    }

    static /* synthetic */ void access$200(UIWikiPermissionForm x0) {
        x0.closeAllPopupAction();
    }

    static /* synthetic */ void access$300(UIPopupWindow x0, UIComponent x1) {
        UIWikiPermissionForm.openPopupAction((UIPopupWindow)x0, (UIComponent)x1);
    }

    static /* synthetic */ void access$400(UIPopupWindow x0) {
        UIWikiPermissionForm.closePopupAction((UIPopupWindow)x0);
    }

    static /* synthetic */ HashMap access$500(UIWikiPermissionForm x0, List x1) {
        return x0.convertToPermissionMap(x1);
    }
}

