/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.HashMap;
import java.util.ResourceBundle;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.wiki.WikiPortletPreference;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.resolver.PageResolver;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.webui.EditMode;
import org.exoplatform.wiki.webui.UIWikiApplicationControlArea;
import org.exoplatform.wiki.webui.UIWikiBottomArea;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.UIWikiContentDisplay;
import org.exoplatform.wiki.webui.UIWikiEmptyAjaxBlock;
import org.exoplatform.wiki.webui.UIWikiMaskWorkspace;
import org.exoplatform.wiki.webui.UIWikiMiddleArea;
import org.exoplatform.wiki.webui.UIWikiPageArea;
import org.exoplatform.wiki.webui.UIWikiPageContentArea;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageInfoArea;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPageVersionsList;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiPortletPreferences;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.UIWikiSidePanelArea;
import org.exoplatform.wiki.webui.UIWikiUpperArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.UIAttachmentContainer;
import org.exoplatform.wiki.webui.control.action.AddPageActionComponent;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/wiki/webui/UIWikiPortlet.gtmpl", events={@EventConfig(listeners={ViewPageActionListener.class}), @EventConfig(listeners={ChangeModeActionListener.class}), @EventConfig(listeners={RedirectActionListener.class})})
public class UIWikiPortlet
extends UIPortletApplication {
    private WikiMode mode = WikiMode.VIEW;
    private EditMode editmode = EditMode.ALL;
    private String sectionIndex = "";
    private WikiMode previousMode;
    private WikiPortletPreference portletPreferences = new WikiPortletPreference();
    public static String VIEW_PAGE_ACTION = "ViewPage";
    public static String CHANGE_MODE_ACTION = "ChangeMode";
    public static String REDIRECT_ACTION = "Redirect";
    public static String WIKI_PORTLET_ACTION_PREFIX = "UIWikiPortlet_";
    private String redirectURL = "";
    private ResourceBundle resourceBundle;
    private PortletMode portletMode;

    public UIWikiPortlet() throws Exception {
        try {
            this.addChild(UIWikiEmptyAjaxBlock.class, null, null);
            this.addChild(UIWikiPortletPreferences.class, null, null);
            this.addChild(UIWikiUpperArea.class, null, null);
            this.addChild(UIWikiMiddleArea.class, null, null);
            this.addChild(UIWikiMaskWorkspace.class, null, "UIWikiMaskWorkspace");
            UIPopupContainer uiPopupContainer = (UIPopupContainer)this.addChild(UIPopupContainer.class, null, "UIWikiPopupContainer" + PopupLevel.L1);
            ((UIPopupWindow)uiPopupContainer.getChild(UIPopupWindow.class)).setId("UIWikiPopupWindow" + PopupLevel.L1);
            uiPopupContainer = (UIPopupContainer)uiPopupContainer.addChild(UIPopupContainer.class, null, "UIWikiPopupContainer" + PopupLevel.L2);
            ((UIPopupWindow)uiPopupContainer.getChild(UIPopupWindow.class)).setId("UIWikiPopupWindow" + PopupLevel.L2);
            this.loadPreferences();
        }
        catch (Exception e) {
            log.error((Object)"An exception happens when init WikiPortlet", (Throwable)e);
        }
    }

    public WikiPortletPreference getPortletPreferences() {
        return this.portletPreferences;
    }

    public void setPortletPreferences(WikiPortletPreference portletPreferences) {
        this.portletPreferences = portletPreferences;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            this.resourceBundle = context.getApplicationResourceBundle();
        }
        return this.resourceBundle;
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        this.redirectURL = this.url(REDIRECT_ACTION);
        this.loadPreferences();
        this.portletMode = portletReqContext.getApplicationMode();
        if (this.portletMode == PortletMode.VIEW) {
            block16: {
                UIWikiPageInfoArea pageInfoArea;
                Event xEvent;
                WikiPageParams pageParams;
                if (this.mode.equals((Object)WikiMode.PORTLETPREFERENCES)) {
                    this.changeMode(WikiMode.VIEW);
                }
                ((UIWikiBreadCrumb)((UIWikiApplicationControlArea)((UIWikiUpperArea)this.getChild(UIWikiUpperArea.class)).getChild(UIWikiApplicationControlArea.class)).getChild(UIWikiBreadCrumb.class)).setRendered(this.portletPreferences.isShowBreadcrumb());
                String requestURL = Utils.getCurrentRequestURL();
                PageResolver pageResolver = (PageResolver)PortalContainer.getComponent(PageResolver.class);
                Page page = pageResolver.resolve(requestURL, Util.getUIPortal().getSelectedUserNode());
                if (page == null) {
                    this.changeMode(WikiMode.PAGE_NOT_FOUND);
                    super.processRender(app, context);
                    return;
                }
                if (this.mode.equals((Object)WikiMode.PAGE_NOT_FOUND)) {
                    this.changeMode(WikiMode.VIEW);
                }
                if (StringUtils.isEmpty((String)page.getURL())) {
                    page.setURL(Utils.getURLFromParams((WikiPageParams)new WikiPageParams(page.getWiki().getType(), page.getWiki().getOwner(), page.getName())));
                }
                if ("AddPage".equalsIgnoreCase((pageParams = Utils.getCurrentWikiPageParams()).getParameter("action"))) {
                    AddPageActionComponent addPageComponent = (AddPageActionComponent)this.findFirstComponentOfType(AddPageActionComponent.class);
                    if (addPageComponent != null && (xEvent = addPageComponent.createEvent("AddPage", Event.Phase.PROCESS, context)) != null) {
                        xEvent.broadcast();
                    }
                } else if ("CompareRevision".equalsIgnoreCase(pageParams.getParameter("action")) && (pageInfoArea = (UIWikiPageInfoArea)this.findFirstComponentOfType(UIWikiPageInfoArea.class)) != null && (xEvent = pageInfoArea.createEvent("CompareRevision", Event.Phase.PROCESS, context)) != null) {
                    xEvent.broadcast();
                }
                try {
                    context.setAttribute("wikiPage", (Object)page);
                    ((UIWikiPageTitleControlArea)this.findComponentById("UIWikiPageTitleControlForm_PageControlArea")).getUIFormInputInfo().setValue((Object)page.getTitle());
                }
                catch (Exception e) {
                    context.setAttribute("wikiPage", null);
                    UIWikiPageContentArea wikiPageContentArea = (UIWikiPageContentArea)this.findFirstComponentOfType(UIWikiPageContentArea.class);
                    if (wikiPageContentArea != null) {
                        UIWikiContentDisplay contentDisplay = (UIWikiContentDisplay)wikiPageContentArea.getChildById("UIViewContentDisplay");
                        contentDisplay.setHtmlOutput("Exceptions occur when rendering content!");
                    }
                    if (!log.isWarnEnabled()) break block16;
                    log.warn((Object)("An exception happens when resolving URL: " + requestURL), (Throwable)e);
                }
            }
            super.processRender(app, context);
            if (this.getWikiMode() == WikiMode.HELP) {
                this.changeMode(this.previousMode);
            }
        } else if (this.portletMode == PortletMode.EDIT) {
            this.changeMode(WikiMode.PORTLETPREFERENCES);
            super.processRender(app, context);
        } else {
            super.processRender(app, context);
        }
    }

    public UIPopupContainer getPopupContainer(PopupLevel level) {
        UIPopupContainer popupContainer = (UIPopupContainer)this.getChildById("UIWikiPopupContainer" + PopupLevel.L1);
        if (level == PopupLevel.L2) {
            popupContainer = (UIPopupContainer)popupContainer.getChildById("UIWikiPopupContainer" + PopupLevel.L2);
        }
        return popupContainer;
    }

    public WikiMode getWikiMode() {
        return this.mode;
    }

    public EditMode getEditMode() {
        return this.editmode;
    }

    public String getSectionIndex() {
        return this.sectionIndex;
    }

    public void setSectionIndex(String sectionIndex) {
        this.sectionIndex = sectionIndex;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void changeMode(WikiMode newMode) {
        if (newMode == WikiMode.HELP) {
            this.previousMode = this.mode;
        }
        if (newMode.equals((Object)WikiMode.VIEW)) {
            ((UIWikiPageTitleControlArea)this.findFirstComponentOfType(UIWikiPageTitleControlArea.class)).toInfoMode();
            UIWikiBottomArea bottomArea = (UIWikiBottomArea)((UIWikiBottomArea)this.findFirstComponentOfType(UIWikiBottomArea.class)).setRendered(true);
            ((UIAttachmentContainer)bottomArea.getChild(UIAttachmentContainer.class)).setRendered(false);
            ((UIWikiPageVersionsList)bottomArea.getChild(UIWikiPageVersionsList.class)).setRendered(false);
        }
        if (newMode.equals((Object)WikiMode.EDITPAGE) || newMode.equals((Object)WikiMode.ADDPAGE)) {
            ((UIWikiSidePanelArea)this.findFirstComponentOfType(UIWikiSidePanelArea.class)).setRendered(true);
            ((UIWikiBottomArea)this.findFirstComponentOfType(UIWikiBottomArea.class)).setRendered(true);
            ((UIAttachmentContainer)this.findFirstComponentOfType(UIAttachmentContainer.class)).setRendered(true);
            ((UIWikiRichTextArea)this.findFirstComponentOfType(UIWikiRichTextArea.class)).setRendered(false);
            ((UIWikiPageEditForm)this.findFirstComponentOfType(UIWikiPageEditForm.class)).getUIFormTextAreaInput("Markup").setRendered(true);
        }
        this.mode = newMode;
    }

    public void changeEditMode(EditMode newEditMode) {
        this.editmode = newEditMode;
    }

    private void loadPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        try {
            this.portletPreferences.setShowBreadcrumb(Boolean.parseBoolean(portletPref.getValue(WikiPortletPreference.SHOW_BREADCRUMB, "true")));
            this.portletPreferences.setShowNavigationTree(Boolean.parseBoolean(portletPref.getValue(WikiPortletPreference.SHOW_NAVIGATIONTREE, "true")));
        }
        catch (Exception e) {
            log.error((Object)"Fail to load wiki portlet's preference: ", (Throwable)e);
        }
    }

    public HashMap<String, Object> getUIExtContext() throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        WikiPageParams params = Utils.getCurrentWikiPageParams();
        context.put("mode", this.mode);
        context.put("page", params.getPageId());
        context.put("wikiOwner", params.getOwner());
        context.put("wikiType", params.getType());
        UIWikiPageArea wikiPageArea = (UIWikiPageArea)this.findFirstComponentOfType(UIWikiPageArea.class);
        UIWikiPageEditForm wikiPageEditForm = (UIWikiPageEditForm)wikiPageArea.findFirstComponentOfType(UIWikiPageEditForm.class);
        UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)wikiPageEditForm.findFirstComponentOfType(UIWikiRichTextArea.class);
        context.put("isMarkup", !wikiRichTextArea.isRendered());
        return context;
    }

    protected boolean isKeepSessionAlive() {
        return this.mode == WikiMode.EDITPAGE || this.mode == WikiMode.EDITTEMPLATE || this.mode == WikiMode.ADDPAGE || this.mode == WikiMode.ADDTEMPLATE;
    }

    static /* synthetic */ WikiMode access$000(UIWikiPortlet x0) {
        return x0.mode;
    }
}

