/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.commons.EventUIComponent;
import org.exoplatform.webui.commons.UISpacesSwitcher;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiBreadCrumb.gtmpl", events={@EventConfig(listeners={SwitchSpaceActionListener.class})})
public class UIWikiBreadCrumb
extends UIContainer {
    public static final String SPACE_SWITCHER = "uiSpaceSwitcher_BreadCrumb";
    private static final String SWITCH_SPACE_ACTION = "SwitchSpace";
    private static final String BREAD_CRUMB_CONTAINER = "UIWikiBreadCrumb";
    private List<BreadcrumbData> breadCumbs = new ArrayList();
    private String actionLabel;
    private boolean isLink = true;
    private boolean isAllowChooseSpace = false;
    private boolean isShowWikiName = true;
    private static final Log log = ExoLogger.getLogger(UIWikiBreadCrumb.class);
    private boolean isShowWikiType = true;
    private boolean isDisplayFullSpaceName = true;

    public UIWikiBreadCrumb() throws Exception {
        UISpacesSwitcher uiWikiSpaceSwitcher = (UISpacesSwitcher)this.addChild(UISpacesSwitcher.class, null, SPACE_SWITCHER);
        EventUIComponent eventComponent = new EventUIComponent(BREAD_CRUMB_CONTAINER, SWITCH_SPACE_ACTION, EventUIComponent.EVENTTYPE.EVENT);
        uiWikiSpaceSwitcher.init(eventComponent);
    }

    public List<BreadcrumbData> getBreadCumbs() {
        return this.breadCumbs;
    }

    public void setBreadCumbs(List<BreadcrumbData> breadCumbs) {
        this.breadCumbs = breadCumbs;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public String getParentURL() throws Exception {
        if (this.breadCumbs.size() > 1) {
            return this.createActionLink((BreadcrumbData)this.breadCumbs.get(this.breadCumbs.size() - 2));
        }
        return this.createActionLink((BreadcrumbData)this.breadCumbs.get(0));
    }

    public boolean isLink() {
        return this.isLink;
    }

    public UIWikiBreadCrumb setLink(boolean isLink) {
        this.isLink = isLink;
        return this;
    }

    public boolean isAllowChooseSpace() {
        return this.isAllowChooseSpace;
    }

    public void setAllowChooseSpace(boolean isAlowChooseSpace) {
        this.isAllowChooseSpace = isAlowChooseSpace;
    }

    public boolean isShowWikiName() {
        return this.isShowWikiName;
    }

    public void setShowWikiName(boolean isShowWikiName) {
        this.isShowWikiName = isShowWikiName;
    }

    public WikiPageParams getPageParam() throws Exception {
        if (this.breadCumbs != null && this.breadCumbs.size() > 0) {
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            return wservice.getWikiPageParams((BreadcrumbData)this.breadCumbs.get(this.breadCumbs.size() - 1));
        }
        return null;
    }

    public String getWikiType() throws Exception {
        WikiPageParams params = this.getPageParam();
        if (params != null) {
            return params.getType();
        }
        return null;
    }

    public String getWikiName() throws Exception {
        WikiPageParams params = this.getPageParam();
        if (params != null) {
            String wikiType = params.getType();
            String wikiOwner = params.getOwner();
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            return Utils.getSpaceName((Wiki)wikiService.getWiki(wikiType, wikiOwner));
        }
        return null;
    }

    public boolean isShowWikiType() {
        return this.isShowWikiType;
    }

    public void setShowWikiType(boolean isShowWikiType) {
        this.isShowWikiType = isShowWikiType;
    }

    public boolean isDisplayFullSpaceName() {
        return this.isDisplayFullSpaceName;
    }

    public void setDisplayFullSpaceName(boolean isDisplayFullSpaceName) {
        this.isDisplayFullSpaceName = isDisplayFullSpaceName;
    }

    public String createActionLink(BreadcrumbData breadCumbData) throws Exception {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        StringBuilder sb = new StringBuilder(portalRequestContext.getPortalURI());
        UIPortal uiPortal = Util.getUIPortal();
        String pageNodeSelected = uiPortal.getSelectedUserNode().getURI();
        sb.append(pageNodeSelected);
        sb.append("/");
        if (!PortalConfig.PORTAL_TYPE.equalsIgnoreCase(breadCumbData.getWikiType())) {
            sb.append(breadCumbData.getWikiType());
            sb.append("/");
            sb.append(org.exoplatform.wiki.utils.Utils.validateWikiOwner((String)breadCumbData.getWikiType(), (String)breadCumbData.getWikiOwner()));
            sb.append("/");
        }
        sb.append(breadCumbData.getId());
        return sb.toString();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (IdentityConstants.ANONIM.equals(ConversationState.getCurrent().getIdentity().getUserId())) {
            this.setAllowChooseSpace(false);
        }
        super.processRender(context);
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

