/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.UIWikiSidePanelArea;
import org.exoplatform.wiki.webui.UIWikiTemplateDescriptionContainer;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.UIEditorTabs;
import org.exoplatform.wiki.webui.control.UISubmitToolBar;
import org.exoplatform.wiki.webui.core.UIWikiForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiPageEditForm.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={DeleteDraftActionListener.class}), @EventConfig(listeners={ResumeDraftActionListener.class}), @EventConfig(listeners={ViewDraftChangeActionListener.class}), @EventConfig(listeners={CancelDraftActionListener.class})})
public class UIWikiPageEditForm
extends UIWikiForm {
    public static final String UNTITLED = "Untitled";
    public static final String FIELD_CONTENT = "Markup";
    public static final String FIELD_COMMENT = "Comment";
    public static final String FIELD_PUBLISH_ACTIVITY_UPPER = "PublishActivityUpper";
    public static final String FIELD_PUBLISH_ACTIVITY_BOTTOM = "PublishActivityBottom";
    public static final String TITLE_CONTROL = "UIWikiPageTitleControlForm_PageEditForm";
    public static final String EDITOR_TABS = "UIEditorTabs";
    public static final String SUBMIT_TOOLBAR_UPPER = "UISubmitToolBarUpper";
    public static final String SUBMIT_TOOLBAR_BOTTOM = "UISubmitToolBarBottom";
    public static final String HELP_PANEL = "UIWikiSidePanelArea";
    public static final String RICHTEXT_AREA = "UIWikiRichTextArea";
    public static final String FIELD_TEMPLATEDESCTIPTION = "UIWikiTemplateDescriptionContainer";
    private boolean isTemplate = false;
    private String templateId = "";
    private String title;
    private List<String> notificationMessages = new ArrayList();
    private String initDraftName = "";
    private boolean isFirstTimeRenderEdit = true;
    private boolean isRunAutoSave = true;
    public static final String CLOSE = "Close";

    public UIWikiPageEditForm() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.EDITPAGE, WikiMode.ADDPAGE, WikiMode.EDITTEMPLATE, WikiMode.ADDTEMPLATE);
        ((UIWikiPageTitleControlArea)this.addChild(UIWikiPageTitleControlArea.class, null, TITLE_CONTROL)).toInputMode();
        this.addChild(UISubmitToolBar.class, null, SUBMIT_TOOLBAR_UPPER);
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_PUBLISH_ACTIVITY_UPPER, FIELD_PUBLISH_ACTIVITY_UPPER, Boolean.valueOf(false)));
        this.addChild(UIWikiTemplateDescriptionContainer.class, null, FIELD_TEMPLATEDESCTIPTION);
        this.addChild(UIEditorTabs.class, null, EDITOR_TABS);
        this.addChild(UISubmitToolBar.class, null, SUBMIT_TOOLBAR_BOTTOM);
        this.addChild(UIWikiSidePanelArea.class, null, HELP_PANEL);
        ((UIWikiRichTextArea)this.addChild(UIWikiRichTextArea.class, null, RICHTEXT_AREA)).setRendered(false);
        UIFormTextAreaInput markupInput = new UIFormTextAreaInput(FIELD_CONTENT, FIELD_CONTENT, "");
        this.addUIFormInput((UIFormInput)markupInput);
        UIFormStringInput commentInput = new UIFormStringInput(FIELD_COMMENT, FIELD_COMMENT, "");
        this.addUIFormInput((UIFormInput)commentInput);
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_PUBLISH_ACTIVITY_BOTTOM, FIELD_PUBLISH_ACTIVITY_BOTTOM, Boolean.valueOf(false)));
    }

    protected void checkToDissplayNotification() throws Exception {
        if ("__anonim".equals(org.exoplatform.wiki.utils.Utils.getCurrentUser())) {
            this.isRunAutoSave = false;
            return;
        }
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        this.notificationMessages.clear();
        this.isRunAutoSave = true;
        if (wikiPortlet.getWikiMode() == WikiMode.EDITPAGE) {
            List edittingUsers;
            DraftPage draftPage = wikiService.getDraft(pageParams);
            if (draftPage != null && !draftPage.getName().equals(this.initDraftName)) {
                this.isRunAutoSave = false;
                if (draftPage.isOutDate()) {
                    this.notificationMessages.add(this.createDraftOutdateNotification());
                } else {
                    this.notificationMessages.add(this.createDraftExistNotification(draftPage.getUpdatedDate()));
                }
            }
            if ((edittingUsers = org.exoplatform.wiki.utils.Utils.getListOfUserEditingPage((String)pageParams.getPageId())).size() > 0) {
                this.notificationMessages.add(this.createCocurrentEdittingNotification(edittingUsers));
            }
        }
    }

    private String createDraftOutdateNotification() throws Exception {
        ResourceBundle bundle = RequestContext.getCurrentInstance().getApplicationResourceBundle();
        String messageMarkup = bundle.getString("DraftPage.msg.draft-version-outdated");
        String messageHTML = "<div class='alert alert-info'><i class='uiIconInformation uiIconBlue'></i>" + messageMarkup + "</div>";
        String viewChangeDraftLabel = bundle.getString("DraftPage.label.view-your-change");
        String viewChangeActionLink = this.event("ViewDraftChange");
        String continueEdittingLabel = bundle.getString("DraftPage.label.continue-editing");
        String continueEdittingActionLink = this.event("ResumeDraft");
        String deleteDraftLabel = bundle.getString("DraftPage.label.delete");
        String deleteActionLink = this.event("DeleteDraft");
        messageHTML = messageHTML.replace("{0}", "<a href=\"" + viewChangeActionLink + "\">" + viewChangeDraftLabel + "</a>");
        messageHTML = messageHTML.replace("{1}", "<a href=\"" + continueEdittingActionLink + "\">" + continueEdittingLabel + "</a>");
        messageHTML = messageHTML.replace("{2}", "<a href=\"" + deleteActionLink + "\">" + deleteDraftLabel + "</a>");
        return messageHTML;
    }

    private String createDraftExistNotification(Date draftUpdatedDate) throws Exception {
        ResourceBundle bundle = RequestContext.getCurrentInstance().getApplicationResourceBundle();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(draftUpdatedDate);
        String messageMarkup = bundle.getString("DraftPage.msg.draft-exist-notification");
        StringBuffer dateString = new StringBuffer().append("{").append(calendar.getTimeInMillis()).append("}");
        messageMarkup = messageMarkup.replace("{0}", dateString.toString());
        String messageHTML = "<div class='alert alert-info'><i class='uiIconInformation uiIconBlue'></i>" + messageMarkup + "</div>";
        String viewChangeDraftLabel = bundle.getString("DraftPage.label.view-your-change");
        String viewChangeActionLink = this.event("ViewDraftChange");
        String resumeDraftLabel = bundle.getString("DraftPage.label.resume-the-draft");
        String resumeActionLink = this.event("ResumeDraft");
        String deleteDraftLabel = bundle.getString("DraftPage.label.delete");
        String deleteActionLink = this.event("DeleteDraft");
        messageHTML = messageHTML.replace("{1}", "<a href=\"" + viewChangeActionLink + "\">" + viewChangeDraftLabel + "</a>");
        messageHTML = messageHTML.replace("{2}", "<a href=\"" + resumeActionLink + "\">" + resumeDraftLabel + "</a>");
        messageHTML = messageHTML.replace("{3}", "<a href=\"" + deleteActionLink + "\">" + deleteDraftLabel + "</a>");
        return messageHTML;
    }

    private String createCocurrentEdittingNotification(List<String> users) throws Exception {
        StringBuilder usernameList = new StringBuilder();
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        for (String user : users) {
            User userObject = organizationService.getUserHandler().findUserByName(user);
            usernameList.append(userObject.getFullName());
            usernameList.append(", ");
        }
        usernameList.setLength(usernameList.length() - 2);
        ResourceBundle bundle = RequestContext.getCurrentInstance().getApplicationResourceBundle();
        String messageMarkup = bundle.getString("DraftPage.msg.concurrent-editing");
        messageMarkup = messageMarkup.replace("{0}", "<b>" + usernameList.toString() + "</b>");
        messageMarkup = "<div class='alert'><i class='uiIconWarning'></i>" + messageMarkup + "</div>";
        return messageMarkup;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getInitDraftName() {
        return this.initDraftName;
    }

    public void setInitDraftName(String initDraftName) {
        this.initDraftName = initDraftName;
        this.isFirstTimeRenderEdit = true;
    }

    public boolean isFirstTimeRenderEdit() {
        return this.isFirstTimeRenderEdit;
    }

    public void setFirstTimeRenderEdit(boolean value) {
        this.isFirstTimeRenderEdit = value;
    }

    public boolean isInTemplateMode() {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        return wikiPortlet.getWikiMode() == WikiMode.ADDTEMPLATE || wikiPortlet.getWikiMode() == WikiMode.EDITTEMPLATE;
    }

    public boolean isNewPage() {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        return wikiPortlet.getWikiMode() != WikiMode.EDITPAGE;
    }

    public long getAutoSaveSequenceTime() {
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        return wikiService.getSaveDraftSequenceTime();
    }

    protected String getSaveDraftRestUrl() {
        StringBuilder childrenURLSb = new StringBuilder(Utils.getCurrentRestURL());
        childrenURLSb.append("/wiki/saveDraft/");
        return childrenURLSb.toString();
    }

    protected String getRemoveDraftRestUrl() {
        StringBuilder childrenURLSb = new StringBuilder(Utils.getCurrentRestURL());
        childrenURLSb.append("/wiki/removeDraft/");
        return childrenURLSb.toString();
    }

    protected String getWikiType() throws Exception {
        WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
        return pageParams.getType();
    }

    protected String getWikiOwner() throws Exception {
        WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
        return pageParams.getOwner();
    }

    protected String getCurrentPageId() throws Exception {
        WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
        return pageParams.getPageId();
    }

    protected String getCurrentPageRevision() throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        if (wikiPortlet.getWikiMode() == WikiMode.EDITPAGE) {
            Page page = Utils.getCurrentWikiPage();
            return org.exoplatform.wiki.utils.Utils.getLastRevisionOfPage((Page)page).getName();
        }
        return "";
    }

    public List getNotificationMessages() {
        return this.notificationMessages;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public boolean isSidePanelRendered() {
        return ((UIWikiSidePanelArea)this.getChild(UIWikiSidePanelArea.class)).isRendered();
    }

    public boolean isRunAutoSave() {
        return this.isRunAutoSave;
    }

    protected boolean isInRichTextEditor() {
        UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)this.getChild(UIWikiRichTextArea.class);
        return wikiRichTextArea.isRendered();
    }

    protected String getCancelDraftEvent() throws Exception {
        return Utils.createFormActionLink((UIComponent)this, (String)"CancelDraft", null);
    }

    public void synPublishActivityStatus(boolean isChecked) {
        UICheckBoxInput publishActivityUpperCheckBox = (UICheckBoxInput)this.findComponentById(FIELD_PUBLISH_ACTIVITY_UPPER);
        UICheckBoxInput publishActivityBottomCheckBox = (UICheckBoxInput)this.findComponentById(FIELD_PUBLISH_ACTIVITY_BOTTOM);
        publishActivityUpperCheckBox.setChecked(isChecked);
        publishActivityBottomCheckBox.setChecked(isChecked);
    }

    private void checkRenderOfPublishActivityCheckBoxes() {
        UICheckBoxInput publishActivityUpperCheckBox = (UICheckBoxInput)this.findComponentById(FIELD_PUBLISH_ACTIVITY_UPPER);
        UICheckBoxInput publishActivityBottomCheckBox = (UICheckBoxInput)this.findComponentById(FIELD_PUBLISH_ACTIVITY_BOTTOM);
        if (WikiMode.EDITPAGE == this.getCurrentMode()) {
            publishActivityUpperCheckBox.setRendered(true);
            publishActivityBottomCheckBox.setRendered(true);
        } else {
            publishActivityUpperCheckBox.setRendered(false);
            publishActivityBottomCheckBox.setRendered(false);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.checkRenderOfPublishActivityCheckBoxes();
        super.processRender(context);
    }
}

