/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.Template;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.WikiNameValidator;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.filter.IsEditAddTemplateModeFilter;
import org.exoplatform.wiki.webui.control.listener.UISubmitToolBarActionListener;
import org.exoplatform.wiki.webui.extension.UITemplateSettingForm;

@ComponentConfig(template="app:/templates/wiki/webui/control/action/SaveTemplateActionComponent.gtmpl", events={@EventConfig(listeners={SaveTemplateActionListener.class}, phase=Event.Phase.DECODE)})
public class SaveTemplateActionComponent
extends UIComponent {
    public static final String ACTION = "SaveTemplate";
    private static final Log log = ExoLogger.getLogger((String)"wiki:SaveTemplateActionComponent");
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsEditAddTemplateModeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    protected boolean isNewMode() {
        return WikiMode.ADDPAGE.equals((Object)((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getWikiMode());
    }

    protected String getActionLink() throws Exception {
        return Utils.createFormActionLink(this, ACTION, ACTION);
    }

    protected String getPageTitleInputId() {
        return "titleInput";
    }

    public static class SaveTemplateActionListener
    extends UISubmitToolBarActionListener<SaveTemplateActionComponent> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEvent(Event<SaveTemplateActionComponent> event) throws Exception {
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((SaveTemplateActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormStringInput descriptionInput = (UIFormStringInput)pageEditForm.findComponentById("Description");
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            try {
                WikiNameValidator.validate((String)((String)titleInput.getValue()));
            }
            catch (IllegalNameException ex) {
                String msg = ex.getMessage();
                ApplicationMessage appMsg = new ApplicationMessage("WikiPageNameValidator.msg.EmptyTitle", null, 1);
                if (msg != null) {
                    Object[] arg = new Object[]{msg};
                    appMsg = new ApplicationMessage("WikiPageNameValidator.msg.Invalid-char", arg, 1);
                }
                event.getRequestContext().getUIApplication().addMessage(appMsg);
                event.getRequestContext().setProcessRender(true);
            }
            if (event.getRequestContext().getProcessRender()) {
                Utils.redirect(pageParams, wikiPortlet.getWikiMode());
                return;
            }
            String title = ((String)titleInput.getValue()).trim();
            String markup = markupInput.getValue() == null ? "" : (String)markupInput.getValue();
            markup = markup.trim();
            String description = (String)descriptionInput.getValue();
            String syntaxId = Utils.getDefaultSyntax();
            Object[] msgArg = new String[]{title};
            boolean isExist = false;
            try {
                String idTemp = TitleResolver.getId((String)title, (boolean)false);
                if (wikiPortlet.getWikiMode() == WikiMode.ADDTEMPLATE || wikiPortlet.getWikiMode() == WikiMode.EDITTEMPLATE && !idTemp.equals(pageEditForm.getTemplateId())) {
                    boolean bl = isExist = wikiService.getTemplatePage(pageParams, idTemp) != null;
                    if (isExist) {
                        event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("SavePageAction.msg.warning-page-title-already-exist", null, 1));
                        Utils.redirect(pageParams, wikiPortlet.getWikiMode());
                        return;
                    }
                }
                if (wikiPortlet.getWikiMode() == WikiMode.EDITTEMPLATE) {
                    Template template = wikiService.getTemplatePage(pageParams, pageEditForm.getTemplateId());
                    wikiService.modifyTemplate(pageParams, template, title, description, markup, syntaxId);
                } else if (wikiPortlet.getWikiMode() == WikiMode.ADDTEMPLATE) {
                    Template template = wikiService.createTemplatePage(title, pageParams);
                    template.setDescription(StringEscapeUtils.escapeHtml((String)description));
                    template.getContent().setText(markup);
                    template.setSyntax(syntaxId);
                    template.setNonePermission();
                    ApplicationMessage message = new ApplicationMessage("SaveTemplateAction.msg.Create-template-successfully", msgArg, 2);
                    message.setArgsLocalized(false);
                    event.getRequestContext().getUIApplication().addMessage(message);
                }
            }
            catch (Exception e) {
                log.error((Object)("An exception happens when saving the page with title:" + title), (Throwable)e);
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIPageToolBar.msg.Exception", null, 0));
            }
            finally {
                if (!isExist) {
                    UITemplateSettingForm uiTemplateSettingForm = (UITemplateSettingForm)wikiPortlet.findFirstComponentOfType(UITemplateSettingForm.class);
                    if (uiTemplateSettingForm != null) {
                        uiTemplateSettingForm.initGrid();
                    }
                    Utils.redirect(pageParams, WikiMode.SPACESETTING);
                }
                super.processEvent(event);
            }
        }
    }
}

