/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.WatchedMixin;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.control.filter.IsUserFilter;
import org.exoplatform.wiki.webui.control.filter.IsViewModeFilter;
import org.exoplatform.wiki.webui.control.listener.MoreContainerActionListener;

@ComponentConfig(template="app:/templates/wiki/webui/control/action/WatchPageActionComponent.gtmpl", events={@EventConfig(listeners={WatchPageActionListener.class})})
public class WatchPageActionComponent
extends UIComponent {
    protected static final String WATCH_PAGE = "WatchPage";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsUserFilter(), new IsViewModeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public boolean detectWatched(boolean isChangeState) throws Exception {
        RenderingService renderingService = (RenderingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RenderingService.class);
        ConversationState conversationState = ConversationState.getCurrent();
        String currentUserId = conversationState.getIdentity().getUserId();
        PageImpl currentPage = (PageImpl)Utils.getCurrentWikiPage();
        currentPage.makeWatched();
        WatchedMixin mixin = currentPage.getWatchedMixin();
        List watchers = mixin.getWatchers();
        boolean isWatched = false;
        for (String watcher : watchers) {
            if (!watcher.equals(currentUserId)) continue;
            isWatched = true;
        }
        for (String watcher : watchers) {
            if (!watcher.equals(currentUserId)) continue;
            isWatched = true;
        }
        if (isChangeState) {
            if (isWatched) {
                watchers.remove(currentUserId);
            } else {
                watchers.add(currentUserId);
            }
            if (renderingService.getCssURL() == null) {
                renderingService.setCssURL(this.getPortletCssLink());
            }
            mixin.setWatchers(watchers);
            currentPage.setWatchedMixin(mixin);
        }
        return isWatched;
    }

    private String getPortletCssLink() {
        SkinService skinService = (SkinService)PortalContainer.getComponent(SkinService.class);
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String requestURL = portalRequestContext.getRequest().getRequestURL().toString();
        String portalURI = portalRequestContext.getPortalURI();
        String domainURL = requestURL.substring(0, requestURL.indexOf(portalURI));
        UIPortal uiPortal = Util.getUIPortal();
        UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
        String currentSkin = uiPortalApp.getSkin();
        UIPageBody uiPageBody = (UIPageBody)uiPortal.findFirstComponentOfType(UIPageBody.class);
        if (uiPageBody != null) {
            UIPortlet currentPortlet = (UIPortlet)uiPageBody.findFirstComponentOfType(UIPortlet.class);
            SkinConfig skinConfig = skinService.getSkin(currentPortlet.getSkinId(), currentSkin);
            StringBuilder sb = new StringBuilder(domainURL);
            sb.append(skinConfig.getCSSPath());
            return sb.toString();
        }
        return null;
    }

    public static class WatchPageActionListener
    extends MoreContainerActionListener<WatchPageActionComponent> {
        @Override
        protected void processEvent(Event<WatchPageActionComponent> event) throws Exception {
            boolean isWatched = ((WatchPageActionComponent)((Object)event.getSource())).detectWatched(true);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((WatchPageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)wikiPortlet);
            if (isWatched) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("WatchPageAction.msg.Stop-watching", null, 2));
            } else {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("WatchPageAction.msg.Start-watching", null, 2));
            }
            super.processEvent(event);
        }
    }
}

