/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.organization.UIGroupMembershipSelector;
import org.exoplatform.webui.organization.account.UIGroupSelector;
import org.exoplatform.webui.organization.account.UIUserSelector;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.Permission;
import org.exoplatform.wiki.service.PermissionEntry;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIPermissionGrid;
import org.exoplatform.wiki.webui.UIWikiPageControlArea;
import org.exoplatform.wiki.webui.UIWikiPageInfoArea;
import org.exoplatform.wiki.webui.UIWikiPermissionEntry;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiForm;
import org.exoplatform.wiki.webui.form.UIFormInputWithActions;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiPermissionForm.gtmpl", events={@EventConfig(listeners={AddEntryActionListener.class}), @EventConfig(listeners={DeleteEntryActionListener.class}), @EventConfig(listeners={OpenSelectUserFormActionListener.class}), @EventConfig(listeners={SelectUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenSelectGroupFormActionListener.class}), @EventConfig(listeners={SelectGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenSelectMembershipFormActionListener.class}), @EventConfig(listeners={SelectMembershipActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class})}), @ComponentConfig(type=UIPopupWindow.class, id="UIWikiUserPermissionPopupSelector", template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup"), @EventConfig(listeners={SelectUserActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseUserPopupActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UIWikiPermissionForm
extends UIWikiForm
implements UIPopupComponent {
    private List<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
    private Scope scope;
    public static final String ANY = "any";
    public static final String ROOT = "root";
    public static final String ADD_ENTRY = "AddEntry";
    public static final String DELETE_ENTRY = "DeleteEntry";
    public static final String WIKI_PERMISSION_OWNER = "uiWikiPermissionOwner";
    public static final String PERMISSION_OWNER = "PermissionOwner";
    public static final String PERMISSION_POPUP_SELECTOR = "UIWikiPermissionPopupSelector";
    public static final String USER_PERMISSION_POPUP_SELECTOR = "UIWikiUserPermissionPopupSelector";
    public static final String OPEN_SELECT_USER_FORM = "OpenSelectUserForm";
    public static final String OPEN_SELECT_GROUP_FORM = "OpenSelectGroupForm";
    public static final String OPEN_SELECT_MEMBERSHIP_FORM = "OpenSelectMembershipForm";
    public static final String GROUP_ICON = "uiIconGroup";
    public static final String USER_ICON = "uiIconUser";
    public static final String MEMBERSHIP_ICON = "uiIconMembership";
    public static final String ADD_ICON = "ActionIcon Add";
    public static final String SAVE = "Save";
    public static final String CLOSE = "Close";
    private UIWikiPortlet.PopupLevel popupLevel = UIWikiPortlet.PopupLevel.L1;

    public UIPopupWindow getUserPermissionPopupSelector() {
        return (UIPopupWindow)this.getChildById(this.createIdByScope(USER_PERMISSION_POPUP_SELECTOR));
    }

    public UIPopupWindow getPermissionPopupSelector() {
        return (UIPopupWindow)this.getChildById(this.createIdByScope(PERMISSION_POPUP_SELECTOR));
    }

    private String createIdByScope(String defaultId) {
        if (this.scope == null) {
            return defaultId;
        }
        return defaultId + "_" + this.scope.name();
    }

    public UIWikiPermissionForm() throws Exception {
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.addChild(UIPermissionGrid.class, null, null);
        permissionGrid.setPermissionEntries(this.permissionEntries);
        String[] actionNames = new String[]{OPEN_SELECT_USER_FORM, OPEN_SELECT_MEMBERSHIP_FORM, OPEN_SELECT_GROUP_FORM, ADD_ENTRY};
        String[] actionIcons = new String[]{USER_ICON, MEMBERSHIP_ICON, GROUP_ICON, ADD_ICON};
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        for (int i = 0; i < actionNames.length; ++i) {
            UIFormInputWithActions.ActionData action = new UIFormInputWithActions.ActionData();
            action.setActionListener(actionNames[i]);
            if (i < actionNames.length - 1) {
                action.setActionType(0);
            } else {
                action.setActionType(2);
            }
            action.setActionName(actionNames[i]);
            action.setCssIconClass(actionIcons[i]);
            actions.add(action);
        }
        UIFormInputWithActions owner = new UIFormInputWithActions(WIKI_PERMISSION_OWNER);
        owner.addUIFormInput((UIFormInput)new UIFormStringInput(PERMISSION_OWNER, PERMISSION_OWNER, null));
        owner.setActionField(PERMISSION_OWNER, actions);
        this.addChild((UIComponent)owner);
        this.addPopupWindow();
        this.setActions(new String[]{SAVE, CLOSE});
    }

    public Scope getScope() {
        return this.scope;
    }

    public UIWikiPortlet.PopupLevel getPopupLevel() {
        return this.popupLevel;
    }

    public void setPopupLevel(UIWikiPortlet.PopupLevel popupLevel) {
        this.popupLevel = popupLevel;
    }

    public void cancelPopupAction() throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(this.getPopupLevel());
        popupContainer.cancelPopupAction();
        this.setPopupLevel(UIWikiPortlet.PopupLevel.L1);
    }

    private void addPopupWindow() throws Exception {
        this.addChild(UIPopupWindow.class, USER_PERMISSION_POPUP_SELECTOR, this.createIdByScope(USER_PERMISSION_POPUP_SELECTOR));
        this.addChild(UIPopupWindow.class, null, this.createIdByScope(PERMISSION_POPUP_SELECTOR));
    }

    private void removeAllPopupWindow() {
        ArrayList children = new ArrayList(this.getChildren());
        for (UIComponent uichild : children) {
            if (!(uichild instanceof UIPopupWindow)) continue;
            this.removeChild(uichild.getClass());
        }
    }

    private void closeAllPopupAction() {
        ArrayList children = new ArrayList(this.getChildren());
        for (UIComponent uichild : children) {
            if (!(uichild instanceof UIPopupWindow)) continue;
            UIWikiPermissionForm.closePopupAction((UIPopupWindow)uichild);
        }
    }

    private static void closePopupAction(UIPopupWindow uiPopupWindow) {
        uiPopupWindow.setUIComponent(null);
        uiPopupWindow.setShow(false);
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        rcontext.addUIComponentToUpdateByAjax((UIComponent)uiPopupWindow);
    }

    private static void openPopupAction(UIPopupWindow uiPopup, UIComponent component, int width) {
        uiPopup.setUIComponent(component);
        uiPopup.setShow(true);
        uiPopup.setWindowSize(width, 0);
        uiPopup.setResizable(true);
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        rcontext.addUIComponentToUpdateByAjax((UIComponent)uiPopup);
    }

    public void setScope(Scope scope) throws Exception {
        this.scope = scope;
        this.removeAllPopupWindow();
        this.addPopupWindow();
        if (Scope.WIKI.equals((Object)this.scope)) {
            this.accept_Modes = Arrays.asList(WikiMode.VIEW, WikiMode.EDITPAGE, WikiMode.ADDPAGE, WikiMode.VIEWREVISION, WikiMode.SHOWHISTORY, WikiMode.ADVANCEDSEARCH, WikiMode.SPACESETTING);
            this.setActions(new String[]{SAVE});
        } else if (Scope.PAGE.equals((Object)this.scope)) {
            this.accept_Modes = Arrays.asList(WikiMode.VIEW);
            this.setActions(new String[]{SAVE, CLOSE});
        }
    }

    public void setPermission(List<PermissionEntry> permissionEntries) throws Exception {
        this.permissionEntries = permissionEntries;
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.getChild(UIPermissionGrid.class);
        permissionGrid.setPermissionEntries(this.permissionEntries);
    }

    public List<PermissionEntry> convertToPermissionEntryList(HashMap<String, String[]> permissions) {
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        Set<Map.Entry<String, String[]>> entries = permissions.entrySet();
        for (Map.Entry<String, String[]> entry : entries) {
            PermissionEntry permissionEntry = new PermissionEntry();
            String key = entry.getKey();
            IDType idType = IDType.USER;
            if (key.indexOf(":") > 0) {
                idType = IDType.MEMBERSHIP;
            } else if (key.indexOf("/") == 0) {
                idType = IDType.GROUP;
            }
            permissionEntry.setIdType(idType);
            permissionEntry.setId(key);
            Permission[] perms = new Permission[2];
            perms[0] = new Permission();
            perms[0].setPermissionType(PermissionType.VIEWPAGE);
            perms[1] = new Permission();
            perms[1].setPermissionType(PermissionType.EDITPAGE);
            for (String action : entry.getValue()) {
                if ("read".equals(action)) {
                    perms[0].setAllowed(true);
                    continue;
                }
                if (!"add_node".equals(action) && !"remove".equals(action) && !"set_property".equals(action)) continue;
                perms[1].setAllowed(true);
            }
            permissionEntry.setPermissions(perms);
            permissionEntries.add(permissionEntry);
        }
        return permissionEntries;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    private void processPostAction() throws Exception {
        UIPermissionGrid permissionGrid = (UIPermissionGrid)this.getChild(UIPermissionGrid.class);
        ArrayList uiPermissionEntries = new ArrayList();
        permissionGrid.findComponentOfType(uiPermissionEntries, UIWikiPermissionEntry.class);
        ArrayList<PermissionEntry> permEntries = new ArrayList<PermissionEntry>();
        for (UIWikiPermissionEntry uiPermissionEntry : uiPermissionEntries) {
            PermissionEntry permissionEntry = uiPermissionEntry.getPermissionEntry();
            if (!uiPermissionEntry.isImmutable()) {
                Permission[] permissions = permissionEntry.getPermissions();
                for (int i = 0; i < permissions.length; ++i) {
                    UICheckBoxInput checkboxInput = (UICheckBoxInput)uiPermissionEntry.getChildById(permissions[i].getPermissionType().name() + permissionEntry.getId());
                    permissions[i].setAllowed(checkboxInput.isChecked());
                }
            }
            permEntries.add(permissionEntry);
        }
        this.setPermission(permEntries);
    }

    private HashMap<String, String[]> convertToPermissionMap(List<PermissionEntry> permissionEntries) {
        HashMap<String, String[]> permissionMap = new HashMap<String, String[]>();
        for (PermissionEntry permissionEntry : permissionEntries) {
            Permission[] permissions = permissionEntry.getPermissions();
            ArrayList<String> permlist = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                Permission permission = permissions[i];
                if (!permission.isAllowed()) continue;
                if (permission.getPermissionType().equals((Object)PermissionType.VIEWPAGE)) {
                    permlist.add("read");
                    continue;
                }
                if (!permission.getPermissionType().equals((Object)PermissionType.EDITPAGE)) continue;
                permlist.add("add_node");
                permlist.add("remove");
                permlist.add("set_property");
            }
            if (permlist.size() <= 0) continue;
            permissionMap.put(permissionEntry.getId(), permlist.toArray(new String[permlist.size()]));
        }
        return permissionMap;
    }

    public static class CloseActionListener
    extends EventListener<UIWikiPermissionForm> {
        public void execute(Event<UIWikiPermissionForm> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiPermissionForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)wikiPortlet.findFirstComponentOfType(UIWikiPermissionForm.class);
            uiWikiPermissionForm.cancelPopupAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIWikiPermissionForm> {
        public void execute(Event<UIWikiPermissionForm> event) throws Exception {
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)((Object)event.getSource());
            Scope scope = uiWikiPermissionForm.getScope();
            uiWikiPermissionForm.processPostAction();
            if (Scope.WIKI.equals((Object)scope)) {
                WikiService wikiService = (WikiService)uiWikiPermissionForm.getApplicationComponent(WikiService.class);
                WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
                wikiService.setWikiPermission(pageParams.getType(), pageParams.getOwner(), uiWikiPermissionForm.permissionEntries);
                uiWikiPermissionForm.setPermission(wikiService.getWikiPermission(pageParams.getType(), pageParams.getOwner()));
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiPermissionForm.msg.Save-permission-setting-success", null, 2));
            } else if (Scope.PAGE.equals((Object)scope)) {
                PageImpl page = (PageImpl)Utils.getCurrentWikiPage();
                HashMap permissionMap = uiWikiPermissionForm.convertToPermissionMap(uiWikiPermissionForm.permissionEntries);
                page.setPermission(permissionMap);
                page.setOverridePermission(true);
                HashMap pagePermissions = page.getPermission();
                Collection attachments = page.getAttachmentsExcludeContentByRootPermisison();
                HashSet permissionKeys = new HashSet(pagePermissions.keySet());
                for (AttachmentImpl attachment : attachments) {
                    HashMap permissions = attachment.getPermission();
                    Iterator permissionIterator = permissions.entrySet().iterator();
                    while (permissionIterator.hasNext()) {
                        Map.Entry attachmentPermissionEntry = permissionIterator.next();
                        String attachmentPermissionKey = (String)attachmentPermissionEntry.getKey();
                        if (permissionKeys.contains(attachmentPermissionKey)) {
                            permissionKeys.remove(attachmentPermissionKey);
                            continue;
                        }
                        permissionIterator.remove();
                    }
                    for (String permissionEntry : permissionKeys) {
                        permissions.put(permissionEntry, new String[]{"read"});
                    }
                    attachment.setPermission(permissions);
                }
                UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)uiWikiPermissionForm.getAncestorOfType(UIWikiPortlet.class);
                if (page.hasPermission(PermissionType.VIEWPAGE)) {
                    UIWikiPageInfoArea uiWikiPageInfoArea = (UIWikiPageInfoArea)uiWikiPortlet.findFirstComponentOfType(UIWikiPageInfoArea.class);
                    UIWikiPageControlArea uiWikiPageControlArea = (UIWikiPageControlArea)uiWikiPortlet.findFirstComponentOfType(UIWikiPageControlArea.class);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPageControlArea);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPageInfoArea);
                    uiWikiPermissionForm.cancelPopupAction();
                } else {
                    uiWikiPortlet.changeMode(WikiMode.PAGE_NOT_FOUND);
                    event.getRequestContext().getJavascriptManager().addCustomizedOnLoadScript((CharSequence)"eXo.wiki.UIWikiPageNotFound.hidePopup();");
                    Utils.ajaxRedirect(event, Utils.getCurrentWikiPageParams(), WikiMode.PAGE_NOT_FOUND, null);
                }
            }
        }
    }

    public static class CloseUserPopupActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIPopupWindow uiPopup = (UIPopupWindow)((UIUserSelector)event.getSource()).getParent();
            UIWikiPermissionForm.closePopupAction(uiPopup);
        }
    }

    public static class ClosePopupActionListener
    extends UIPopupWindow.CloseActionListener {
        public void execute(Event<UIPopupWindow> event) throws Exception {
            super.execute(event);
            UIWikiPermissionForm.closePopupAction((UIPopupWindow)event.getSource());
        }
    }

    public static class SelectMembershipActionListener
    extends EventListener<UIGroupMembershipSelector> {
        public void execute(Event<UIGroupMembershipSelector> event) throws Exception {
            UIGroupMembershipSelector uiGroupMembershipSelector = (UIGroupMembershipSelector)event.getSource();
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)uiGroupMembershipSelector.getParent().getParent();
            String currentGroup = uiGroupMembershipSelector.getCurrentGroup().getId();
            String membershipId = event.getRequestContext().getRequestParameter("objectId");
            UIFormInputWithActions inputWithActions = (UIFormInputWithActions)uiWikiPermissionForm.getChild(UIFormInputWithActions.class);
            UIFormStringInput uiFormStringInput = (UIFormStringInput)inputWithActions.getChild(UIFormStringInput.class);
            uiFormStringInput.setValue((Object)(membershipId + ":" + currentGroup));
            UIWikiPermissionForm.closePopupAction(uiWikiPermissionForm.getPermissionPopupSelector());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiWikiPermissionForm.getParent());
        }
    }

    public static class OpenSelectMembershipFormActionListener
    extends EventListener<UIWikiPermissionForm> {
        public void execute(Event<UIWikiPermissionForm> event) throws Exception {
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)((Object)event.getSource());
            uiWikiPermissionForm.closeAllPopupAction();
            UIGroupMembershipSelector uiGroupMembershipSelector = (UIGroupMembershipSelector)uiWikiPermissionForm.createUIComponent(UIGroupMembershipSelector.class, null, null);
            UIPopupWindow uiPopup = uiWikiPermissionForm.getPermissionPopupSelector();
            UIWikiPermissionForm.openPopupAction(uiPopup, (UIComponent)uiGroupMembershipSelector, 550);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPermissionForm);
        }
    }

    public static class SelectGroupActionListener
    extends EventListener<UIGroupSelector> {
        public void execute(Event<UIGroupSelector> event) throws Exception {
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)((UIGroupSelector)event.getSource()).getParent().getParent();
            String groupId = event.getRequestContext().getRequestParameter("objectId");
            UIFormInputWithActions inputWithActions = (UIFormInputWithActions)uiWikiPermissionForm.getChild(UIFormInputWithActions.class);
            UIFormStringInput uiFormStringInput = (UIFormStringInput)inputWithActions.getChild(UIFormStringInput.class);
            uiFormStringInput.setValue((Object)("*:" + groupId));
            UIWikiPermissionForm.closePopupAction(uiWikiPermissionForm.getPermissionPopupSelector());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPermissionForm);
        }
    }

    public static class OpenSelectGroupFormActionListener
    extends EventListener<UIWikiPermissionForm> {
        public void execute(Event<UIWikiPermissionForm> event) throws Exception {
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)((Object)event.getSource());
            uiWikiPermissionForm.closeAllPopupAction();
            UIGroupSelector uiGroupSelector = (UIGroupSelector)uiWikiPermissionForm.createUIComponent(UIGroupSelector.class, null, null);
            UIPopupWindow uiPopup = uiWikiPermissionForm.getPermissionPopupSelector();
            UIWikiPermissionForm.openPopupAction(uiPopup, (UIComponent)uiGroupSelector, 550);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPermissionForm);
        }
    }

    public static class SelectUserActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiUserSelector = (UIUserSelector)event.getSource();
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)uiUserSelector.getAncestorOfType(UIWikiPermissionForm.class);
            String values = uiUserSelector.getSelectedUsers();
            UIFormInputWithActions inputWithActions = (UIFormInputWithActions)uiWikiPermissionForm.getChild(UIFormInputWithActions.class);
            UIFormStringInput uiFormStringInput = (UIFormStringInput)inputWithActions.getChild(UIFormStringInput.class);
            uiFormStringInput.setValue((Object)values);
            UIPopupWindow uiPopup = uiWikiPermissionForm.getUserPermissionPopupSelector();
            UIWikiPermissionForm.closePopupAction(uiPopup);
            WebuiRequestContext rcontext = event.getRequestContext();
            rcontext.addUIComponentToUpdateByAjax(uiWikiPermissionForm.getChildById(UIWikiPermissionForm.WIKI_PERMISSION_OWNER));
        }
    }

    public static class OpenSelectUserFormActionListener
    extends EventListener<UIWikiPermissionForm> {
        public void execute(Event<UIWikiPermissionForm> event) throws Exception {
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)((Object)event.getSource());
            uiWikiPermissionForm.closeAllPopupAction();
            UIPopupWindow uiPopup = uiWikiPermissionForm.getUserPermissionPopupSelector();
            UIWikiPortlet portlet = (UIWikiPortlet)uiWikiPermissionForm.getAncestorOfType(UIWikiPortlet.class);
            UIUserSelector uiUserSelector = (UIUserSelector)portlet.findFirstComponentOfType(UIUserSelector.class);
            if (uiUserSelector != null) {
                ((UIPopupWindow)uiUserSelector.getParent()).setUIComponent(null);
            }
            uiUserSelector = (UIUserSelector)uiWikiPermissionForm.createUIComponent(UIUserSelector.class, null, null);
            uiUserSelector.setShowSearch(true);
            uiUserSelector.setShowSearchUser(true);
            uiUserSelector.setShowSearchGroup(false);
            UIWikiPermissionForm.openPopupAction(uiPopup, (UIComponent)uiUserSelector, 650);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWikiPermissionForm);
        }
    }

    public static class DeleteEntryActionListener
    extends EventListener<UIWikiPermissionForm> {
        public void execute(Event<UIWikiPermissionForm> event) throws Exception {
            String objectId;
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)((Object)event.getSource());
            UIWikiPermissionEntry uiPermissionEntry = (UIWikiPermissionEntry)uiWikiPermissionForm.findComponentById(objectId = event.getRequestContext().getRequestParameter("objectId"));
            if (!uiPermissionEntry.isImmutable()) {
                uiWikiPermissionForm.permissionEntries.remove(uiPermissionEntry.getPermissionEntry());
            }
            uiWikiPermissionForm.setPermission(uiWikiPermissionForm.permissionEntries);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiWikiPermissionForm.getChild(UIPermissionGrid.class));
        }
    }

    public static class AddEntryActionListener
    extends EventListener<UIWikiPermissionForm> {
        public void execute(Event<UIWikiPermissionForm> event) throws Exception {
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)((Object)event.getSource());
            uiWikiPermissionForm.processPostAction();
            Scope scope = uiWikiPermissionForm.getScope();
            UIFormInputWithActions inputWithActions = (UIFormInputWithActions)uiWikiPermissionForm.getChild(UIFormInputWithActions.class);
            UIFormStringInput uiFormStringInput = (UIFormStringInput)inputWithActions.getChild(UIFormStringInput.class);
            String permissionOwner = (String)uiFormStringInput.getValue();
            if (permissionOwner != null && permissionOwner.length() > 0) {
                Object[] msgArg;
                String[] entries;
                OrganizationService service = (OrganizationService)uiWikiPermissionForm.getApplicationComponent(OrganizationService.class);
                StringBuilder notExistIds = new StringBuilder();
                StringBuilder duplicateIds = new StringBuilder();
                String[] arr$ = entries = permissionOwner.split(",");
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String entry;
                    IDType idType = (entry = arr$[i$]).startsWith("/") ? IDType.GROUP : (entry.contains(":") ? IDType.MEMBERSHIP : IDType.USER);
                    if (this.isExistId(entry, idType, service)) {
                        if (this.isNotExistEntry(entry, uiWikiPermissionForm.permissionEntries)) {
                            PermissionEntry permissionEntry = new PermissionEntry();
                            Permission[] permissions = null;
                            if (Scope.WIKI.equals((Object)scope)) {
                                permissions = new Permission[4];
                                permissions[0] = new Permission();
                                permissions[0].setPermissionType(PermissionType.VIEWPAGE);
                                permissions[0].setAllowed(true);
                                permissions[1] = new Permission();
                                permissions[1].setPermissionType(PermissionType.EDITPAGE);
                                permissions[2] = new Permission();
                                permissions[2].setPermissionType(PermissionType.ADMINPAGE);
                                permissions[3] = new Permission();
                                permissions[3].setPermissionType(PermissionType.ADMINSPACE);
                            } else if (Scope.PAGE.equals((Object)scope)) {
                                permissions = new Permission[2];
                                permissions[0] = new Permission();
                                permissions[0].setPermissionType(PermissionType.VIEWPAGE);
                                permissions[0].setAllowed(true);
                                permissions[1] = new Permission();
                                permissions[1].setPermissionType(PermissionType.EDITPAGE);
                            }
                            permissionEntry.setPermissions(permissions);
                            permissionEntry.setId(entry);
                            permissionEntry.setIdType(idType);
                            uiWikiPermissionForm.permissionEntries.add(permissionEntry);
                            continue;
                        }
                        if (duplicateIds.length() == 0) {
                            duplicateIds.append(entry);
                            continue;
                        }
                        duplicateIds.append(", ").append(entry);
                        continue;
                    }
                    if (notExistIds.length() == 0) {
                        notExistIds.append(entry);
                        continue;
                    }
                    notExistIds.append(", ").append(entry);
                }
                if (notExistIds.length() > 0) {
                    msgArg = new String[]{notExistIds.toString()};
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiPermissionForm.msg.NonExistID", msgArg, 1));
                }
                if (duplicateIds.length() > 0) {
                    msgArg = new String[]{duplicateIds.toString()};
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiPermissionForm.msg.duplicate-id", msgArg, 1));
                }
            }
            uiFormStringInput.setValue(null);
            uiWikiPermissionForm.setPermission(uiWikiPermissionForm.permissionEntries);
            WebuiRequestContext rcontext = event.getRequestContext();
            rcontext.addUIComponentToUpdateByAjax(uiWikiPermissionForm.getChild(UIPermissionGrid.class));
            rcontext.addUIComponentToUpdateByAjax((UIComponent)inputWithActions);
        }

        private boolean isExistId(String identityId, IDType idType, OrganizationService service) throws Exception {
            if (idType == IDType.USER) {
                if (UIWikiPermissionForm.ANY.equalsIgnoreCase(identityId) || UIWikiPermissionForm.ROOT.equalsIgnoreCase(identityId)) {
                    return true;
                }
                return service.getUserHandler().findUserByName(identityId) != null;
            }
            if (idType == IDType.GROUP) {
                return service.getGroupHandler().findGroupById(identityId) != null;
            }
            String[] membership = identityId.split(":");
            Group group = service.getGroupHandler().findGroupById(membership[1]);
            if (group == null) {
                return false;
            }
            if ("*".equals(membership[0])) {
                return true;
            }
            return service.getMembershipTypeHandler().findMembershipType(membership[0]) != null;
        }

        private boolean isNotExistEntry(String entry, List<PermissionEntry> entries) {
            for (PermissionEntry permEntry : entries) {
                if (!entry.equals(permEntry.getId())) continue;
                return false;
            }
            return true;
        }
    }

    public static enum Scope {
        WIKI,
        PAGE;

    }
}

