/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIFieldEditableForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.UIWikiExtensionContainer;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPageTitleControlArea.gtmpl")
public class UIWikiPageTitleControlArea
extends UIWikiExtensionContainer {
    public static final String EXTENSION_TYPE = "org.exoplatform.wiki.webui.UIWikiPageTitleControlArea";
    public static final String FIELD_TITLEINFO = "titleInfo";
    public static final String FIELD_TITLEINPUT = "titleInput";
    public static final String FIELD_EDITABLE = "editable";
    public static final String CHANGE_TITLEMODE = "changeTitleMode";

    public UIWikiPageTitleControlArea() throws Exception {
        UIFormInputInfo titleInfo = new UIFormInputInfo(FIELD_TITLEINFO, FIELD_TITLEINFO, FIELD_TITLEINFO);
        titleInfo.setRendered(true);
        this.addChild((UIComponent)titleInfo);
        UIFormStringInput titleInput = new UIFormStringInput(FIELD_TITLEINPUT, FIELD_TITLEINPUT, FIELD_TITLEINPUT);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        titleInput.setHTMLAttribute("title", res.getString("UIWikiPageTitleControlArea.label.title"));
        titleInput.setRendered(false);
        this.addChild((UIComponent)titleInput);
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        if (!context.useAjax()) {
            UIFieldEditableForm fieldEditableForm;
            WikiMode currentMode;
            UIFormInputInfo titleInfo = (UIFormInputInfo)this.getChild(UIFormInputInfo.class);
            List<WikiMode> acceptEdiableModes = Arrays.asList(WikiMode.VIEW, WikiMode.HELP, WikiMode.VIEWREVISION);
            if (acceptEdiableModes.contains((Object)(currentMode = ((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getWikiMode()))) {
                titleInfo.setRendered(true);
            }
            if ((fieldEditableForm = (UIFieldEditableForm)this.getChild(UIFieldEditableForm.class)) != null) {
                fieldEditableForm.hideTitleInputBox();
            }
        }
        super.processRender(context);
    }

    @Override
    public String getExtensionType() {
        return EXTENSION_TYPE;
    }

    public UIFormInputInfo getUIFormInputInfo() {
        return (UIFormInputInfo)this.findComponentById(FIELD_TITLEINFO);
    }

    public UIFormStringInput getUIStringInput() {
        return (UIFormStringInput)this.findComponentById(FIELD_TITLEINPUT);
    }

    public void toInfoMode() {
        this.findComponentById(FIELD_TITLEINFO).setRendered(true);
        this.findComponentById(FIELD_TITLEINPUT).setRendered(false);
    }

    public void toInputMode() {
        this.findComponentById(FIELD_TITLEINFO).setRendered(false);
        this.findComponentById(FIELD_TITLEINPUT).setRendered(true);
    }

    public boolean isInfoMode() {
        return this.getChildById(FIELD_TITLEINFO).isRendered();
    }

    public void saveTitle(String newTitle, Event event) throws Exception {
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
        String newName = TitleResolver.getId((String)newTitle, (boolean)true);
        Page page = Utils.getCurrentWikiPage();
        boolean isRenameHome = "WikiHome".equals(page.getName()) && !newName.equals(pageParams.getPageName());
        page.setMinorEdit(false);
        if (isRenameHome) {
            page.setTitle(newTitle);
            wikiService.updatePage(page, PageUpdateType.EDIT_PAGE_TITLE);
        } else {
            wikiService.renamePage(pageParams.getType(), pageParams.getOwner(), pageParams.getPageName(), newName, newTitle);
            page.setName(newName);
            page.setTitle(newTitle);
            pageParams.setPageName(newName);
            page.setUrl(Utils.getURLFromParams(pageParams));
            wikiService.updatePage(page, PageUpdateType.EDIT_PAGE_TITLE);
        }
        Utils.redirect(pageParams, WikiMode.VIEW);
    }

    protected boolean isAddMode() {
        WikiMode currentMode = ((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getWikiMode();
        return currentMode.equals((Object)WikiMode.ADDPAGE);
    }

    public String getTitle() {
        return (String)((UIFormStringInput)this.getChild(UIFormStringInput.class)).getValue();
    }
}

