/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.webui.UIWikiAdvanceSearchForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.core.UIAdvancePageIterator;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiAdvanceSearchResult.gtmpl", events={@EventConfig(listeners={ChangeMaxSizePageActionListener.class})})
public class UIWikiAdvanceSearchResult
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIWikiAdvanceSearchResult.class);
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
    private PageList<SearchResult> results;

    public UIWikiAdvanceSearchResult() throws Exception {
        this.addChild(UIAdvancePageIterator.class, null, "SearchResultPageIterator");
    }

    public PageList<SearchResult> getResults() {
        return this.results;
    }

    public void setResults(PageList<SearchResult> results) {
        this.results = results;
    }

    public int getItemsPerPage() {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)wikiPortlet.findFirstComponentOfType(UIWikiAdvanceSearchForm.class);
        return advanceSearchForm.getItemPerPage();
    }

    public String getKeyword() {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)wikiPortlet.findFirstComponentOfType(UIWikiAdvanceSearchForm.class);
        return advanceSearchForm.getKeyword();
    }

    protected String getDateFormat(Calendar cal) throws Exception {
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 3, currentLocale);
        return df.format(cal.getTime());
    }

    protected Page getPage(SearchResult result) {
        try {
            return this.wikiService.getPageOfWikiByName(result.getWikiType(), result.getWikiOwner(), result.getPageName());
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot page for search result " + result.getWikiType() + ":" + result.getWikiOwner() + ":" + result.getPageName()));
            return null;
        }
    }

    protected String getOldPageTitleInSearchResult(Page page, String pageTitle) throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)wikiPortlet.findFirstComponentOfType(UIWikiAdvanceSearchForm.class);
        String keyword = advanceSearchForm.getKeyword();
        if (pageTitle.indexOf(keyword) >= 0) {
            return "";
        }
        List previousNames = this.wikiService.getPreviousNamesOfPage(page);
        if (previousNames != null) {
            for (String name : previousNames) {
                if (name.indexOf(keyword) < 0) continue;
                return UIWikiAdvanceSearchResult.replaceUnderscorebySpace(name);
            }
        }
        return "";
    }

    protected static String replaceUnderscorebySpace(String s) {
        StringTokenizer st = new StringTokenizer(s, "_", false);
        StringBuilder sb = new StringBuilder();
        if (st.hasMoreElements()) {
            sb.append(st.nextElement());
        }
        while (st.hasMoreElements()) {
            sb.append(" ").append(st.nextElement());
        }
        return sb.toString();
    }

    public static class ChangeMaxSizePageActionListener
    extends EventListener<UIWikiAdvanceSearchResult> {
        public void execute(Event<UIWikiAdvanceSearchResult> event) throws Exception {
            UIWikiAdvanceSearchResult uisearch = (UIWikiAdvanceSearchResult)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)uisearch.getAncestorOfType(UIWikiPortlet.class);
            UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)wikiPortlet.findFirstComponentOfType(UIWikiAdvanceSearchForm.class);
            int itemsPerPage = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            advanceSearchForm.setItemsPerPage(itemsPerPage);
            advanceSearchForm.gotoSearchPage(1);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uisearch);
        }
    }
}

