/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.commons.EventUIComponent;
import org.exoplatform.webui.commons.UISpacesSwitcher;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.UIWikiLocationContainer;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.tree.UITreeExplorer;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/popup/UIWikiMovePageForm.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={MoveActionListener.class}), @EventConfig(listeners={SwitchSpaceActionListener.class}), @EventConfig(listeners={RenameActionListener.class})})
public class UIWikiMovePageForm
extends UIForm
implements UIPopupComponent {
    public static final String PAGENAME_INFO = "pageNameInfo";
    public static final String LOCATION_CONTAINER = "UIWikiLocationContainer";
    public static final String UITREE = "UIMoveTree";
    public String MOVE = "Move";
    private static final String MOVE_PAGE_CONTAINER = "UIWikiMovePageForm";
    private static final String SWITCH_SPACE_ACTION = "SwitchSpace";
    protected static final String SPACE_SWITCHER = "uiSpaceSwitcher_UIWikiMovePageForm";
    private static final String RENAME_ACTION = "Rename";
    private List<PageInfo> duplicatedPages;
    private PageInfo pageToMove;

    public UIWikiMovePageForm() throws Exception {
        this.addChild((UIComponent)new UIFormInputInfo(PAGENAME_INFO, PAGENAME_INFO, null));
        this.addChild(UIWikiLocationContainer.class, null, LOCATION_CONTAINER);
        UITreeExplorer uiTree = (UITreeExplorer)this.addChild(UITreeExplorer.class, null, UITREE);
        EventUIComponent eventComponent = new EventUIComponent(LOCATION_CONTAINER, "ChangeNewLocation", EventUIComponent.EVENTTYPE.EVENT);
        StringBuilder initURLSb = new StringBuilder(Utils.getCurrentRestURL());
        initURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.ALL.toString());
        StringBuilder childrenURLSb = new StringBuilder(Utils.getCurrentRestURL());
        childrenURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.CHILDREN.toString());
        uiTree.init(initURLSb.toString(), childrenURLSb.toString(), this.getInitParam(URLEncoder.encode(Utils.getCurrentWikiPagePath(), "utf-8")), eventComponent, false);
        UISpacesSwitcher uiWikiSpaceSwitcher = (UISpacesSwitcher)this.addChild(UISpacesSwitcher.class, null, SPACE_SWITCHER);
        uiWikiSpaceSwitcher.setCurrentSpaceName(Utils.upperFirstCharacter(Utils.getCurrentSpaceName()));
        uiWikiSpaceSwitcher.setAutoResize(true);
        uiWikiSpaceSwitcher.setAppId("Wiki");
        EventUIComponent eventComponent1 = new EventUIComponent(MOVE_PAGE_CONTAINER, SWITCH_SPACE_ACTION, EventUIComponent.EVENTTYPE.EVENT);
        uiWikiSpaceSwitcher.init(eventComponent1);
    }

    protected String createDuplicatedPageNotification() throws Exception {
        if (this.duplicatedPages == null || this.duplicatedPages.isEmpty()) {
            return "";
        }
        ResourceBundle bundle = RequestContext.getCurrentInstance().getApplicationResourceBundle();
        StringBuilder notifications = new StringBuilder();
        int maxWarning = 5;
        if (this.duplicatedPages.get(0).getName().equals(this.pageToMove.getName())) {
            maxWarning = 6;
        }
        String dupplicatedParentMessage = bundle.getString("UIWikiMovePageForm.msg.main-page-duplicate");
        String dupplicatedChildMessage = bundle.getString("UIWikiMovePageForm.msg.sub-page-duplicate");
        String renameParentTooltip = bundle.getString("UIWikiMovePageForm.label.rename-main-page");
        String renameChildTooltip = bundle.getString("UIWikiMovePageForm.label.rename-sub-page");
        String renameActionLabel = bundle.getString("UIWikiMovePageForm.action.Rename");
        for (int i = 0; i < Math.min(this.duplicatedPages.size(), maxWarning); ++i) {
            PageInfo page = this.duplicatedPages.get(i);
            String message = dupplicatedChildMessage;
            String tooltip = renameChildTooltip;
            if (this.pageToMove.getName().equals(page.getName())) {
                message = dupplicatedParentMessage;
                tooltip = renameParentTooltip;
            }
            String messageHTML = "<div class='alert'> <i class='uiIconWarning'></i>" + message + "</div>";
            String renameActionLink = this.event(RENAME_ACTION, page.getName());
            if (this.pageToMove.getName().equals(page.getName())) {
                messageHTML = messageHTML.replace("{0}", "<a title='" + tooltip + "' href=\"" + renameActionLink + "\">" + renameActionLabel + "</a>");
            } else {
                messageHTML = messageHTML.replace("{0}", page.getTitle());
                messageHTML = messageHTML.replace("{1}", "<a title='" + tooltip + "' href=\"" + renameActionLink + "\">" + renameActionLabel + "</a>");
            }
            notifications.append(messageHTML);
        }
        if (this.duplicatedPages.size() > maxWarning) {
            String andMoreLabel = bundle.getString("UIWikiMovePageForm.msg.and-more");
            andMoreLabel = "<div class='alert'> <i class='uiIconWarning'></i>" + andMoreLabel + "</div>";
            notifications.append(andMoreLabel);
        }
        return "<div class='box'>" + notifications.toString() + "</div>";
    }

    public List<PageInfo> getDupplicatedPages() {
        return this.duplicatedPages;
    }

    public void setDupplicatedPages(List<PageInfo> dupplicatedPages) {
        this.duplicatedPages = dupplicatedPages;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    private String getInitParam(String currentPath) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("?").append("path").append("=").append(currentPath).append("&").append("page").append("=").append(currentPath);
        return sb.toString();
    }

    public static class RenameActionListener
    extends EventListener<UIWikiMovePageForm> {
        public void execute(Event<UIWikiMovePageForm> event) throws Exception {
            Wiki currentWiki;
            String pageId = event.getRequestContext().getRequestParameter("objectId");
            UIWikiMovePageForm uiWikiMovePageForm = (UIWikiMovePageForm)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)uiWikiMovePageForm.getAncestorOfType(UIWikiPortlet.class);
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            Page pageToRename = wikiService.getPageOfWikiByName((currentWiki = Utils.getCurrentWiki()).getType(), currentWiki.getOwner(), pageId);
            if (pageToRename == null) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiMovePageForm.msg.page-not-exist=", null, 1));
                return;
            }
            WikiPageParams targetParam = new WikiPageParams(currentWiki.getType(), currentWiki.getOwner(), pageToRename.getName());
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            String title = pageToRename.getTitle();
            String content = pageToRename.getContent();
            titleInput.setEditable(true);
            titleInput.setValue((Object)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)title));
            pageEditForm.setTitle(title);
            markupInput.setValue((Object)content);
            UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class);
            if (wikiRichTextArea.isRendered()) {
                Utils.feedDataForWYSIWYGEditor(pageEditForm, null);
            }
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
            wikiPortlet.changeMode(WikiMode.EDITPAGE);
            Utils.ajaxRedirect(event, targetParam, WikiMode.EDITPAGE, null);
        }
    }

    public static class SwitchSpaceActionListener
    extends EventListener<UIWikiMovePageForm> {
        public void execute(Event<UIWikiMovePageForm> event) throws Exception {
            String wikiId = event.getRequestContext().getRequestParameter("spaceId");
            UIWikiMovePageForm uiWikiMovePageForm = (UIWikiMovePageForm)((Object)event.getSource());
            UISpacesSwitcher uiWikiSpaceSwitcher = (UISpacesSwitcher)uiWikiMovePageForm.getChildById(UIWikiMovePageForm.SPACE_SWITCHER);
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            Wiki wiki = wikiService.getWikiById(wikiId);
            if (wiki == null) {
                wiki = wikiService.createWiki(Utils.getWikiTypeFromWikiId(wikiId), Utils.getWikiOwnerFromWikiId(wikiId));
            }
            Page wikiHome = wiki.getWikiHome();
            WikiPageParams params = new WikiPageParams(wiki.getType(), wiki.getOwner(), wikiHome.getName());
            uiWikiSpaceSwitcher.setCurrentSpaceName(Utils.upperFirstCharacter(wikiService.getWikiNameById(wikiId)));
            UITreeExplorer uiTree = (UITreeExplorer)uiWikiMovePageForm.getChildById(UIWikiMovePageForm.UITREE);
            StringBuilder initParams = new StringBuilder();
            initParams.append("?").append("path").append("=").append(TreeUtils.getPathFromPageParams((WikiPageParams)params)).append("&").append("page").append("=").append(Utils.getCurrentWikiPagePath());
            uiTree.setInitParam(initParams.toString());
            UIWikiLocationContainer uiWikiLocationContainer = (UIWikiLocationContainer)uiWikiMovePageForm.getChild(UIWikiLocationContainer.class);
            UIWikiBreadCrumb newlocation = (UIWikiBreadCrumb)uiWikiLocationContainer.getChildById("newLocation");
            newlocation.setBreadCumbs(wikiService.getBreadcumb(params.getType(), params.getOwner(), params.getPageName()));
            event.getRequestContext().addUIComponentToUpdateByAjax(uiWikiMovePageForm.getParent());
        }
    }

    public static class MoveActionListener
    extends EventListener<UIWikiMovePageForm> {
        public void execute(Event<UIWikiMovePageForm> event) throws Exception {
            boolean isMoved;
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)((UIWikiMovePageForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiMovePageForm movePageForm = (UIWikiMovePageForm)((Object)event.getSource());
            UIWikiLocationContainer locationContainer = (UIWikiLocationContainer)movePageForm.findFirstComponentOfType(UIWikiLocationContainer.class);
            UIWikiBreadCrumb currentLocation = (UIWikiBreadCrumb)locationContainer.getChildById("currentLocation");
            UIWikiBreadCrumb newLocation = (UIWikiBreadCrumb)locationContainer.getChildById("newLocation");
            WikiPageParams currentLocationParams = currentLocation.getPageParam();
            WikiPageParams newLocationParams = newLocation.getPageParam();
            if (newLocationParams == null) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiMovePageForm.msg.new-location-can-not-be-empty", null, 1));
                return;
            }
            Page movepage = wservice.getPageOfWikiByName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName());
            if (!currentLocationParams.getType().equals(newLocationParams.getType()) || !currentLocationParams.getOwner().equals(newLocationParams.getOwner())) {
                List duplicatedPageList = wservice.getDuplicatePages(movepage, wservice.getWikiByTypeAndOwner(newLocationParams.getType(), newLocationParams.getOwner()), null);
                movePageForm.duplicatedPages = new ArrayList();
                for (Page page : duplicatedPageList) {
                    List list = movePageForm.duplicatedPages;
                    UIWikiMovePageForm uIWikiMovePageForm = movePageForm;
                    ((Object)((Object)uIWikiMovePageForm)).getClass();
                    list.add(uIWikiMovePageForm.new PageInfo(page));
                }
                if (movePageForm.duplicatedPages.size() > 0) {
                    UIWikiMovePageForm uIWikiMovePageForm = movePageForm;
                    ((Object)((Object)uIWikiMovePageForm)).getClass();
                    movePageForm.pageToMove = uIWikiMovePageForm.new PageInfo(movepage);
                    return;
                }
            }
            if (!(isMoved = wservice.movePage(currentLocationParams, newLocationParams))) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiMovePageForm.msg.no-permission-at-destination", null, 1));
                return;
            }
            movepage.setUrl(Utils.getURLFromParams(newLocationParams));
            UIPopupContainer popupContainer = uiWikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
            newLocationParams.setPageName(currentLocationParams.getPageName());
            String permalink = org.exoplatform.wiki.utils.Utils.getPermanlink((WikiPageParams)newLocationParams, (boolean)false);
            Utils.redirect(permalink);
            RequireJS requireJS = event.getRequestContext().getJavascriptManager().getRequireJS();
            requireJS.require("SHARED/UITreeExplorer", "UITreeExplorer").addScripts("UITreeExplorer.setMovePage(false); ");
        }
    }

    public static class CloseActionListener
    extends EventListener<UIWikiMovePageForm> {
        public void execute(Event<UIWikiMovePageForm> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiMovePageForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
            RequireJS requireJS = event.getRequestContext().getJavascriptManager().getRequireJS();
            requireJS.require("SHARED/UITreeExplorer", "UITreeExplorer").addScripts("UITreeExplorer.setMovePage(false); ");
        }
    }

    class PageInfo {
        private String name;
        private String title;

        public PageInfo(Page page) {
            this.name = page.getName();
            this.title = page.getTitle();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

