/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.filter;

import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webui.ext.filter.UIExtensionAbstractFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;

public class RemoveAttachmentPermissionFilter
extends UIExtensionAbstractFilter {
    public static final String ATTACHMENT_KEY = "attachmentName";
    private WikiService wikiService = (WikiService)CommonsUtils.getService(WikiService.class);

    public RemoveAttachmentPermissionFilter() {
        this(null);
    }

    public RemoveAttachmentPermissionFilter(String messageKey) {
        super(messageKey, UIExtensionFilterType.MANDATORY);
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
        if (pageParams == null) {
            return false;
        }
        if (pageParams.getOwner() == null || pageParams.getPageName() == null || pageParams.getType() == null) {
            return false;
        }
        Page page = this.wikiService.getPageOfWikiByName(pageParams.getType(), pageParams.getOwner(), pageParams.getPageName());
        if (page == null) {
            return false;
        }
        if (ConversationState.getCurrent() == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent() is null");
        }
        if (ConversationState.getCurrent().getIdentity() == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent().getIdentity() is null");
        }
        return this.wikiService.hasPermissionOnPage(page, PermissionType.EDITPAGE, ConversationState.getCurrent().getIdentity());
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }
}

