/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.RemoveAttachmentActionComponent;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiAttachmentUploadListForm.gtmpl")
public class UIWikiAttachmentUploadListForm
extends UIForm {
    private static final Log log = ExoLogger.getLogger((String)"org.exoplatform.wiki.webui.control.UIAttachmentUploadContainer");
    public static final String DOWNLOAD_ACTION = "DownloadAttachment";
    public static final String EXTENSION_TYPE = "org.exoplatform.wiki.webui.UIWikiAttachmentUploadListForm";
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public UIWikiAttachmentUploadListForm() throws Exception {
        this.addChild(RemoveAttachmentActionComponent.class, null, null);
    }

    protected Collection<Attachment> getAttachments() {
        List<Object> attachments = new ArrayList<Attachment>();
        try {
            Page page = this.getCurrentWikiPage();
            if (page != null) {
                attachments = this.wikiService.getAttachmentsOfPage(page);
            }
        }
        catch (Exception e) {
            log.warn((Object)"An error happened when get attachments list", (Throwable)e);
        }
        return attachments;
    }

    public Page getCurrentWikiPage() throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        if (wikiPortlet.getWikiMode() == WikiMode.ADDPAGE) {
            return Utils.getCurrentNewDraftWikiPage();
        }
        return Utils.getCurrentWikiPage();
    }

    protected void renderActions(Attachment attachment) throws Exception {
        if (attachment == null || attachment.getName() == null) {
            return;
        }
        RemoveAttachmentActionComponent component = (RemoveAttachmentActionComponent)this.getChild(RemoveAttachmentActionComponent.class);
        component.setAttachmentName(attachment.getName());
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        HashMap<String, Attachment> context = new HashMap<String, Attachment>();
        context.put("attachmentName", attachment);
        if (manager.accept(EXTENSION_TYPE, "RemoveAttachment", context)) {
            this.renderChild(RemoveAttachmentActionComponent.class);
        }
    }
}

