/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.webui.UIWikiPermissionForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.control.action.core.AbstractEventActionComponent;
import org.exoplatform.wiki.webui.control.filter.IsViewModeFilter;
import org.exoplatform.wiki.webui.control.filter.OwnerPagesOrAdminSpacePermissionFilter;
import org.exoplatform.wiki.webui.control.listener.MoreContainerActionListener;

@ComponentConfig(template="app:/templates/wiki/webui/control/action/AbstractActionComponent.gtmpl", events={@EventConfig(listeners={PagePermissionActionListener.class})})
public class PagePermissionActionComponent
extends AbstractEventActionComponent {
    public static final String ACTION = "PagePermission";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsViewModeFilter(), new OwnerPagesOrAdminSpacePermissionFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    @Override
    public String getActionName() {
        return ACTION;
    }

    @Override
    public boolean isAnchor() {
        return false;
    }

    public static class PagePermissionActionListener
    extends MoreContainerActionListener<PagePermissionActionComponent> {
        @Override
        protected void processEvent(Event<PagePermissionActionComponent> event) throws Exception {
            UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)((PagePermissionActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer uiPopupContainer = uiWikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)uiPopupContainer.createUIComponent(UIWikiPermissionForm.class, null, "UIWikiPagePermissionForm");
            uiPopupContainer.activate((UIComponent)uiWikiPermissionForm, 800, 0);
            uiWikiPermissionForm.setScope(UIWikiPermissionForm.Scope.PAGE);
            Page page = Utils.getCurrentWikiPage();
            List permissionEntries = page.getPermissions();
            uiWikiPermissionForm.setPermission(permissionEntries);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
            super.processEvent(event);
        }
    }
}

