/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.control.filter.IsUserFilter;
import org.exoplatform.wiki.webui.control.filter.IsViewModeFilter;
import org.exoplatform.wiki.webui.control.listener.MoreContainerActionListener;

@ComponentConfig(template="app:/templates/wiki/webui/control/action/WatchPageActionComponent.gtmpl", events={@EventConfig(listeners={WatchPageActionListener.class})})
public class WatchPageActionComponent
extends UIComponent {
    protected static final String WATCH_PAGE = "WatchPage";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsUserFilter(), new IsViewModeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public boolean detectWatched(boolean isChangeState) throws Exception {
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        ConversationState conversationState = ConversationState.getCurrent();
        String currentUserId = conversationState.getIdentity().getUserId();
        Page currentPage = Utils.getCurrentWikiPage();
        boolean isWatched = false;
        List watchers = wikiService.getWatchersOfPage(currentPage);
        for (String watcher : watchers) {
            if (!watcher.equals(currentUserId)) continue;
            isWatched = true;
        }
        if (isChangeState) {
            if (isWatched) {
                wikiService.deleteWatcherOfPage(currentUserId, currentPage);
            } else {
                wikiService.addWatcherToPage(currentUserId, currentPage);
            }
        }
        return isWatched;
    }

    public static class WatchPageActionListener
    extends MoreContainerActionListener<WatchPageActionComponent> {
        @Override
        protected void processEvent(Event<WatchPageActionComponent> event) throws Exception {
            boolean isWatched = ((WatchPageActionComponent)((Object)event.getSource())).detectWatched(true);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((WatchPageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)wikiPortlet);
            if (isWatched) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("WatchPageAction.msg.Stop-watching", null, 2));
            } else {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("WatchPageAction.msg.Start-watching", null, 2));
            }
            super.processEvent(event);
        }
    }
}

