/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import generated.GroupInfo;
import generated.Memberships;
import generated.Users;
import java.util.Collection;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.rest.OrganizationServiceHelper;
import org.exoplatform.services.organization.rest.xml.JAXBTransformUtil;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryTemplate;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.JAXBInputTransformer;
import org.exoplatform.services.rest.transformer.JAXBOutputTransformer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;

@URITemplate(value="/organization/xml/")
public class RESTOrganizationServiceXMLImpl
implements ResourceContainer {
    protected static final String XML_CONTENT_TYPE = "text/xml";
    private OrganizationServiceHelper helper;

    public RESTOrganizationServiceXMLImpl(OrganizationService organizationService) {
        this.helper = new OrganizationServiceHelper(organizationService);
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/newgroup/")
    @InputTransformer(value=JAXBInputTransformer.class)
    public Response createGroup(@ContextParam(value="baseURI") String baseURI, generated.Group groupJAXB) {
        String description;
        String label;
        String parentId = "/exo";
        String groupName = groupJAXB.getName();
        Group group = this.helper.createGroup(parentId, groupName, label = groupJAXB.getLabel(), description = groupJAXB.getDescription());
        if (group != null) {
            return Response.Builder.created((String)(baseURI + "/organization/xml/group/" + group.getId())).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Create group failed!").build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/newmembership/")
    @InputTransformer(value=JAXBInputTransformer.class)
    public Response createMembership(@ContextParam(value="baseURI") String baseURI, generated.Membership membershipJAXB) {
        String type;
        String groupId;
        String username = membershipJAXB.getUserName();
        Membership membership = this.helper.createMembership(username, groupId = membershipJAXB.getGroupId(), type = membershipJAXB.getMembershipType());
        if (membership != null) {
            return Response.Builder.created((String)(baseURI + "/organization/xml/membership/" + membership.getId())).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Create group failed!").build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/newuser/")
    @InputTransformer(value=JAXBInputTransformer.class)
    public Response createUser(@ContextParam(value="baseURI") String baseURI, generated.User userJAXB) {
        String email;
        String lastname;
        String firstname;
        String password;
        String username = userJAXB.getUserName();
        User user = this.helper.createUser(username, password = userJAXB.getPassword(), firstname = userJAXB.getFirstName(), lastname = userJAXB.getLastName(), email = userJAXB.getEmail());
        if (user != null) {
            return Response.Builder.created((String)(baseURI + "/organization/xml/user/" + user.getUserName())).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Create user failed!").build();
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=delete")
    @URITemplate(value="/group/{groupId}/")
    public Response deleteGroup(@URIParam(value="groupId") String groupId) {
        if (this.helper.deleteGroupd(groupId)) {
            return Response.Builder.noContent().build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Delete group failed!").build();
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=delete")
    @URITemplate(value="/membership/{membershipId}/")
    public Response deleteMembership(@URIParam(value="membershipId") String membershipId) {
        if (this.helper.deleteGroupd(membershipId)) {
            return Response.Builder.noContent().build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Delete membership failed!").build();
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=delete")
    @URITemplate(value="/user/{username}/")
    public Response deleteUser(@URIParam(value="username") String username) {
        if (this.helper.deleteUser(username)) {
            return Response.Builder.noContent().build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Delete user failed!").build();
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=delete")
    @URITemplate(value="/groups/{username}/{groupId}/")
    public Response deleteUserFromGroup(@URIParam(value="groupId") String groupId, @URIParam(value="username") String username) {
        if (this.helper.deleteUserFromGroup(username, groupId)) {
            return Response.Builder.noContent().build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Delete user " + username + " from group " + groupId + " failed!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/{membershipId}/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response findMembership(@URIParam(value="membershipId") String membershipId) {
        try {
            Membership membership = this.helper.findMembership(membershipId);
            if (membership != null) {
                return Response.Builder.ok((Object)JAXBTransformUtil.membershipToMembershipJAXB(membership), (String)XML_CONTENT_TYPE).build();
            }
            return Response.Builder.notFound().errorMessage("Membership with id: '" + membershipId + "' not found!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Find membership failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/memberships/")
    @InputTransformer(value=JAXBInputTransformer.class)
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response findMemberships(generated.Membership membershipJAXB) {
        try {
            Collection<Membership> collection = this.helper.findMemberships(JAXBTransformUtil.membershipJAXBToMembership(membershipJAXB));
            if (collection != null) {
                Memberships memberships = JAXBTransformUtil.collectionMembershipToMembershipsJAXB(collection);
                return Response.Builder.ok((Object)memberships, (String)XML_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Find memberships failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/userlike/")
    @InputTransformer(value=JAXBInputTransformer.class)
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response findUsers(generated.User userJAXB) {
        try {
            Users users = JAXBTransformUtil.collectionUserToUsersJAXB(this.helper.findUsers(JAXBTransformUtil.userJAXBToUser(userJAXB)));
            if (users != null) {
                return Response.Builder.ok((Object)users, (String)XML_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Find users failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/userrange/{from}/{to}/")
    @InputTransformer(value=JAXBInputTransformer.class)
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response findUsersRange(@URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount, generated.User userJAXB) {
        try {
            Users users = JAXBTransformUtil.collectionUserToUsersJAXB(this.helper.findUsersRange(JAXBTransformUtil.userJAXBToUser(userJAXB), offset, amount));
            if (users != null) {
                return Response.Builder.ok((Object)users, (String)XML_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Find users failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groupsall/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getAllGroup() {
        try {
            return Response.Builder.ok((Object)JAXBTransformUtil.collectionGroupToGroupsJAXB(this.helper.getAllGroups()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get list of groups failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groupfilter/{filteredname}/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getFilteredGroup(@URIParam(value="filteredname") String filteredname) {
        try {
            return Response.Builder.ok((Object)JAXBTransformUtil.collectionGroupToGroupsJAXB(this.helper.getFilteredGroup(filteredname)), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get list of groups failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/{groupId}/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getGroup(@URIParam(value="groupId") String groupId) {
        try {
            GroupInfo groupInfo = JAXBTransformUtil.groupInfoToGroupInfoJAXB(this.helper.getGroupInfo(groupId));
            if (groupInfo != null) {
                return Response.Builder.ok((Object)groupInfo, (String)XML_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get info about group " + groupId + " failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groups/{parentId}/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getGroups(@URIParam(value="parentId") String parentId) {
        try {
            return Response.Builder.ok((Object)JAXBTransformUtil.collectionGroupToGroupsJAXB(this.helper.getGroups(parentId)), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get list of groups failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groupcount/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response getGroupsCount() {
        try {
            int count = this.helper.getGroupsCount();
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><count>" + count + "</count>";
            return Response.Builder.ok((Object)xml, (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get groups number failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groups-of-user/{username}/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getGroupsOfUser(@URIParam(value="username") String userId) {
        try {
            return Response.Builder.ok((Object)JAXBTransformUtil.collectionGroupToGroupsJAXB(this.helper.getGroupsOfUser(userId)), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get groups for user " + userId + " failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/grouprange/{parentId}/{from}/{to}/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getGroupsRange(@URIParam(value="parentId") String parentId, @URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount) {
        try {
            return Response.Builder.ok((Object)JAXBTransformUtil.collectionGroupToGroupsJAXB(this.helper.getGroupsRange(parentId, offset, amount)), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get groups range failed1").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membershiptypes/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getMembershipTypes() {
        try {
            return Response.Builder.ok((Object)JAXBTransformUtil.collectionMembershipTypesToMembershipTypesJAXB(this.helper.getMembershipTypes()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get membership types failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groups/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getRootGroups() {
        try {
            return Response.Builder.ok((Object)JAXBTransformUtil.collectionGroupToGroupsJAXB(this.helper.getGroups(null)), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get groups failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/{username}/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getUser(@URIParam(value="username") String userId) {
        try {
            User user = this.helper.getUser(userId);
            if (user != null) {
                return Response.Builder.ok((Object)JAXBTransformUtil.userToUserJAXB(user), (String)XML_CONTENT_TYPE).build();
            }
            return Response.Builder.notFound().errorMessage("User " + userId + " not found!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get user failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/users/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getUsers() {
        try {
            return Response.Builder.ok((Object)JAXBTransformUtil.collectionUserToUsersJAXB(this.helper.getUsers()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get users failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/usercount/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response getUsersCount() {
        try {
            int count = this.helper.getUsersCount();
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><count>" + count + "</count>";
            return Response.Builder.ok((Object)xml, (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get users number failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/userrange/{from}/{number}/")
    @OutputTransformer(value=JAXBOutputTransformer.class)
    public Response getUsersRange(@URIParam(value="from") Integer offset, @URIParam(value="number") Integer amount) {
        try {
            return Response.Builder.ok((Object)JAXBTransformUtil.collectionUserToUsersJAXB(this.helper.getUsersRange(offset, amount)), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get users failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=put")
    @URITemplate(value="/group/")
    @InputTransformer(value=JAXBInputTransformer.class)
    public Response updateGroup(generated.Group groupJAXB) {
        try {
            String groupId = this.helper.updateGroup(JAXBTransformUtil.groupJAXBToGroup(groupJAXB));
            if (groupId != null) {
                return Response.Builder.noContent().build();
            }
            return Response.Builder.notFound().errorMessage("Group " + groupJAXB.getId() + " not found!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Update group failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=put")
    @URITemplate(value="/user/")
    @InputTransformer(value=JAXBInputTransformer.class)
    public Response updateUser(generated.User userJAXB) {
        try {
            String userId = this.helper.updateUser(JAXBTransformUtil.userJAXBToUser(userJAXB));
            if (userId != null) {
                return Response.Builder.noContent().build();
            }
            return Response.Builder.notFound().errorMessage("User " + userJAXB.getUserName() + " not found!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Update user failed!").build();
        }
    }
}

