/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.html;

import generated.Membership;
import generated.User;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.rest.xml.RESTOrganizationServiceXMLImpl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.JAXBInputTransformer;
import org.exoplatform.services.rest.transformer.JAXBOutputTransformer;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;
import org.exoplatform.services.rest.transformer.XSLT4SourceOutputTransformer;

@URITemplate(value="/organization/html/")
public class RESTOrganizationServiceHTMLImpl
implements ResourceContainer {
    private static final Log LOGGER = ExoLogger.getLogger(RESTOrganizationServiceHTMLImpl.class);
    private RESTOrganizationServiceXMLImpl xmlImpl;
    protected static final String GROUP_INFO_SCHEMA = "group-info";
    protected static final String GROUP_EDIT_SCHEMA = "group-edit";
    protected static final String GROUPS_LIST_SCHEMA = "groups-list";
    protected static final String GROUPS_LIST_FRAGMENT_SCHEMA = "groups-list-fragment";
    protected static final String USER_INFO_SCHEMA = "user-info";
    protected static final String USERS_LIST_SCHEMA = "users-list";
    protected static final String USERS_LIST_SEARCH_SCHEMA = "users-list-search";
    protected static final String MEMBERSHIP_LIST_SCHEMA = "memberships-list";
    protected static final String MEMBERSHIPTYPE_LIST_SCHEMA = "membershiptypes-list";

    public RESTOrganizationServiceHTMLImpl(OrganizationService organizationService) {
        this.xmlImpl = new RESTOrganizationServiceXMLImpl(organizationService);
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/{membershipId}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response findMembership(@URIParam(value="membershipId") String membershipId) {
        Response response = this.xmlImpl.findMembership(membershipId);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, MEMBERSHIP_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/memberships/")
    @InputTransformer(value=JAXBInputTransformer.class)
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response findMemberships(Membership membreshipsJAXB) {
        Response response = this.xmlImpl.findMemberships(membreshipsJAXB);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, MEMBERSHIP_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/userlike/")
    @InputTransformer(value=JAXBInputTransformer.class)
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response findUsers(User userJAXB) {
        Response response = this.xmlImpl.findUsers(userJAXB);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USERS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/userrange/{from}/{to}/")
    @InputTransformer(value=JAXBInputTransformer.class)
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response findUsersRange(@URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount, User userJAXB) {
        Response response = this.xmlImpl.findUsersRange(offset, amount, userJAXB);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USERS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groupfilter/{filter}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getFilteredGroup(@URIParam(value="filter") String filter) {
        Response response = this.xmlImpl.getFilteredGroup(filter);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/{groupId}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroup(@URIParam(value="groupId") String groupId) {
        Response response = this.xmlImpl.getGroup(groupId);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            String schemaName = GROUP_INFO_SCHEMA;
            return this.modifyResponse(response, schemaName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groupsall/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroups() {
        Response response = this.xmlImpl.getAllGroup();
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/count/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroupsCount() {
        Response response = this.xmlImpl.getGroupsCount();
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groups-of-user/{username}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroupsOfUser(@QueryParam(value="username") String username) {
        Response response = this.xmlImpl.getGroupsOfUser(username);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/grouprange/{parentId}/{from}/{to}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getGroupsRange(@URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount, @QueryParam(value="parentId") String parentId) {
        Response response = this.xmlImpl.getGroupsRange(parentId, offset, amount);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_FRAGMENT_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/{username}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getUser(@URIParam(value="username") String username) {
        Response response = this.xmlImpl.getUser(username);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USER_INFO_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/users/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getUsers() {
        Response response = this.xmlImpl.getUsers();
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USERS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/count/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getUsersCount() {
        Response response = this.xmlImpl.getUsersCount();
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, GROUPS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/view-range/{from}/{number}/")
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response getUsersRange(@URIParam(value="from") Integer offset, @URIParam(value="number") Integer amount) {
        Response response = this.xmlImpl.getUsersRange(offset, amount);
        if (response.getStatus() != 200) {
            return response;
        }
        try {
            return this.modifyResponse(response, USERS_LIST_SCHEMA);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    private Response modifyResponse(final Response response, String xsltSchemaName) throws IOException {
        response.setTransformer((OutputEntityTransformer)new JAXBOutputTransformer());
        final PipedOutputStream po = new PipedOutputStream();
        PipedInputStream pi = new PipedInputStream(po);
        response.writeEntity((OutputStream)System.out);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    response.writeEntity((OutputStream)po);
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Thrown exception : " + e));
                }
                finally {
                    try {
                        po.flush();
                        po.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
        StreamSource s = new StreamSource(pi);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("xslt.template", xsltSchemaName);
        return Response.Builder.ok((Object)s, (String)"text/html").setTransformerParameters(p).build();
    }
}

