/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.json;

import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.rest.GroupInfo;
import org.exoplatform.services.organization.rest.OrganizationServiceHelper;
import org.exoplatform.services.organization.rest.json.Count;
import org.exoplatform.services.organization.rest.json.JSONTransformUtil;
import org.exoplatform.services.organization.rest.json.Memberships;
import org.exoplatform.services.organization.rest.json.Users;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryTemplate;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;

@URITemplate(value="/organization/json/")
public class RESTOrganizationServiceJSONImpl
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    private OrganizationServiceHelper helper;

    public RESTOrganizationServiceJSONImpl(OrganizationService organizationService) {
        this.helper = new OrganizationServiceHelper(organizationService);
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/newgroup/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response createGroup(@ContextParam(value="baseURI") String baseURI, GroupImpl groupBean) {
        String description;
        String label;
        String groupName;
        String parentId = groupBean.getParentId();
        Group group = this.helper.createGroup(parentId, groupName = groupBean.getGroupName(), label = groupBean.getLabel(), description = groupBean.getDescription());
        if (group != null) {
            return Response.Builder.created((String)(baseURI + "/organization/json/group/" + group.getId())).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Create group failed!").build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/newmembership/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response createMembership(@ContextParam(value="baseURI") String baseURI, MembershipImpl membershipBean) {
        String type;
        String groupId;
        String username = membershipBean.getUserName();
        Membership membership = this.helper.createMembership(username, groupId = membershipBean.getGroupId(), type = membershipBean.getMembershipType());
        if (membership != null) {
            return Response.Builder.created((String)(baseURI + "/organization/json/membership/" + membership.getId())).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Create group failed!").build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/newuser/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response createUser(@ContextParam(value="baseURI") String baseURI, UserImpl userBean) {
        String email;
        String lastname;
        String firstname;
        String password;
        String username = userBean.getUserName();
        User user = this.helper.createUser(username, password = userBean.getPassword(), firstname = userBean.getFirstName(), lastname = userBean.getLastName(), email = userBean.getEmail());
        if (user != null) {
            return Response.Builder.created((String)(baseURI + "/organization/json/user/" + user.getUserName())).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Create user failed!").build();
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=delete")
    @URITemplate(value="/group/{groupId}/")
    public Response deleteGroup(@URIParam(value="groupId") String groupId) {
        if (this.helper.deleteGroupd(groupId)) {
            return Response.Builder.noContent().build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Delete group failed!").build();
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=delete")
    @URITemplate(value="/membership/{membershipId}/")
    public Response deleteMembership(@URIParam(value="membershipId") String membershipId) {
        if (this.helper.deleteGroupd(membershipId)) {
            return Response.Builder.noContent().build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Delete membership failed!").build();
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=delete")
    @URITemplate(value="/user/{username}/")
    public Response deleteUser(@URIParam(value="username") String username) {
        if (this.helper.deleteUser(username)) {
            return Response.Builder.noContent().build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Delete user failed!").build();
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=delete")
    @URITemplate(value="/groups/{username}/{groupId}/")
    public Response deleteUserFromGroup(@URIParam(value="groupId") String groupId, @URIParam(value="username") String username) {
        if (this.helper.deleteUserFromGroup(username, groupId)) {
            return Response.Builder.noContent().build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Delete user " + username + " from group " + groupId + " failed!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/{membershipId}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findMembership(@URIParam(value="membershipId") String membershipId) {
        try {
            Membership membership = this.helper.findMembership(membershipId);
            if (membership != null) {
                return Response.Builder.ok((Object)membership, (String)JSON_CONTENT_TYPE).build();
            }
            return Response.Builder.notFound().errorMessage("Membership with id: '" + membershipId + "' not found!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Find membership failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/memberships/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findMemberships(MembershipImpl membership) {
        try {
            Memberships memberships = JSONTransformUtil.collectionMembershipToMemberships(this.helper.findMemberships((Membership)membership));
            if (memberships != null) {
                return Response.Builder.ok((Object)memberships, (String)JSON_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Find memberships failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/userlike/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findUsers(UserImpl user) {
        try {
            Users users = JSONTransformUtil.colectionUserToUsers(this.helper.findUsers((User)user));
            if (users != null) {
                return Response.Builder.ok((Object)users, (String)JSON_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Find users failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/userrange/{from}/{to}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findUsersRange(@URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount, UserImpl user) {
        try {
            Users users = JSONTransformUtil.colectionUserToUsers(this.helper.findUsersRange((User)user, offset, amount));
            if (users != null) {
                return Response.Builder.ok((Object)users, (String)JSON_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Find users failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groupsall/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getAllGroup() {
        try {
            return Response.Builder.ok((Object)JSONTransformUtil.collectionGroupToGroups(this.helper.getAllGroups()), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get list of groups failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groupfilter/{filteredname}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getFilteredGroup(@URIParam(value="filteredname") String filteredname) {
        try {
            return Response.Builder.ok((Object)JSONTransformUtil.collectionGroupToGroups(this.helper.getFilteredGroup(filteredname)), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get list of groups failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/{groupId}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroup(@URIParam(value="groupId") String groupId) {
        try {
            GroupInfo groupInfo = this.helper.getGroupInfo(groupId);
            if (groupInfo != null) {
                return Response.Builder.ok((Object)groupInfo, (String)JSON_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get info about group " + groupId + " failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groups/{parentId}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroups(@URIParam(value="parentId") String parentId) {
        try {
            return Response.Builder.ok((Object)JSONTransformUtil.collectionGroupToGroups(this.helper.getGroups(parentId)), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get list of groups failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groupcount/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroupsCount() {
        try {
            Count count = new Count(this.helper.getGroupsCount());
            return Response.Builder.ok((Object)count, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get groups number failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groups-of-user/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroupsOfUser(@URIParam(value="username") String userId) {
        try {
            return Response.Builder.ok((Object)JSONTransformUtil.collectionGroupToGroups(this.helper.getGroupsOfUser(userId)), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get groups for user " + userId + " failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/grouprange/{parentId}/{from}/{to}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getGroupsRange(@URIParam(value="parentId") String parentId, @URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount) {
        try {
            return Response.Builder.ok((Object)JSONTransformUtil.collectionGroupToGroups(this.helper.getGroupsRange(parentId, offset, amount)), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get groups range failed1").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membershiptypes/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getMembershipTypes() {
        try {
            return Response.Builder.ok((Object)JSONTransformUtil.collectionMembershipTypesToMembershipTypes(this.helper.getMembershipTypes()), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get membership types failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/groups/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRootGroups() {
        try {
            return Response.Builder.ok((Object)JSONTransformUtil.collectionGroupToGroups(this.helper.getGroups(null)), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get groups failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUser(@URIParam(value="username") String userId) {
        try {
            User user = this.helper.getUser(userId);
            if (user != null) {
                return Response.Builder.ok((Object)user, (String)JSON_CONTENT_TYPE).build();
            }
            return Response.Builder.notFound().errorMessage("User " + userId + " not found!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get user failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/users/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUsers() {
        try {
            return Response.Builder.ok((Object)JSONTransformUtil.colectionUserToUsers(this.helper.getUsers()), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get users failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/usercount/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUsersCount() {
        try {
            return Response.Builder.ok((Object)this.helper.getUsersCount(), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get users number failed!").build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/userrange/{from}/{number}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUsersRange(@URIParam(value="from") Integer offset, @URIParam(value="number") Integer amount) {
        try {
            return Response.Builder.ok((Object)JSONTransformUtil.colectionUserToUsers(this.helper.getUsersRange(offset, amount)), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Get users failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=put")
    @URITemplate(value="/group/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response updateGroup(GroupImpl group) {
        try {
            String groupId = this.helper.updateGroup((Group)group);
            if (groupId != null) {
                return Response.Builder.noContent().build();
            }
            return Response.Builder.notFound().errorMessage("Group " + group.getId() + " not found!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Update group failed!").build();
        }
    }

    @HTTPMethod(value="POST")
    @QueryTemplate(value="method=put")
    @URITemplate(value="/user/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response updateUser(UserImpl user) {
        try {
            String userId = this.helper.updateUser((User)user);
            if (userId != null) {
                return Response.Builder.noContent().build();
            }
            return Response.Builder.notFound().errorMessage("User " + user.getUserName() + " not found!").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)500).errorMessage("Update user failed!").build();
        }
    }
}

