/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.rest.samples;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.ws.rest.samples.Book;
import org.exoplatform.services.ws.rest.samples.BookStorage;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;

public class JsonBookService
implements ResourceContainer {
    private BookStorage bookStorage;
    private static final Log LOG = ExoLogger.getLogger((String)"ws.JsonBookService");

    public JsonBookService(BookStorage books) {
        this.bookStorage = books;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/json/{key}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response get(@URIParam(value="key") String key) {
        Book book = this.bookStorage.getBook(key);
        if (book == null) {
            return Response.Builder.notFound().build();
        }
        LOG.info((Object)("GET: " + book));
        LOG.info((Object)("In storage now: " + this.bookStorage.numberOfBooks()));
        return Response.Builder.ok((Object)this.bookStorage.getBook(key)).mediaType("application/json").build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/json/{key}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response post(@URIParam(value="key") String key, @ContextParam(value="baseURI") String baseURI, Book book) {
        LOG.info((Object)("POST: " + book));
        this.bookStorage.addBook(key, book);
        LOG.info((Object)("In storage now: " + this.bookStorage.numberOfBooks()));
        return Response.Builder.created((String)(baseURI + "json" + "/" + key)).build();
    }
}

