/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.rest.samples;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.ws.rest.samples.Book;
import org.exoplatform.services.ws.rest.samples.BookStorage;

@Path(value="/samples/json")
public class JsonBookService
implements ResourceContainer {
    private BookStorage bookStorage;
    private static final Log LOG = ExoLogger.getLogger((String)JsonBookService.class.getName());

    public JsonBookService(BookStorage books) {
        this.bookStorage = books;
    }

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public Book get(@PathParam(value="key") String key) {
        Book book = this.bookStorage.getBook(key);
        if (book == null) {
            throw new IllegalArgumentException("Book with supplied key " + key + " not found");
        }
        LOG.info((Object)("GET: " + book));
        LOG.info((Object)("In storage now: " + this.bookStorage.numberOfBooks()));
        return book;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response post(@Context UriInfo uriInfo, Book book) {
        LOG.info((Object)("POST: " + book));
        this.bookStorage.addBook(book.getIsdn(), book);
        LOG.info((Object)("In storage now: " + this.bookStorage.numberOfBooks()));
        URI location = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(this.getClass()).path(book.getIsdn()).build(new Object[0]);
        return Response.created((URI)location).build();
    }
}

