/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.IOException;
import org.exoplatform.common.http.client.HTTPClientModule;
import org.exoplatform.common.http.client.Log;
import org.exoplatform.common.http.client.MD5InputStream;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.common.http.client.Request;
import org.exoplatform.common.http.client.Response;
import org.exoplatform.common.http.client.RoRequest;
import org.exoplatform.common.http.client.Util;
import org.exoplatform.common.http.client.VerifyMD5;

class ContentMD5Module
implements HTTPClientModule {
    ContentMD5Module() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        if (req.getMethod().equals("HEAD")) {
            return;
        }
        String md5_digest = resp.getHeader("Content-MD5");
        String trailer = resp.getHeader("Trailer");
        boolean md5_tok = false;
        try {
            if (trailer != null) {
                md5_tok = Util.hasToken(trailer, "Content-MD5");
            }
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        if (md5_digest == null && !md5_tok || resp.getHeader("Transfer-Encoding") != null) {
            return;
        }
        if (md5_digest != null) {
            Log.write(32, "CMD5M: Received digest: " + md5_digest + " - pushing md5-check-stream");
        } else {
            Log.write(32, "CMD5M: Expecting digest in trailer  - pushing md5-check-stream");
        }
        resp.inp_stream = new MD5InputStream(resp.inp_stream, new VerifyMD5(resp));
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

