/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.TimeZone;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.services.log.ExoLogger;

public class Log {
    private static final org.exoplatform.services.log.Log LOG;
    public static final int CONN = 1;
    public static final int RESP = 2;
    public static final int DEMUX = 4;
    public static final int AUTH = 8;
    public static final int COOKI = 16;
    public static final int MODS = 32;
    public static final int SOCKS = 64;
    public static final int URLC = 128;
    public static final int ALL = -1;
    private static final String NL;
    private static final long TZ_OFF;
    private static int facMask;
    private static Writer logWriter;
    private static boolean closeWriter;

    private Log() {
    }

    public static void write(int facility, String msg) {
        if ((facMask & facility) == 0) {
            return;
        }
        try {
            Log.writePrefix();
            logWriter.write(msg);
            logWriter.write(NL);
            logWriter.flush();
        }
        catch (IOException ioe) {
            LOG.error((Object)("Failed to write to log: " + String.valueOf(ioe)), (Throwable)ioe);
            LOG.error((Object)("Failed log Entry was: " + msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(int facility, String prefix, Throwable t) {
        if ((facMask & facility) == 0) {
            return;
        }
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (!(logWriter instanceof PrintWriter)) {
                logWriter = new PrintWriter(logWriter);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            try {
                Log.writePrefix();
                if (prefix != null) {
                    logWriter.write(prefix);
                }
                t.printStackTrace((PrintWriter)logWriter);
                logWriter.flush();
            }
            catch (IOException ioe) {
                LOG.error((Object)("Failed to write to log: " + String.valueOf(ioe)), (Throwable)ioe);
                LOG.error((Object)("Failed log Entry was: " + prefix));
                LOG.error((Object)t.getLocalizedMessage(), t);
            }
            return;
        }
    }

    public static void write(int facility, String prefix, ByteArrayOutputStream buf) {
        if ((facMask & facility) == 0) {
            return;
        }
        try {
            Log.writePrefix();
            if (prefix != null) {
                logWriter.write(prefix);
            }
            logWriter.write(NL);
            logWriter.write(new String(buf.toByteArray(), "ISO_8859-1"));
            logWriter.flush();
        }
        catch (IOException ioe) {
            LOG.error((Object)("Failed to write to log: " + String.valueOf(ioe)), (Throwable)ioe);
            LOG.error((Object)("Failed log Entry was: " + prefix));
            LOG.error((Object)new String(buf.toByteArray()));
        }
    }

    private static final void writePrefix() throws IOException {
        logWriter.write("{" + Thread.currentThread().getName() + "} ");
        int mill = (int)((System.currentTimeMillis() + TZ_OFF) % 86400000L);
        int secs = mill / 1000;
        int mins = secs / 60;
        int hours = mins / 60;
        logWriter.write("[" + Log.fill2(hours) + ":" + Log.fill2(mins - hours * 60) + ":" + Log.fill2(secs - mins * 60) + "." + Log.fill3(mill - secs * 1000) + "] ");
    }

    private static final String fill2(int num) {
        return (num < 10 ? "0" : "") + num;
    }

    private static final String fill3(int num) {
        return (num < 10 ? "00" : (num < 100 ? "0" : "")) + num;
    }

    public static boolean isEnabled(int facility) {
        return (facMask & facility) != 0;
    }

    public static void setLogging(int facilities, boolean enable) {
        facMask = enable ? (facMask |= facilities) : (facMask &= ~facilities);
    }

    public static void setLogWriter(Writer log, boolean closeWhenDone) {
        if (log == null) {
            return;
        }
        if (closeWriter) {
            try {
                logWriter.close();
            }
            catch (IOException ioe) {
                LOG.error((Object)("Error closing log stream: " + String.valueOf(ioe)), (Throwable)ioe);
            }
        }
        logWriter = log;
        closeWriter = closeWhenDone;
    }

    static {
        block8: {
            block7: {
                LOG = ExoLogger.getLogger((String)"org.exoplatform.common.http.client.Log");
                NL = PrivilegedSystemHelper.getProperty((String)"line.separator");
                facMask = 0;
                logWriter = new OutputStreamWriter(System.err);
                closeWriter = false;
                Calendar now = Calendar.getInstance();
                TZ_OFF = TimeZone.getDefault().getOffset(now.get(0), now.get(1), now.get(2), now.get(5), now.get(7), now.get(14));
                try {
                    String file = PrivilegedSystemHelper.getProperty((String)"HTTPClient.log.file");
                    if (file != null) {
                        try {
                            Log.setLogWriter(new FileWriter(file), true);
                        }
                        catch (IOException ioe) {
                            LOG.error((Object)("failed to open file log stream `" + file + "': " + String.valueOf(ioe)), (Throwable)ioe);
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isTraceEnabled()) break block7;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            try {
                facMask = Integer.getInteger("HTTPClient.log.mask", 0);
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) break block8;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
    }
}

