/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtils {
    private static final Map<String, Types> knownTypes = new HashMap<String, Types>();

    public static String getJsonString(String string) {
        char[] charArray;
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        block9: for (char c : charArray = string.toCharArray()) {
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                default: {
                    if (c < '\u0010') {
                        sb.append("\\u000" + Integer.toHexString(c));
                        continue block9;
                    }
                    if (c < ' ' && c > '\t' || c >= '\u0080' && c < '\u00a0') {
                        sb.append("\\u00" + Integer.toHexString(c));
                        continue block9;
                    }
                    if (c >= '\u2000' && c < '\u2100') {
                        sb.append("\\u" + Integer.toHexString(c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    public static boolean isKnownType(Object o) {
        if (o == null) {
            return true;
        }
        return JsonUtils.isKnownType(o.getClass());
    }

    public static boolean isKnownType(Class<?> clazz) {
        return knownTypes.get(clazz.getName()) != null;
    }

    public static Types getType(Object o) {
        if (o == null) {
            return Types.NULL;
        }
        if (knownTypes.get(o.getClass().getName()) != null) {
            return knownTypes.get(o.getClass().getName());
        }
        if (o instanceof Object[]) {
            return Types.ARRAY_OBJECT;
        }
        if (o instanceof Collection) {
            return Types.COLLECTION;
        }
        if (o instanceof Map) {
            return Types.MAP;
        }
        return null;
    }

    public static Types getType(Class<?> clazz) {
        if (knownTypes.get(clazz.getName()) != null) {
            return knownTypes.get(clazz.getName());
        }
        if (clazz.isArray()) {
            return Types.ARRAY_OBJECT;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Types.COLLECTION;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Types.MAP;
        }
        return null;
    }

    static {
        knownTypes.put(Boolean.class.getName(), Types.BOOLEAN);
        knownTypes.put(Byte.class.getName(), Types.BYTE);
        knownTypes.put(Short.class.getName(), Types.SHORT);
        knownTypes.put(Integer.class.getName(), Types.INT);
        knownTypes.put(Long.class.getName(), Types.LONG);
        knownTypes.put(Float.class.getName(), Types.FLOAT);
        knownTypes.put(Double.class.getName(), Types.DOUBLE);
        knownTypes.put(Character.class.getName(), Types.CHAR);
        knownTypes.put(String.class.getName(), Types.STRING);
        knownTypes.put("boolean", Types.BOOLEAN);
        knownTypes.put("byte", Types.BYTE);
        knownTypes.put("short", Types.SHORT);
        knownTypes.put("int", Types.INT);
        knownTypes.put("long", Types.LONG);
        knownTypes.put("float", Types.FLOAT);
        knownTypes.put("double", Types.DOUBLE);
        knownTypes.put("char", Types.CHAR);
        knownTypes.put("null", Types.NULL);
        knownTypes.put(new boolean[0].getClass().getName(), Types.ARRAY_BOOLEAN);
        knownTypes.put(new byte[0].getClass().getName(), Types.ARRAY_BYTE);
        knownTypes.put(new short[0].getClass().getName(), Types.ARRAY_SHORT);
        knownTypes.put(new int[0].getClass().getName(), Types.ARRAY_INT);
        knownTypes.put(new long[0].getClass().getName(), Types.ARRAY_LONG);
        knownTypes.put(new double[0].getClass().getName(), Types.ARRAY_DOUBLE);
        knownTypes.put(new float[0].getClass().getName(), Types.ARRAY_FLOAT);
        knownTypes.put(new char[0].getClass().getName(), Types.ARRAY_CHAR);
        knownTypes.put(new String[0].getClass().getName(), Types.ARRAY_STRING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JsonToken {
        object,
        array,
        key,
        value;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Types {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        CHAR,
        STRING,
        NULL,
        ARRAY_BYTE,
        ARRAY_SHORT,
        ARRAY_INT,
        ARRAY_LONG,
        ARRAY_FLOAT,
        ARRAY_DOUBLE,
        ARRAY_BOOLEAN,
        ARRAY_CHAR,
        ARRAY_STRING,
        ARRAY_OBJECT,
        COLLECTION,
        MAP;

    }
}

