/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Stack;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.JsonParser;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;

public class JsonParserImpl
implements JsonParser {
    private JsonHandler jsonHandler;
    private PushbackReader pushbackReader;
    private Stack<JsonUtils.JsonToken> jsonTokens = new Stack();

    public void parse(Reader reader, JsonHandler handler) throws JsonException {
        this.jsonHandler = handler;
        this.pushbackReader = new PushbackReader(reader);
        try {
            char c = '\u0000';
            while ((c = this.next()) != '\u0000') {
                if (c == '{') {
                    this.readObject();
                    continue;
                }
                throw new JsonException("Syntax error. Unexpected '" + c + "'. Must be '{'.");
            }
            if (!this.jsonTokens.isEmpty()) {
                throw new JsonException("Syntax error. Missing one or more close bracket(s).");
            }
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public void parse(InputStream sream, JsonHandler handler) throws JsonException {
        this.parse(new InputStreamReader(sream, Charset.forName("UTF-8")), handler);
    }

    private void readObject() throws JsonException {
        char c = '\u0000';
        this.jsonHandler.startObject();
        this.jsonTokens.push(JsonUtils.JsonToken.object);
        block11: while (true) {
            c = this.next();
            switch (c) {
                case '\u0000': {
                    throw new JsonException("Syntax error. Unexpected end of object. Object must end by '}'.");
                }
                case '{': {
                    this.readObject();
                    continue block11;
                }
                case '}': {
                    this.jsonHandler.endObject();
                    if (JsonUtils.JsonToken.object != this.jsonTokens.pop()) {
                        throw new JsonException("Syntax error. Unexpected end of object.");
                    }
                    c = this.next();
                    switch (c) {
                        case '\u0000': {
                            break;
                        }
                        case ',': 
                        case ']': 
                        case '}': {
                            this.back(c);
                            break;
                        }
                        default: {
                            throw new JsonException("Syntax error. Excpected for ',' or ']' or '}' but found '" + c + "'.");
                        }
                    }
                    return;
                }
                case '[': {
                    this.readArray();
                    continue block11;
                }
                case ',': {
                    continue block11;
                }
            }
            this.back(c);
            this.readKey();
            this.next(':');
            c = this.next();
            this.back(c);
            if (c == '{' || c == '[') continue;
            this.readValue();
        }
    }

    private void readArray() throws JsonException {
        char c = '\u0000';
        this.jsonHandler.startArray();
        this.jsonTokens.push(JsonUtils.JsonToken.array);
        block7: while (true) {
            c = this.next();
            switch (c) {
                case '\u0000': {
                    throw new JsonException("Syntax error. Unexpected end of array. Array must end by ']'.");
                }
                case ']': {
                    this.jsonHandler.endArray();
                    if (JsonUtils.JsonToken.array != this.jsonTokens.pop()) {
                        throw new JsonException("Syntax error. Unexpected end of array.");
                    }
                    c = this.next(",]}");
                    this.back(c);
                    return;
                }
                case '[': {
                    this.readArray();
                    continue block7;
                }
                case '{': {
                    this.readObject();
                    continue block7;
                }
                case ',': {
                    continue block7;
                }
            }
            this.back(c);
            this.readValue();
        }
    }

    private void readKey() throws JsonException {
        char c = this.next();
        if (c != '\"') {
            throw new JsonException("Syntax error. Key must start from quote, but found '" + c + "'.");
        }
        this.back(c);
        String s = new String(this.nextString());
        if (s.length() == 2) {
            throw new JsonException("Missing key.");
        }
        this.jsonHandler.key(s.substring(1, s.length() - 1));
    }

    private void readValue() throws JsonException {
        char c = this.next();
        this.back(c);
        if (c == '\"') {
            this.jsonHandler.characters(this.nextString());
        } else {
            CharArrayWriter cw = new CharArrayWriter();
            while ("{[,]}\"".indexOf(c = this.next()) < 0) {
                if (c == '\u0000') {
                    throw new JsonException("Unexpected end of stream.");
                }
                cw.append(c);
            }
            this.back(c);
            this.jsonHandler.characters(cw.toCharArray());
        }
        c = this.next(",]}");
        this.back(c);
    }

    private char next() throws JsonException {
        try {
            int c = 0;
            while ((c = this.pushbackReader.read()) != -1) {
                if (c == 47) {
                    c = this.pushbackReader.read();
                    if (c == 47) {
                        while ((c = this.pushbackReader.read()) != -1 && c != 10 && c != 13) {
                        }
                        continue;
                    }
                    if (c == 42) {
                        while ((c = this.pushbackReader.read()) != 42 || (c = this.pushbackReader.read()) != 47) {
                            if (c != -1) continue;
                            throw new JsonException("Syntax error. Missing end of comment.");
                        }
                        continue;
                    }
                    this.back((char)c);
                    return '/';
                }
                if (c != -1 && c <= 32) continue;
            }
            return c == -1 ? (char)'\u0000' : (char)c;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    private char nextAny() throws JsonException {
        try {
            int c = this.pushbackReader.read();
            return c == -1 ? (char)'\u0000' : (char)c;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    private char next(char c) throws JsonException {
        char n = this.next();
        if (n != c) {
            throw new JsonException("Expected for '" + c + "' but found '" + n + "'.");
        }
        return n;
    }

    private char next(String s) throws JsonException {
        char n = this.next();
        if (s.indexOf(n) >= 0) {
            return n;
        }
        char[] ch = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (char c : ch) {
            if (i > 0) {
                sb.append(" or ");
            }
            ++i;
            sb.append('\'').append(c).append('\'');
        }
        throw new JsonException("Expected for " + sb.toString() + " but found '" + n + "'.");
    }

    private char[] next(int n) throws JsonException {
        char[] buff = new char[n];
        try {
            int i = this.pushbackReader.read(buff);
            if (i == -1) {
                throw new JsonException("Unexpected end of stream.");
            }
            return buff;
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    private char[] nextString() throws JsonException {
        CharArrayWriter cw = new CharArrayWriter();
        char c = this.nextAny();
        cw.append(c);
        block13: while (true) {
            c = this.nextAny();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw new JsonException("Syntax error. Unterminated string.");
                }
                case '\\': {
                    c = this.nextAny();
                    switch (c) {
                        case '\u0000': 
                        case '\n': 
                        case '\r': {
                            throw new JsonException("Syntax error. Unterminated string");
                        }
                        case 'n': {
                            cw.append('\n');
                            continue block13;
                        }
                        case 'r': {
                            cw.append('\r');
                            continue block13;
                        }
                        case 'b': {
                            cw.append('\b');
                            continue block13;
                        }
                        case 't': {
                            cw.append('\t');
                            continue block13;
                        }
                        case 'f': {
                            cw.append('\f');
                            continue block13;
                        }
                        case 'u': {
                            String s = new String(this.next(4));
                            cw.append((char)Integer.parseInt(s, 16));
                            continue block13;
                        }
                    }
                    cw.append(c);
                    continue block13;
                }
            }
            cw.append(c);
            if (c == '\"') break;
        }
        return cw.toCharArray();
    }

    private void back(char c) throws JsonException {
        try {
            this.pushbackReader.unread(c);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }
}

