/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.groovy.control.CompilationFailedException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.ext.groovy.ExtendedGroovyClassLoader;
import org.exoplatform.services.rest.ext.groovy.GroovyClassLoaderProvider;
import org.exoplatform.services.rest.ext.groovy.MalformedScriptException;
import org.exoplatform.services.rest.ext.groovy.ResourceId;
import org.exoplatform.services.rest.ext.groovy.SourceFile;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.impl.ResourcePublicationException;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.uri.UriPattern;
import org.exoplatform.services.script.groovy.GroovyScriptInstantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyJaxrsPublisher {
    private static final Log LOG = ExoLogger.getExoLogger(GroovyJaxrsPublisher.class);
    private static final Comparator<Constructor> constructorComparator = new Comparator<Constructor>(){

        @Override
        public int compare(Constructor o1, Constructor o2) {
            int c2;
            int c1 = o1.getParameterTypes().length;
            if (c1 < (c2 = o2.getParameterTypes().length)) {
                return 1;
            }
            if (c1 > c2) {
                return -1;
            }
            return 0;
        }
    };
    protected static final String DEFAULT_CHARSET_NAME = "UTF-8";
    protected static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    protected final ResourceBinder binder;
    protected final GroovyScriptInstantiator instantiator;
    protected final GroovyClassLoaderProvider classLoaderProvider;
    protected final Map<ResourceId, String> resources = Collections.synchronizedMap(new HashMap());

    public GroovyJaxrsPublisher(ResourceBinder binder, GroovyScriptInstantiator instantiator, GroovyClassLoaderProvider classLoaderProvider) {
        this.binder = binder;
        this.instantiator = instantiator;
        this.classLoaderProvider = classLoaderProvider;
    }

    public GroovyJaxrsPublisher(ResourceBinder binder, GroovyScriptInstantiator instantiator) {
        this(binder, instantiator, new GroovyClassLoaderProvider());
    }

    @Deprecated
    public GroovyClassLoader getGroovyClassLoader() {
        return this.classLoaderProvider.getGroovyClassLoader();
    }

    @Deprecated
    public void setGroovyClassLoader(GroovyClassLoader gcl) {
        LOG.warn((Object)"Method setGroovyClassLoader is deprecated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectFactory<AbstractResourceDescriptor> getResource(ResourceId resourceId) {
        List rootResources;
        String path = this.resources.get(resourceId);
        if (path == null) {
            return null;
        }
        UriPattern pattern = new UriPattern(path);
        List list = rootResources = this.binder.getResources();
        synchronized (list) {
            for (ObjectFactory res : rootResources) {
                if (!((AbstractResourceDescriptor)res.getObjectModel()).getUriPattern().equals((Object)pattern)) continue;
                return res;
            }
        }
        this.resources.remove(resourceId);
        return null;
    }

    public boolean isPublished(ResourceId resourceId) {
        return null != this.getResource(resourceId);
    }

    public void publishPerRequest(InputStream in, ResourceId resourceId, MultivaluedMap<String, String> properties) {
        this.publishPerRequest(in, resourceId, properties, null, null);
    }

    public void publishPerRequest(final InputStream in, final ResourceId resourceId, MultivaluedMap<String, String> properties, final SourceFolder[] src, final SourceFile[] files) {
        Class rc = (Class)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ExtendedGroovyClassLoader cl = src == null ? GroovyJaxrsPublisher.this.classLoaderProvider.getGroovyClassLoader() : GroovyJaxrsPublisher.this.classLoaderProvider.getGroovyClassLoader(src);
                    return cl.parseClass(in, resourceId.getId(), files);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        });
        this.binder.addResource(rc, properties);
        this.resources.put(resourceId, rc.getAnnotation(Path.class).value());
    }

    public final void publishPerRequest(String source, ResourceId resourceId, MultivaluedMap<String, String> properties) {
        this.publishPerRequest(source, DEFAULT_CHARSET, resourceId, properties, null, null);
    }

    public final void publishPerRequest(String source, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        this.publishPerRequest(source, DEFAULT_CHARSET, resourceId, properties, src, files);
    }

    public final void publishPerRequest(String source, String charset, ResourceId resourceId, MultivaluedMap<String, String> properties) {
        this.publishPerRequest(source, charset == null ? DEFAULT_CHARSET : Charset.forName(charset), resourceId, properties, null, null);
    }

    public final void publishPerRequest(String source, String charset, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        this.publishPerRequest(source, charset == null ? DEFAULT_CHARSET : Charset.forName(charset), resourceId, properties, src, files);
    }

    public void publishSingleton(InputStream in, ResourceId resourceId, MultivaluedMap<String, String> properties) {
        this.publishSingleton(in, resourceId, properties, null, null);
    }

    public void publishSingleton(InputStream in, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        Object resource;
        try {
            ExtendedGroovyClassLoader cl = src == null ? this.classLoaderProvider.getGroovyClassLoader() : this.classLoaderProvider.getGroovyClassLoader(src);
            Class clazz = cl.parseClass(in, resourceId.getId(), files);
            resource = this.createInstance(clazz);
        }
        catch (IllegalArgumentException e) {
            throw new ResourcePublicationException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ResourcePublicationException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResourcePublicationException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ResourcePublicationException(e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.binder.addResource(resource, properties);
        this.resources.put(resourceId, resource.getClass().getAnnotation(Path.class).value());
    }

    public final void publishSingleton(String source, ResourceId resourceId, MultivaluedMap<String, String> properties) {
        this.publishSingleton(source, DEFAULT_CHARSET, resourceId, properties, null, null);
    }

    public final void publishSingleton(String source, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        this.publishSingleton(source, DEFAULT_CHARSET, resourceId, properties, src, files);
    }

    public final void publishSingleton(String source, String charset, ResourceId resourceId, MultivaluedMap<String, String> properties) {
        this.publishSingleton(source, charset == null ? DEFAULT_CHARSET : Charset.forName(charset), resourceId, properties, null, null);
    }

    public final void publishSingleton(String source, String charset, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        this.publishSingleton(source, charset == null ? DEFAULT_CHARSET : Charset.forName(charset), resourceId, properties, src, files);
    }

    public ObjectFactory<AbstractResourceDescriptor> unpublishResource(ResourceId resourceId) {
        String path = this.resources.get(resourceId);
        if (path == null) {
            return null;
        }
        ObjectFactory resource = this.binder.removeResource(path);
        if (resource != null) {
            this.resources.remove(resourceId);
        }
        return resource;
    }

    public void validateResource(final InputStream in, final String name, final SourceFolder[] src, final SourceFile[] files) throws MalformedScriptException {
        try {
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws MalformedURLException {
                    ExtendedGroovyClassLoader cl = src == null ? GroovyJaxrsPublisher.this.classLoaderProvider.getGroovyClassLoader() : GroovyJaxrsPublisher.this.classLoaderProvider.getGroovyClassLoader(src);
                    return cl.parseClass(in, name != null && name.length() > 0 ? name : cl.generateScriptName(), files);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            throw new IllegalArgumentException(cause.getMessage(), e);
        }
        catch (CompilationFailedException e) {
            throw new MalformedScriptException(e.getMessage());
        }
    }

    public void validateResource(InputStream in, String name) throws MalformedScriptException {
        this.validateResource(in, name, null, null);
    }

    public final void validateResource(String source, String charset, String name, SourceFolder[] src, SourceFile[] files) throws MalformedScriptException {
        this.validateResource(source, charset == null ? DEFAULT_CHARSET : Charset.forName(charset), name, src, files);
    }

    public final void validateResource(String source, String name, SourceFolder[] src, SourceFile[] files) throws MalformedScriptException {
        this.validateResource(source, DEFAULT_CHARSET, name, src, files);
    }

    public final void validateResource(String source, String name) throws MalformedScriptException {
        this.validateResource(source, DEFAULT_CHARSET, name, null, null);
    }

    protected Object createInstance(Class clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        Constructor<?>[] constructors = clazz.getConstructors();
        Arrays.sort(constructors, constructorComparator);
        block0: for (Constructor<?> c : constructors) {
            Class<?>[] parameterTypes = c.getParameterTypes();
            if (parameterTypes.length == 0) {
                return c.newInstance(new Object[0]);
            }
            Object[] parameters = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object param = container.getComponentInstanceOfType(parameterTypes[i]);
                if (param == null) continue block0;
                parameters[i] = param;
            }
            return c.newInstance(parameters);
        }
        throw new ResourcePublicationException("Unbale create instance of class " + clazz.getName() + ". Required constructor's dependencies can't be resolved. ");
    }

    private void publishPerRequest(String source, Charset charset, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        byte[] bytes = source.getBytes(charset);
        this.publishPerRequest(new ByteArrayInputStream(bytes), resourceId, properties, src, files);
    }

    private void publishSingleton(String source, Charset charset, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        byte[] bytes = source.getBytes(charset);
        this.publishSingleton(new ByteArrayInputStream(bytes), resourceId, properties, src, files);
    }

    private void validateResource(String source, Charset charset, String name, SourceFolder[] src, SourceFile[] files) throws MalformedScriptException {
        byte[] bytes = source.getBytes(charset);
        this.validateResource(new ByteArrayInputStream(bytes), name, src, files);
    }

    protected GroovyCodeSource createCodeSource(final InputStream in, final String name) {
        GroovyCodeSource gcs = (GroovyCodeSource)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<GroovyCodeSource>(){

            @Override
            public GroovyCodeSource run() {
                return new GroovyCodeSource(in, name, "/groovy/script/jaxrs");
            }
        });
        gcs.setCachable(false);
        return gcs;
    }
}

