/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.groovy;

import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.ext.BaseTest;
import org.exoplatform.services.rest.ext.groovy.BaseResourceId;
import org.exoplatform.services.rest.ext.groovy.ResourceId;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;

public class GroovySimpleTest
extends BaseTest {
    @Override
    public void tearDown() throws Exception {
        this.groovyPublisher.resources.clear();
        super.tearDown();
    }

    public void testPerRequest() throws Exception {
        this.publicationTest(false, (ResourceId)new BaseResourceId("g1"));
    }

    public void testSingleton() throws Exception {
        this.publicationTest(true, (ResourceId)new BaseResourceId("g2"));
    }

    private void publicationTest(boolean singleton, ResourceId resourceId) throws Exception {
        String script = "@javax.ws.rs.Path(\"a\")class GroovyResource {@javax.ws.rs.GET @javax.ws.rs.Path(\"{who}\")def m0(@javax.ws.rs.PathParam(\"who\") String who) { return (\"hello \" + who)}}";
        GroovySimpleTest.assertEquals((int)0, (int)this.binder.getSize());
        GroovySimpleTest.assertEquals((int)0, (int)this.groovyPublisher.resources.size());
        if (singleton) {
            this.groovyPublisher.publishSingleton(script, resourceId, null);
        } else {
            this.groovyPublisher.publishPerRequest(script, resourceId, null);
        }
        GroovySimpleTest.assertEquals((int)1, (int)this.binder.getSize());
        GroovySimpleTest.assertEquals((int)1, (int)this.groovyPublisher.resources.size());
        GroovySimpleTest.assertTrue((boolean)this.groovyPublisher.isPublished(resourceId));
        String cs = ((AbstractResourceDescriptor)((ObjectFactory)this.binder.getResources().get(0)).getObjectModel()).getObjectClass().getProtectionDomain().getCodeSource().getLocation().toString();
        GroovySimpleTest.assertEquals((String)"file:/groovy/script/jaxrs", (String)cs);
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/a/groovy", "", null, null, (ContainerResponseWriter)writer, null);
        GroovySimpleTest.assertEquals((int)200, (int)resp.getStatus());
        GroovySimpleTest.assertEquals((String)"hello groovy", (String)new String(writer.getBody()));
        this.groovyPublisher.unpublishResource(resourceId);
        GroovySimpleTest.assertEquals((int)0, (int)this.binder.getSize());
        GroovySimpleTest.assertEquals((int)0, (int)this.groovyPublisher.resources.size());
    }
}

