/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.groovy;

import java.io.InputStream;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.ext.BaseTest;
import org.exoplatform.services.rest.ext.groovy.BaseResourceId;
import org.exoplatform.services.rest.ext.groovy.ResourceId;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;

public class GroovyExoComponentTest
extends BaseTest {
    private InputStream script;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.container.registerComponentInstance((Object)Component1.class.getName(), (Object)new Component1());
        this.script = Thread.currentThread().getContextClassLoader().getResourceAsStream("groovy2.groovy");
        GroovyExoComponentTest.assertNotNull((Object)this.script);
    }

    @Override
    public void tearDown() throws Exception {
        this.container.unregisterComponent((Object)Component1.class.getName());
        this.groovyPublisher.resources.clear();
        super.tearDown();
    }

    public void testExoComponentPerRequest() throws Exception {
        this.containerComponentTest(false, (ResourceId)new BaseResourceId("g1"));
    }

    public void testExoComponentSingleton() throws Exception {
        this.containerComponentTest(true, (ResourceId)new BaseResourceId("g2"));
    }

    private void containerComponentTest(boolean singleton, ResourceId resourceId) throws Exception {
        GroovyExoComponentTest.assertEquals((int)0, (int)this.binder.getSize());
        GroovyExoComponentTest.assertEquals((int)0, (int)this.groovyPublisher.resources.size());
        if (singleton) {
            this.groovyPublisher.publishSingleton(this.script, resourceId, null);
        } else {
            this.groovyPublisher.publishPerRequest(this.script, resourceId, null);
        }
        GroovyExoComponentTest.assertEquals((int)1, (int)this.binder.getSize());
        GroovyExoComponentTest.assertEquals((int)1, (int)this.groovyPublisher.resources.size());
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/a/b", "", null, null, (ContainerResponseWriter)writer, null);
        GroovyExoComponentTest.assertEquals((int)200, (int)resp.getStatus());
        GroovyExoComponentTest.assertEquals((String)"exo container's component", (String)new String(writer.getBody()));
    }

    public static class Component1 {
        public String getName() {
            return "exo container's component";
        }
    }
}

